<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Receive ServiceType
 * @subpackage Services
 */
class Receive extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named receiveRemandedItem
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $saleCode
     * @param string $lang
     * @return \StructType\MessageServiceResponse|bool
     */
    public function receiveRemandedItem($apiKey, $sign, $time, $saleCode, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->receiveRemandedItem($apiKey, $sign, $time, $saleCode, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MessageServiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
