<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for accountTransactionListResponse StructType
 * @subpackage Structs
 */
class AccountTransactionListResponse extends BaseResponse
{
    /**
     * The totalCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $totalCount;
    /**
     * The sales
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Sales
     */
    public $sales;
    /**
     * Constructor method for accountTransactionListResponse
     * @uses AccountTransactionListResponse::setTotalCount()
     * @uses AccountTransactionListResponse::setSales()
     * @param int $totalCount
     * @param \StructType\Sales $sales
     */
    public function __construct($totalCount = null, \StructType\Sales $sales = null)
    {
        $this
            ->setTotalCount($totalCount)
            ->setSales($sales);
    }
    /**
     * Get totalCount value
     * @return int|null
     */
    public function getTotalCount()
    {
        return $this->totalCount;
    }
    /**
     * Set totalCount value
     * @param int $totalCount
     * @return \StructType\AccountTransactionListResponse
     */
    public function setTotalCount($totalCount = null)
    {
        // validation for constraint: int
        if (!is_null($totalCount) && !(is_int($totalCount) || ctype_digit($totalCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalCount, true), gettype($totalCount)), __LINE__);
        }
        $this->totalCount = $totalCount;
        return $this;
    }
    /**
     * Get sales value
     * @return \StructType\Sales|null
     */
    public function getSales()
    {
        return $this->sales;
    }
    /**
     * Set sales value
     * @param \StructType\Sales $sales
     * @return \StructType\AccountTransactionListResponse
     */
    public function setSales(\StructType\Sales $sales = null)
    {
        $this->sales = $sales;
        return $this;
    }
}
