<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for accountTransactionV2Type StructType
 * @subpackage Structs
 */
class AccountTransactionV2Type extends AbstractStructBase
{
    /**
     * The saleCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $saleCode;
    /**
     * The productId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $productId;
    /**
     * The productTitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $productTitle;
    /**
     * The buyerNick
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $buyerNick;
    /**
     * The price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $price;
    /**
     * The commissionPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $commissionPrice;
    /**
     * The ggCommission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ggCommission;
    /**
     * The dailyOfferCommission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $dailyOfferCommission;
    /**
     * The paidPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $paidPrice;
    /**
     * The approveDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $approveDate;
    /**
     * The approve
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $approve;
    /**
     * The accountNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accountNumber;
    /**
     * The iban
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $iban;
    /**
     * Constructor method for accountTransactionV2Type
     * @uses AccountTransactionV2Type::setSaleCode()
     * @uses AccountTransactionV2Type::setProductId()
     * @uses AccountTransactionV2Type::setProductTitle()
     * @uses AccountTransactionV2Type::setBuyerNick()
     * @uses AccountTransactionV2Type::setPrice()
     * @uses AccountTransactionV2Type::setCommissionPrice()
     * @uses AccountTransactionV2Type::setGgCommission()
     * @uses AccountTransactionV2Type::setDailyOfferCommission()
     * @uses AccountTransactionV2Type::setPaidPrice()
     * @uses AccountTransactionV2Type::setApproveDate()
     * @uses AccountTransactionV2Type::setApprove()
     * @uses AccountTransactionV2Type::setAccountNumber()
     * @uses AccountTransactionV2Type::setIban()
     * @param string $saleCode
     * @param int $productId
     * @param string $productTitle
     * @param string $buyerNick
     * @param float $price
     * @param float $commissionPrice
     * @param float $ggCommission
     * @param float $dailyOfferCommission
     * @param float $paidPrice
     * @param string $approveDate
     * @param string $approve
     * @param string $accountNumber
     * @param string $iban
     */
    public function __construct($saleCode = null, $productId = null, $productTitle = null, $buyerNick = null, $price = null, $commissionPrice = null, $ggCommission = null, $dailyOfferCommission = null, $paidPrice = null, $approveDate = null, $approve = null, $accountNumber = null, $iban = null)
    {
        $this
            ->setSaleCode($saleCode)
            ->setProductId($productId)
            ->setProductTitle($productTitle)
            ->setBuyerNick($buyerNick)
            ->setPrice($price)
            ->setCommissionPrice($commissionPrice)
            ->setGgCommission($ggCommission)
            ->setDailyOfferCommission($dailyOfferCommission)
            ->setPaidPrice($paidPrice)
            ->setApproveDate($approveDate)
            ->setApprove($approve)
            ->setAccountNumber($accountNumber)
            ->setIban($iban);
    }
    /**
     * Get saleCode value
     * @return string|null
     */
    public function getSaleCode()
    {
        return $this->saleCode;
    }
    /**
     * Set saleCode value
     * @param string $saleCode
     * @return \StructType\AccountTransactionV2Type
     */
    public function setSaleCode($saleCode = null)
    {
        // validation for constraint: string
        if (!is_null($saleCode) && !is_string($saleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleCode, true), gettype($saleCode)), __LINE__);
        }
        $this->saleCode = $saleCode;
        return $this;
    }
    /**
     * Get productId value
     * @return int|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param int $productId
     * @return \StructType\AccountTransactionV2Type
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !(is_int($productId) || ctype_digit($productId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get productTitle value
     * @return string|null
     */
    public function getProductTitle()
    {
        return $this->productTitle;
    }
    /**
     * Set productTitle value
     * @param string $productTitle
     * @return \StructType\AccountTransactionV2Type
     */
    public function setProductTitle($productTitle = null)
    {
        // validation for constraint: string
        if (!is_null($productTitle) && !is_string($productTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productTitle, true), gettype($productTitle)), __LINE__);
        }
        $this->productTitle = $productTitle;
        return $this;
    }
    /**
     * Get buyerNick value
     * @return string|null
     */
    public function getBuyerNick()
    {
        return $this->buyerNick;
    }
    /**
     * Set buyerNick value
     * @param string $buyerNick
     * @return \StructType\AccountTransactionV2Type
     */
    public function setBuyerNick($buyerNick = null)
    {
        // validation for constraint: string
        if (!is_null($buyerNick) && !is_string($buyerNick)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buyerNick, true), gettype($buyerNick)), __LINE__);
        }
        $this->buyerNick = $buyerNick;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\AccountTransactionV2Type
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get commissionPrice value
     * @return float|null
     */
    public function getCommissionPrice()
    {
        return $this->commissionPrice;
    }
    /**
     * Set commissionPrice value
     * @param float $commissionPrice
     * @return \StructType\AccountTransactionV2Type
     */
    public function setCommissionPrice($commissionPrice = null)
    {
        // validation for constraint: float
        if (!is_null($commissionPrice) && !(is_float($commissionPrice) || is_numeric($commissionPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($commissionPrice, true), gettype($commissionPrice)), __LINE__);
        }
        $this->commissionPrice = $commissionPrice;
        return $this;
    }
    /**
     * Get ggCommission value
     * @return float|null
     */
    public function getGgCommission()
    {
        return $this->ggCommission;
    }
    /**
     * Set ggCommission value
     * @param float $ggCommission
     * @return \StructType\AccountTransactionV2Type
     */
    public function setGgCommission($ggCommission = null)
    {
        // validation for constraint: float
        if (!is_null($ggCommission) && !(is_float($ggCommission) || is_numeric($ggCommission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ggCommission, true), gettype($ggCommission)), __LINE__);
        }
        $this->ggCommission = $ggCommission;
        return $this;
    }
    /**
     * Get dailyOfferCommission value
     * @return float|null
     */
    public function getDailyOfferCommission()
    {
        return $this->dailyOfferCommission;
    }
    /**
     * Set dailyOfferCommission value
     * @param float $dailyOfferCommission
     * @return \StructType\AccountTransactionV2Type
     */
    public function setDailyOfferCommission($dailyOfferCommission = null)
    {
        // validation for constraint: float
        if (!is_null($dailyOfferCommission) && !(is_float($dailyOfferCommission) || is_numeric($dailyOfferCommission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dailyOfferCommission, true), gettype($dailyOfferCommission)), __LINE__);
        }
        $this->dailyOfferCommission = $dailyOfferCommission;
        return $this;
    }
    /**
     * Get paidPrice value
     * @return float|null
     */
    public function getPaidPrice()
    {
        return $this->paidPrice;
    }
    /**
     * Set paidPrice value
     * @param float $paidPrice
     * @return \StructType\AccountTransactionV2Type
     */
    public function setPaidPrice($paidPrice = null)
    {
        // validation for constraint: float
        if (!is_null($paidPrice) && !(is_float($paidPrice) || is_numeric($paidPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($paidPrice, true), gettype($paidPrice)), __LINE__);
        }
        $this->paidPrice = $paidPrice;
        return $this;
    }
    /**
     * Get approveDate value
     * @return string|null
     */
    public function getApproveDate()
    {
        return $this->approveDate;
    }
    /**
     * Set approveDate value
     * @param string $approveDate
     * @return \StructType\AccountTransactionV2Type
     */
    public function setApproveDate($approveDate = null)
    {
        // validation for constraint: string
        if (!is_null($approveDate) && !is_string($approveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approveDate, true), gettype($approveDate)), __LINE__);
        }
        $this->approveDate = $approveDate;
        return $this;
    }
    /**
     * Get approve value
     * @return string|null
     */
    public function getApprove()
    {
        return $this->approve;
    }
    /**
     * Set approve value
     * @param string $approve
     * @return \StructType\AccountTransactionV2Type
     */
    public function setApprove($approve = null)
    {
        // validation for constraint: string
        if (!is_null($approve) && !is_string($approve)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approve, true), gettype($approve)), __LINE__);
        }
        $this->approve = $approve;
        return $this;
    }
    /**
     * Get accountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->accountNumber;
    }
    /**
     * Set accountNumber value
     * @param string $accountNumber
     * @return \StructType\AccountTransactionV2Type
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->accountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get iban value
     * @return string|null
     */
    public function getIban()
    {
        return $this->iban;
    }
    /**
     * Set iban value
     * @param string $iban
     * @return \StructType\AccountTransactionV2Type
     */
    public function setIban($iban = null)
    {
        // validation for constraint: string
        if (!is_null($iban) && !is_string($iban)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iban, true), gettype($iban)), __LINE__);
        }
        $this->iban = $iban;
        return $this;
    }
}
