<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for specs StructType
 * @subpackage Structs
 */
class Specs extends AbstractStructBase
{
    /**
     * The spec
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VariantSpecDto[]
     */
    public $spec;
    /**
     * Constructor method for specs
     * @uses Specs::setSpec()
     * @param \StructType\VariantSpecDto[] $spec
     */
    public function __construct(array $spec = array())
    {
        $this
            ->setSpec($spec);
    }
    /**
     * Get spec value
     * @return \StructType\VariantSpecDto[]|null
     */
    public function getSpec()
    {
        return $this->spec;
    }
    /**
     * This method is responsible for validating the values passed to the setSpec method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpec method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecForArrayConstraintsFromSetSpec(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $specsSpecItem) {
            // validation for constraint: itemType
            if (!$specsSpecItem instanceof \StructType\VariantSpecDto) {
                $invalidValues[] = is_object($specsSpecItem) ? get_class($specsSpecItem) : sprintf('%s(%s)', gettype($specsSpecItem), var_export($specsSpecItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The spec property can only contain items of type \StructType\VariantSpecDto, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set spec value
     * @throws \InvalidArgumentException
     * @param \StructType\VariantSpecDto[] $spec
     * @return \StructType\Specs
     */
    public function setSpec(array $spec = array())
    {
        // validation for constraint: array
        if ('' !== ($specArrayErrorMessage = self::validateSpecForArrayConstraintsFromSetSpec($spec))) {
            throw new \InvalidArgumentException($specArrayErrorMessage, __LINE__);
        }
        $this->spec = $spec;
        return $this;
    }
    /**
     * Add item to spec value
     * @throws \InvalidArgumentException
     * @param \StructType\VariantSpecDto $item
     * @return \StructType\Specs
     */
    public function addToSpec(\StructType\VariantSpecDto $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VariantSpecDto) {
            throw new \InvalidArgumentException(sprintf('The spec property can only contain items of type \StructType\VariantSpecDto, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->spec[] = $item;
        return $this;
    }
}
