<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for saleInvoiceType StructType
 * @subpackage Structs
 */
class SaleInvoiceType extends AbstractStructBase
{
    /**
     * The fullname
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fullname;
    /**
     * The address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $address;
    /**
     * The district
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $district;
    /**
     * The cityCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $cityCode;
    /**
     * The zipCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $zipCode;
    /**
     * The phoneNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $phoneNumber;
    /**
     * The taxOffice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxOffice;
    /**
     * The taxNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxNumber;
    /**
     * The companyTitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $companyTitle;
    /**
     * The tcCertificate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tcCertificate;
    /**
     * Constructor method for saleInvoiceType
     * @uses SaleInvoiceType::setFullname()
     * @uses SaleInvoiceType::setAddress()
     * @uses SaleInvoiceType::setDistrict()
     * @uses SaleInvoiceType::setCityCode()
     * @uses SaleInvoiceType::setZipCode()
     * @uses SaleInvoiceType::setPhoneNumber()
     * @uses SaleInvoiceType::setTaxOffice()
     * @uses SaleInvoiceType::setTaxNumber()
     * @uses SaleInvoiceType::setCompanyTitle()
     * @uses SaleInvoiceType::setTcCertificate()
     * @param string $fullname
     * @param string $address
     * @param string $district
     * @param int $cityCode
     * @param string $zipCode
     * @param string $phoneNumber
     * @param string $taxOffice
     * @param string $taxNumber
     * @param string $companyTitle
     * @param string $tcCertificate
     */
    public function __construct($fullname = null, $address = null, $district = null, $cityCode = null, $zipCode = null, $phoneNumber = null, $taxOffice = null, $taxNumber = null, $companyTitle = null, $tcCertificate = null)
    {
        $this
            ->setFullname($fullname)
            ->setAddress($address)
            ->setDistrict($district)
            ->setCityCode($cityCode)
            ->setZipCode($zipCode)
            ->setPhoneNumber($phoneNumber)
            ->setTaxOffice($taxOffice)
            ->setTaxNumber($taxNumber)
            ->setCompanyTitle($companyTitle)
            ->setTcCertificate($tcCertificate);
    }
    /**
     * Get fullname value
     * @return string|null
     */
    public function getFullname()
    {
        return $this->fullname;
    }
    /**
     * Set fullname value
     * @param string $fullname
     * @return \StructType\SaleInvoiceType
     */
    public function setFullname($fullname = null)
    {
        // validation for constraint: string
        if (!is_null($fullname) && !is_string($fullname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fullname, true), gettype($fullname)), __LINE__);
        }
        $this->fullname = $fullname;
        return $this;
    }
    /**
     * Get address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param string $address
     * @return \StructType\SaleInvoiceType
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Get district value
     * @return string|null
     */
    public function getDistrict()
    {
        return $this->district;
    }
    /**
     * Set district value
     * @param string $district
     * @return \StructType\SaleInvoiceType
     */
    public function setDistrict($district = null)
    {
        // validation for constraint: string
        if (!is_null($district) && !is_string($district)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($district, true), gettype($district)), __LINE__);
        }
        $this->district = $district;
        return $this;
    }
    /**
     * Get cityCode value
     * @return int|null
     */
    public function getCityCode()
    {
        return $this->cityCode;
    }
    /**
     * Set cityCode value
     * @param int $cityCode
     * @return \StructType\SaleInvoiceType
     */
    public function setCityCode($cityCode = null)
    {
        // validation for constraint: int
        if (!is_null($cityCode) && !(is_int($cityCode) || ctype_digit($cityCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cityCode, true), gettype($cityCode)), __LINE__);
        }
        $this->cityCode = $cityCode;
        return $this;
    }
    /**
     * Get zipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->zipCode;
    }
    /**
     * Set zipCode value
     * @param string $zipCode
     * @return \StructType\SaleInvoiceType
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipCode, true), gettype($zipCode)), __LINE__);
        }
        $this->zipCode = $zipCode;
        return $this;
    }
    /**
     * Get phoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->phoneNumber;
    }
    /**
     * Set phoneNumber value
     * @param string $phoneNumber
     * @return \StructType\SaleInvoiceType
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneNumber, true), gettype($phoneNumber)), __LINE__);
        }
        $this->phoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get taxOffice value
     * @return string|null
     */
    public function getTaxOffice()
    {
        return $this->taxOffice;
    }
    /**
     * Set taxOffice value
     * @param string $taxOffice
     * @return \StructType\SaleInvoiceType
     */
    public function setTaxOffice($taxOffice = null)
    {
        // validation for constraint: string
        if (!is_null($taxOffice) && !is_string($taxOffice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxOffice, true), gettype($taxOffice)), __LINE__);
        }
        $this->taxOffice = $taxOffice;
        return $this;
    }
    /**
     * Get taxNumber value
     * @return string|null
     */
    public function getTaxNumber()
    {
        return $this->taxNumber;
    }
    /**
     * Set taxNumber value
     * @param string $taxNumber
     * @return \StructType\SaleInvoiceType
     */
    public function setTaxNumber($taxNumber = null)
    {
        // validation for constraint: string
        if (!is_null($taxNumber) && !is_string($taxNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxNumber, true), gettype($taxNumber)), __LINE__);
        }
        $this->taxNumber = $taxNumber;
        return $this;
    }
    /**
     * Get companyTitle value
     * @return string|null
     */
    public function getCompanyTitle()
    {
        return $this->companyTitle;
    }
    /**
     * Set companyTitle value
     * @param string $companyTitle
     * @return \StructType\SaleInvoiceType
     */
    public function setCompanyTitle($companyTitle = null)
    {
        // validation for constraint: string
        if (!is_null($companyTitle) && !is_string($companyTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyTitle, true), gettype($companyTitle)), __LINE__);
        }
        $this->companyTitle = $companyTitle;
        return $this;
    }
    /**
     * Get tcCertificate value
     * @return string|null
     */
    public function getTcCertificate()
    {
        return $this->tcCertificate;
    }
    /**
     * Set tcCertificate value
     * @param string $tcCertificate
     * @return \StructType\SaleInvoiceType
     */
    public function setTcCertificate($tcCertificate = null)
    {
        // validation for constraint: string
        if (!is_null($tcCertificate) && !is_string($tcCertificate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tcCertificate, true), gettype($tcCertificate)), __LINE__);
        }
        $this->tcCertificate = $tcCertificate;
        return $this;
    }
}
