<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for shippingPaymentType EnumType
 * @subpackage Enumerations
 */
class ShippingPaymentType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'BUYER'
     * @return string 'BUYER'
     */
    const VALUE_BUYER = 'BUYER';
    /**
     * Constant for value 'SELLER'
     * @return string 'SELLER'
     */
    const VALUE_SELLER = 'SELLER';
    /**
     * Constant for value 'PAY_IN_THE_BASKET'
     * @return string 'PAY_IN_THE_BASKET'
     */
    const VALUE_PAY_IN_THE_BASKET = 'PAY_IN_THE_BASKET';
    /**
     * Constant for value 'PLATFORM'
     * @return string 'PLATFORM'
     */
    const VALUE_PLATFORM = 'PLATFORM';
    /**
     * Return allowed values
     * @uses self::VALUE_BUYER
     * @uses self::VALUE_SELLER
     * @uses self::VALUE_PAY_IN_THE_BASKET
     * @uses self::VALUE_PLATFORM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BUYER,
            self::VALUE_SELLER,
            self::VALUE_PAY_IN_THE_BASKET,
            self::VALUE_PLATFORM,
        );
    }
}
