<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for variantDto StructType
 * @subpackage Structs
 */
class VariantDto extends AbstractStructBase
{
    /**
     * The image
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ImageDto
     */
    public $image;
    /**
     * The productId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $productId;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $quantity;
    /**
     * The soldQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $soldQuantity;
    /**
     * The specs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Specs
     */
    public $specs;
    /**
     * The stockCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $stockCode;
    /**
     * The variantId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $variantId;
    /**
     * The catalog
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ProductCatalogDto
     */
    public $catalog;
    /**
     * Constructor method for variantDto
     * @uses VariantDto::setImage()
     * @uses VariantDto::setProductId()
     * @uses VariantDto::setQuantity()
     * @uses VariantDto::setSoldQuantity()
     * @uses VariantDto::setSpecs()
     * @uses VariantDto::setStockCode()
     * @uses VariantDto::setVariantId()
     * @uses VariantDto::setCatalog()
     * @param \StructType\ImageDto $image
     * @param int $productId
     * @param int $quantity
     * @param int $soldQuantity
     * @param \StructType\Specs $specs
     * @param string $stockCode
     * @param int $variantId
     * @param \StructType\ProductCatalogDto $catalog
     */
    public function __construct(\StructType\ImageDto $image = null, $productId = null, $quantity = null, $soldQuantity = null, \StructType\Specs $specs = null, $stockCode = null, $variantId = null, \StructType\ProductCatalogDto $catalog = null)
    {
        $this
            ->setImage($image)
            ->setProductId($productId)
            ->setQuantity($quantity)
            ->setSoldQuantity($soldQuantity)
            ->setSpecs($specs)
            ->setStockCode($stockCode)
            ->setVariantId($variantId)
            ->setCatalog($catalog);
    }
    /**
     * Get image value
     * @return \StructType\ImageDto|null
     */
    public function getImage()
    {
        return $this->image;
    }
    /**
     * Set image value
     * @param \StructType\ImageDto $image
     * @return \StructType\VariantDto
     */
    public function setImage(\StructType\ImageDto $image = null)
    {
        $this->image = $image;
        return $this;
    }
    /**
     * Get productId value
     * @return int|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param int $productId
     * @return \StructType\VariantDto
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !(is_int($productId) || ctype_digit($productId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return \StructType\VariantDto
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get soldQuantity value
     * @return int|null
     */
    public function getSoldQuantity()
    {
        return $this->soldQuantity;
    }
    /**
     * Set soldQuantity value
     * @param int $soldQuantity
     * @return \StructType\VariantDto
     */
    public function setSoldQuantity($soldQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($soldQuantity) && !(is_int($soldQuantity) || ctype_digit($soldQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($soldQuantity, true), gettype($soldQuantity)), __LINE__);
        }
        $this->soldQuantity = $soldQuantity;
        return $this;
    }
    /**
     * Get specs value
     * @return \StructType\Specs|null
     */
    public function getSpecs()
    {
        return $this->specs;
    }
    /**
     * Set specs value
     * @param \StructType\Specs $specs
     * @return \StructType\VariantDto
     */
    public function setSpecs(\StructType\Specs $specs = null)
    {
        $this->specs = $specs;
        return $this;
    }
    /**
     * Get stockCode value
     * @return string|null
     */
    public function getStockCode()
    {
        return $this->stockCode;
    }
    /**
     * Set stockCode value
     * @param string $stockCode
     * @return \StructType\VariantDto
     */
    public function setStockCode($stockCode = null)
    {
        // validation for constraint: string
        if (!is_null($stockCode) && !is_string($stockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stockCode, true), gettype($stockCode)), __LINE__);
        }
        $this->stockCode = $stockCode;
        return $this;
    }
    /**
     * Get variantId value
     * @return int|null
     */
    public function getVariantId()
    {
        return $this->variantId;
    }
    /**
     * Set variantId value
     * @param int $variantId
     * @return \StructType\VariantDto
     */
    public function setVariantId($variantId = null)
    {
        // validation for constraint: int
        if (!is_null($variantId) && !(is_int($variantId) || ctype_digit($variantId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($variantId, true), gettype($variantId)), __LINE__);
        }
        $this->variantId = $variantId;
        return $this;
    }
    /**
     * Get catalog value
     * @return \StructType\ProductCatalogDto|null
     */
    public function getCatalog()
    {
        return $this->catalog;
    }
    /**
     * Set catalog value
     * @param \StructType\ProductCatalogDto $catalog
     * @return \StructType\VariantDto
     */
    public function setCatalog(\StructType\ProductCatalogDto $catalog = null)
    {
        $this->catalog = $catalog;
        return $this;
    }
}
