<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for accountTransactionFvfCommissionType StructType
 * @subpackage Structs
 */
class AccountTransactionFvfCommissionType extends AbstractStructBase
{
    /**
     * The revenue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $revenue;
    /**
     * The commissionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $commissionType;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $rate;
    /**
     * Constructor method for accountTransactionFvfCommissionType
     * @uses AccountTransactionFvfCommissionType::setRevenue()
     * @uses AccountTransactionFvfCommissionType::setCommissionType()
     * @uses AccountTransactionFvfCommissionType::setRate()
     * @param float $revenue
     * @param string $commissionType
     * @param float $rate
     */
    public function __construct($revenue = null, $commissionType = null, $rate = null)
    {
        $this
            ->setRevenue($revenue)
            ->setCommissionType($commissionType)
            ->setRate($rate);
    }
    /**
     * Get revenue value
     * @return float|null
     */
    public function getRevenue()
    {
        return $this->revenue;
    }
    /**
     * Set revenue value
     * @param float $revenue
     * @return \StructType\AccountTransactionFvfCommissionType
     */
    public function setRevenue($revenue = null)
    {
        // validation for constraint: float
        if (!is_null($revenue) && !(is_float($revenue) || is_numeric($revenue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($revenue, true), gettype($revenue)), __LINE__);
        }
        $this->revenue = $revenue;
        return $this;
    }
    /**
     * Get commissionType value
     * @return string|null
     */
    public function getCommissionType()
    {
        return $this->commissionType;
    }
    /**
     * Set commissionType value
     * @param string $commissionType
     * @return \StructType\AccountTransactionFvfCommissionType
     */
    public function setCommissionType($commissionType = null)
    {
        // validation for constraint: string
        if (!is_null($commissionType) && !is_string($commissionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commissionType, true), gettype($commissionType)), __LINE__);
        }
        $this->commissionType = $commissionType;
        return $this;
    }
    /**
     * Get rate value
     * @return float|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param float $rate
     * @return \StructType\AccountTransactionFvfCommissionType
     */
    public function setRate($rate = null)
    {
        // validation for constraint: float
        if (!is_null($rate) && !(is_float($rate) || is_numeric($rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
}
