<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for giftInfoType StructType
 * @subpackage Structs
 */
class GiftInfoType extends AbstractStructBase
{
    /**
     * The appliesTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $appliesTo;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $value;
    /**
     * Constructor method for giftInfoType
     * @uses GiftInfoType::setAppliesTo()
     * @uses GiftInfoType::setType()
     * @uses GiftInfoType::setValue()
     * @param string $appliesTo
     * @param string $type
     * @param float $value
     */
    public function __construct($appliesTo = null, $type = null, $value = null)
    {
        $this
            ->setAppliesTo($appliesTo)
            ->setType($type)
            ->setValue($value);
    }
    /**
     * Get appliesTo value
     * @return string|null
     */
    public function getAppliesTo()
    {
        return $this->appliesTo;
    }
    /**
     * Set appliesTo value
     * @uses \EnumType\AppliesTo::valueIsValid()
     * @uses \EnumType\AppliesTo::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $appliesTo
     * @return \StructType\GiftInfoType
     */
    public function setAppliesTo($appliesTo = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AppliesTo::valueIsValid($appliesTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AppliesTo', is_array($appliesTo) ? implode(', ', $appliesTo) : var_export($appliesTo, true), implode(', ', \EnumType\AppliesTo::getValidValues())), __LINE__);
        }
        $this->appliesTo = $appliesTo;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\Type::valueIsValid()
     * @uses \EnumType\Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\GiftInfoType
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Type::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Type', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\Type::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get value value
     * @return float|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param float $value
     * @return \StructType\GiftInfoType
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
}
