<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for combinedSaleCodes StructType
 * @subpackage Structs
 */
class CombinedSaleCodes extends AbstractStructBase
{
    /**
     * The saleCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $saleCode;
    /**
     * Constructor method for combinedSaleCodes
     * @uses CombinedSaleCodes::setSaleCode()
     * @param string[] $saleCode
     */
    public function __construct(array $saleCode = array())
    {
        $this
            ->setSaleCode($saleCode);
    }
    /**
     * Get saleCode value
     * @return string[]|null
     */
    public function getSaleCode()
    {
        return $this->saleCode;
    }
    /**
     * This method is responsible for validating the values passed to the setSaleCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSaleCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSaleCodeForArrayConstraintsFromSetSaleCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $combinedSaleCodesSaleCodeItem) {
            // validation for constraint: itemType
            if (!is_string($combinedSaleCodesSaleCodeItem)) {
                $invalidValues[] = is_object($combinedSaleCodesSaleCodeItem) ? get_class($combinedSaleCodesSaleCodeItem) : sprintf('%s(%s)', gettype($combinedSaleCodesSaleCodeItem), var_export($combinedSaleCodesSaleCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The saleCode property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set saleCode value
     * @throws \InvalidArgumentException
     * @param string[] $saleCode
     * @return \StructType\CombinedSaleCodes
     */
    public function setSaleCode(array $saleCode = array())
    {
        // validation for constraint: array
        if ('' !== ($saleCodeArrayErrorMessage = self::validateSaleCodeForArrayConstraintsFromSetSaleCode($saleCode))) {
            throw new \InvalidArgumentException($saleCodeArrayErrorMessage, __LINE__);
        }
        $this->saleCode = $saleCode;
        return $this;
    }
    /**
     * Add item to saleCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\CombinedSaleCodes
     */
    public function addToSaleCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The saleCode property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->saleCode[] = $item;
        return $this;
    }
}
