<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Give ServiceType
 * @subpackage Services
 */
class Give extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named giveApprovalForRemandedItem
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $saleCode
     * @param string $lang
     * @return \StructType\MessageServiceResponse|bool
     */
    public function giveApprovalForRemandedItem($apiKey, $sign, $time, $saleCode, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->giveApprovalForRemandedItem($apiKey, $sign, $time, $saleCode, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named giveRateAndComment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $userType
     * @param string $productId
     * @param string $rate
     * @param string $comment
     * @param string $lang
     * @return \StructType\CommonSaleResponse|bool
     */
    public function giveRateAndComment($apiKey, $sign, $time, $userType, $productId, $rate, $comment, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->giveRateAndComment($apiKey, $sign, $time, $userType, $productId, $rate, $comment, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CommonSaleResponse|\StructType\MessageServiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
