<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for reasons StructType
 * @subpackage Structs
 */
class Reasons extends AbstractStructBase
{
    /**
     * The reason
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SaleReasonType[]
     */
    public $reason;
    /**
     * Constructor method for reasons
     * @uses Reasons::setReason()
     * @param \StructType\SaleReasonType[] $reason
     */
    public function __construct(array $reason = array())
    {
        $this
            ->setReason($reason);
    }
    /**
     * Get reason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SaleReasonType[]|null
     */
    public function getReason()
    {
        return isset($this->reason) ? $this->reason : null;
    }
    /**
     * This method is responsible for validating the values passed to the setReason method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReason method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReasonForArrayConstraintsFromSetReason(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $reasonsReasonItem) {
            // validation for constraint: itemType
            if (!$reasonsReasonItem instanceof \StructType\SaleReasonType) {
                $invalidValues[] = is_object($reasonsReasonItem) ? get_class($reasonsReasonItem) : sprintf('%s(%s)', gettype($reasonsReasonItem), var_export($reasonsReasonItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The reason property can only contain items of type \StructType\SaleReasonType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set reason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SaleReasonType[] $reason
     * @return \StructType\Reasons
     */
    public function setReason(array $reason = array())
    {
        // validation for constraint: array
        if ('' !== ($reasonArrayErrorMessage = self::validateReasonForArrayConstraintsFromSetReason($reason))) {
            throw new \InvalidArgumentException($reasonArrayErrorMessage, __LINE__);
        }
        if (is_null($reason) || (is_array($reason) && empty($reason))) {
            unset($this->reason);
        } else {
            $this->reason = $reason;
        }
        return $this;
    }
    /**
     * Add item to reason value
     * @throws \InvalidArgumentException
     * @param \StructType\SaleReasonType $item
     * @return \StructType\Reasons
     */
    public function addToReason(\StructType\SaleReasonType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SaleReasonType) {
            throw new \InvalidArgumentException(sprintf('The reason property can only contain items of type \StructType\SaleReasonType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->reason[] = $item;
        return $this;
    }
}
