<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://dev.gittigidiyor.com:8080/listingapi/ws/IndividualSaleService?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://dev.gittigidiyor.com:8080/listingapi/ws/IndividualSaleService?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \ServiceType\Cancel($options);
/**
 * Sample call for cancelSale operation/method
 */
if ($cancel->cancelSale($apiKey, $sign, $time, $saleCode, $reasonId, $lang) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Sample call for cancelSaleAfterEarlyCancellationRequest operation/method
 */
if ($cancel->cancelSaleAfterEarlyCancellationRequest($apiKey, $sign, $time, $saleCode, $lang) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getAccountTransactions operation/method
 */
if ($get->getAccountTransactions($apiKey, $sign, $time, $startDate, $endDate, $startOffSet, $rowCount, $lang) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAccountTransactionsV2 operation/method
 */
if ($get->getAccountTransactionsV2($apiKey, $sign, $time, $startDate, $endDate, $startOffSet, $rowCount, $lang) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getItemBuyers operation/method
 */
if ($get->getItemBuyers($apiKey, $sign, $time, $byStatus, $startOffSet, $rowCount, $lang) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPagedSales operation/method
 */
if ($get->getPagedSales($apiKey, $sign, $time, $withData, $byStatus, $byUser, $orderBy, $orderType, $pageNumber, $pageSize, $lang) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPagedSalesByDateRange operation/method
 */
if ($get->getPagedSalesByDateRange($apiKey, $sign, $time, $withData, $byStatus, $byUser, $orderBy, $orderType, $startDate, $endDate, $pageNumber, $pageSize, $lang) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getReasonsToCancelSale operation/method
 */
if ($get->getReasonsToCancelSale($apiKey, $sign, $time, $lang) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSale operation/method
 */
if ($get->getSale($apiKey, $sign, $time, $saleCode, $lang) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSaleProcessReport operation/method
 */
if ($get->getSaleProcessReport($apiKey, $sign, $time, $startDate, $endDate, $startOffSet, $rowCount, $lang) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSales operation/method
 */
if ($get->getSales($apiKey, $sign, $time, $withData, $byStatus, $byUser, $orderBy, $orderType, $pageNumber, $pageSize, $lang) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSalesByDateRange operation/method
 */
if ($get->getSalesByDateRange($apiKey, $sign, $time, $withData, $byStatus, $byUser, $orderBy, $orderType, $startDate, $endDate, $pageNumber, $pageSize, $lang) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getServiceName operation/method
 */
if ($get->getServiceName() !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Give ServiceType
 */
$give = new \ServiceType\Give($options);
/**
 * Sample call for giveApprovalForRemandedItem operation/method
 */
if ($give->giveApprovalForRemandedItem($apiKey, $sign, $time, $saleCode, $lang) !== false) {
    print_r($give->getResult());
} else {
    print_r($give->getLastError());
}
/**
 * Sample call for giveRateAndComment operation/method
 */
if ($give->giveRateAndComment($apiKey, $sign, $time, $userType, $productId, $rate, $comment, $lang) !== false) {
    print_r($give->getResult());
} else {
    print_r($give->getLastError());
}
/**
 * Samples for Receive ServiceType
 */
$receive = new \ServiceType\Receive($options);
/**
 * Sample call for receiveRemandedItem operation/method
 */
if ($receive->receiveRemandedItem($apiKey, $sign, $time, $saleCode, $lang) !== false) {
    print_r($receive->getResult());
} else {
    print_r($receive->getLastError());
}
/**
 * Samples for Remind ServiceType
 */
$remind = new \ServiceType\Remind($options);
/**
 * Sample call for remindForApproval operation/method
 */
if ($remind->remindForApproval($apiKey, $sign, $time, $saleCode, $lang) !== false) {
    print_r($remind->getResult());
} else {
    print_r($remind->getLastError());
}
/**
 * Samples for Remove ServiceType
 */
$remove = new \ServiceType\Remove($options);
/**
 * Sample call for removeSaleFromList operation/method
 */
if ($remove->removeSaleFromList($apiKey, $sign, $time, $saleCode, $userType, $lang) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Samples for Reply ServiceType
 */
$reply = new \ServiceType\Reply($options);
/**
 * Sample call for replySaleComment operation/method
 */
if ($reply->replySaleComment($apiKey, $sign, $time, $userType, $productId, $comment, $lang) !== false) {
    print_r($reply->getResult());
} else {
    print_r($reply->getLastError());
}
