<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for shippingInfoType StructType
 * @subpackage Structs
 */
class ShippingInfoType extends AbstractStructBase
{
    /**
     * The deliveryOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $deliveryOption;
    /**
     * The shippingFirmName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shippingFirmName;
    /**
     * The shippingFirmId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $shippingFirmId;
    /**
     * The combinedShipping
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $combinedShipping;
    /**
     * The cargoCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cargoCode;
    /**
     * The combinedSaleCodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CombinedSaleCodes
     */
    public $combinedSaleCodes;
    /**
     * The shippingExpireDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shippingExpireDate;
    /**
     * Constructor method for shippingInfoType
     * @uses ShippingInfoType::setDeliveryOption()
     * @uses ShippingInfoType::setShippingFirmName()
     * @uses ShippingInfoType::setShippingFirmId()
     * @uses ShippingInfoType::setCombinedShipping()
     * @uses ShippingInfoType::setCargoCode()
     * @uses ShippingInfoType::setCombinedSaleCodes()
     * @uses ShippingInfoType::setShippingExpireDate()
     * @param string $deliveryOption
     * @param string $shippingFirmName
     * @param int $shippingFirmId
     * @param string $combinedShipping
     * @param string $cargoCode
     * @param \StructType\CombinedSaleCodes $combinedSaleCodes
     * @param string $shippingExpireDate
     */
    public function __construct($deliveryOption = null, $shippingFirmName = null, $shippingFirmId = null, $combinedShipping = null, $cargoCode = null, \StructType\CombinedSaleCodes $combinedSaleCodes = null, $shippingExpireDate = null)
    {
        $this
            ->setDeliveryOption($deliveryOption)
            ->setShippingFirmName($shippingFirmName)
            ->setShippingFirmId($shippingFirmId)
            ->setCombinedShipping($combinedShipping)
            ->setCargoCode($cargoCode)
            ->setCombinedSaleCodes($combinedSaleCodes)
            ->setShippingExpireDate($shippingExpireDate);
    }
    /**
     * Get deliveryOption value
     * @return string|null
     */
    public function getDeliveryOption()
    {
        return $this->deliveryOption;
    }
    /**
     * Set deliveryOption value
     * @param string $deliveryOption
     * @return \StructType\ShippingInfoType
     */
    public function setDeliveryOption($deliveryOption = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryOption) && !is_string($deliveryOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryOption, true), gettype($deliveryOption)), __LINE__);
        }
        $this->deliveryOption = $deliveryOption;
        return $this;
    }
    /**
     * Get shippingFirmName value
     * @return string|null
     */
    public function getShippingFirmName()
    {
        return $this->shippingFirmName;
    }
    /**
     * Set shippingFirmName value
     * @param string $shippingFirmName
     * @return \StructType\ShippingInfoType
     */
    public function setShippingFirmName($shippingFirmName = null)
    {
        // validation for constraint: string
        if (!is_null($shippingFirmName) && !is_string($shippingFirmName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingFirmName, true), gettype($shippingFirmName)), __LINE__);
        }
        $this->shippingFirmName = $shippingFirmName;
        return $this;
    }
    /**
     * Get shippingFirmId value
     * @return int|null
     */
    public function getShippingFirmId()
    {
        return $this->shippingFirmId;
    }
    /**
     * Set shippingFirmId value
     * @param int $shippingFirmId
     * @return \StructType\ShippingInfoType
     */
    public function setShippingFirmId($shippingFirmId = null)
    {
        // validation for constraint: int
        if (!is_null($shippingFirmId) && !(is_int($shippingFirmId) || ctype_digit($shippingFirmId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shippingFirmId, true), gettype($shippingFirmId)), __LINE__);
        }
        $this->shippingFirmId = $shippingFirmId;
        return $this;
    }
    /**
     * Get combinedShipping value
     * @return string|null
     */
    public function getCombinedShipping()
    {
        return $this->combinedShipping;
    }
    /**
     * Set combinedShipping value
     * @param string $combinedShipping
     * @return \StructType\ShippingInfoType
     */
    public function setCombinedShipping($combinedShipping = null)
    {
        // validation for constraint: string
        if (!is_null($combinedShipping) && !is_string($combinedShipping)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($combinedShipping, true), gettype($combinedShipping)), __LINE__);
        }
        $this->combinedShipping = $combinedShipping;
        return $this;
    }
    /**
     * Get cargoCode value
     * @return string|null
     */
    public function getCargoCode()
    {
        return $this->cargoCode;
    }
    /**
     * Set cargoCode value
     * @param string $cargoCode
     * @return \StructType\ShippingInfoType
     */
    public function setCargoCode($cargoCode = null)
    {
        // validation for constraint: string
        if (!is_null($cargoCode) && !is_string($cargoCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cargoCode, true), gettype($cargoCode)), __LINE__);
        }
        $this->cargoCode = $cargoCode;
        return $this;
    }
    /**
     * Get combinedSaleCodes value
     * @return \StructType\CombinedSaleCodes|null
     */
    public function getCombinedSaleCodes()
    {
        return $this->combinedSaleCodes;
    }
    /**
     * Set combinedSaleCodes value
     * @param \StructType\CombinedSaleCodes $combinedSaleCodes
     * @return \StructType\ShippingInfoType
     */
    public function setCombinedSaleCodes(\StructType\CombinedSaleCodes $combinedSaleCodes = null)
    {
        $this->combinedSaleCodes = $combinedSaleCodes;
        return $this;
    }
    /**
     * Get shippingExpireDate value
     * @return string|null
     */
    public function getShippingExpireDate()
    {
        return $this->shippingExpireDate;
    }
    /**
     * Set shippingExpireDate value
     * @param string $shippingExpireDate
     * @return \StructType\ShippingInfoType
     */
    public function setShippingExpireDate($shippingExpireDate = null)
    {
        // validation for constraint: string
        if (!is_null($shippingExpireDate) && !is_string($shippingExpireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingExpireDate, true), gettype($shippingExpireDate)), __LINE__);
        }
        $this->shippingExpireDate = $shippingExpireDate;
        return $this;
    }
}
