<?php

namespace Ups\upslabelStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackingCandidateType upslabelStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsTrackingCandidateType extends AbstractStructBase
{
    /**
     * The TrackingNumber
     * @var string
     */
    public $TrackingNumber;
    /**
     * The DestinationPostalCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DestinationPostalCode;
    /**
     * The DestinationCountryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DestinationCountryCode;
    /**
     * The PickupDateRange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upslabelStruct\UpsPickupDateRangeType
     */
    public $PickupDateRange;
    /**
     * Constructor method for TrackingCandidateType
     * @uses UpsTrackingCandidateType::setTrackingNumber()
     * @uses UpsTrackingCandidateType::setDestinationPostalCode()
     * @uses UpsTrackingCandidateType::setDestinationCountryCode()
     * @uses UpsTrackingCandidateType::setPickupDateRange()
     * @param string $trackingNumber
     * @param string $destinationPostalCode
     * @param string $destinationCountryCode
     * @param \Ups\upslabelStruct\UpsPickupDateRangeType $pickupDateRange
     */
    public function __construct($trackingNumber = null, $destinationPostalCode = null, $destinationCountryCode = null, \Ups\upslabelStruct\UpsPickupDateRangeType $pickupDateRange = null)
    {
        $this
            ->setTrackingNumber($trackingNumber)
            ->setDestinationPostalCode($destinationPostalCode)
            ->setDestinationCountryCode($destinationCountryCode)
            ->setPickupDateRange($pickupDateRange);
    }
    /**
     * Get TrackingNumber value
     * @return string|null
     */
    public function getTrackingNumber()
    {
        return $this->TrackingNumber;
    }
    /**
     * Set TrackingNumber value
     * @param string $trackingNumber
     * @return \Ups\upslabelStruct\UpsTrackingCandidateType
     */
    public function setTrackingNumber($trackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumber) && !is_string($trackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingNumber, true), gettype($trackingNumber)), __LINE__);
        }
        $this->TrackingNumber = $trackingNumber;
        return $this;
    }
    /**
     * Get DestinationPostalCode value
     * @return string|null
     */
    public function getDestinationPostalCode()
    {
        return $this->DestinationPostalCode;
    }
    /**
     * Set DestinationPostalCode value
     * @param string $destinationPostalCode
     * @return \Ups\upslabelStruct\UpsTrackingCandidateType
     */
    public function setDestinationPostalCode($destinationPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($destinationPostalCode) && !is_string($destinationPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationPostalCode, true), gettype($destinationPostalCode)), __LINE__);
        }
        $this->DestinationPostalCode = $destinationPostalCode;
        return $this;
    }
    /**
     * Get DestinationCountryCode value
     * @return string|null
     */
    public function getDestinationCountryCode()
    {
        return $this->DestinationCountryCode;
    }
    /**
     * Set DestinationCountryCode value
     * @param string $destinationCountryCode
     * @return \Ups\upslabelStruct\UpsTrackingCandidateType
     */
    public function setDestinationCountryCode($destinationCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($destinationCountryCode) && !is_string($destinationCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationCountryCode, true), gettype($destinationCountryCode)), __LINE__);
        }
        $this->DestinationCountryCode = $destinationCountryCode;
        return $this;
    }
    /**
     * Get PickupDateRange value
     * @return \Ups\upslabelStruct\UpsPickupDateRangeType|null
     */
    public function getPickupDateRange()
    {
        return $this->PickupDateRange;
    }
    /**
     * Set PickupDateRange value
     * @param \Ups\upslabelStruct\UpsPickupDateRangeType $pickupDateRange
     * @return \Ups\upslabelStruct\UpsTrackingCandidateType
     */
    public function setPickupDateRange(\Ups\upslabelStruct\UpsPickupDateRangeType $pickupDateRange = null)
    {
        $this->PickupDateRange = $pickupDateRange;
        return $this;
    }
}
