<?php

namespace Ups\upslabelStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReferenceValuesType upslabelStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsReferenceValuesType extends AbstractStructBase
{
    /**
     * The ReferenceNumber
     * @var \Ups\upslabelStruct\UpsReferenceNumberType
     */
    public $ReferenceNumber;
    /**
     * The ShipperNumber
     * @var string
     */
    public $ShipperNumber;
    /**
     * Constructor method for ReferenceValuesType
     * @uses UpsReferenceValuesType::setReferenceNumber()
     * @uses UpsReferenceValuesType::setShipperNumber()
     * @param \Ups\upslabelStruct\UpsReferenceNumberType $referenceNumber
     * @param string $shipperNumber
     */
    public function __construct(\Ups\upslabelStruct\UpsReferenceNumberType $referenceNumber = null, $shipperNumber = null)
    {
        $this
            ->setReferenceNumber($referenceNumber)
            ->setShipperNumber($shipperNumber);
    }
    /**
     * Get ReferenceNumber value
     * @return \Ups\upslabelStruct\UpsReferenceNumberType|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param \Ups\upslabelStruct\UpsReferenceNumberType $referenceNumber
     * @return \Ups\upslabelStruct\UpsReferenceValuesType
     */
    public function setReferenceNumber(\Ups\upslabelStruct\UpsReferenceNumberType $referenceNumber = null)
    {
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get ShipperNumber value
     * @return string|null
     */
    public function getShipperNumber()
    {
        return $this->ShipperNumber;
    }
    /**
     * Set ShipperNumber value
     * @param string $shipperNumber
     * @return \Ups\upslabelStruct\UpsReferenceValuesType
     */
    public function setShipperNumber($shipperNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipperNumber) && !is_string($shipperNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipperNumber, true), gettype($shipperNumber)), __LINE__);
        }
        $this->ShipperNumber = $shipperNumber;
        return $this;
    }
}
