<?php

namespace Ups\upslabelStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LabelRecoveryRequest upslabelStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsLabelRecoveryRequest extends AbstractStructBase
{
    /**
     * The Request
     * Meta information extracted from the WSDL
     * - ref: common:Request
     * @var \Ups\upslabelStruct\UpsRequestType
     */
    public $Request;
    /**
     * The LabelSpecification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upslabelStruct\UpsLabelSpecificationType
     */
    public $LabelSpecification;
    /**
     * The Translate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upslabelStruct\UpsTranslateType
     */
    public $Translate;
    /**
     * The LabelDelivery
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upslabelStruct\UpsLabelDeliveryType
     */
    public $LabelDelivery;
    /**
     * The TrackingNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TrackingNumber;
    /**
     * The MailInnovationsTrackingNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MailInnovationsTrackingNumber;
    /**
     * The ReferenceValues
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upslabelStruct\UpsReferenceValuesType
     */
    public $ReferenceValues;
    /**
     * The UPSPremiumCareForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upslabelStruct\UpsLRUPSPremiumCareFormType
     */
    public $UPSPremiumCareForm;
    /**
     * Constructor method for LabelRecoveryRequest
     * @uses UpsLabelRecoveryRequest::setRequest()
     * @uses UpsLabelRecoveryRequest::setLabelSpecification()
     * @uses UpsLabelRecoveryRequest::setTranslate()
     * @uses UpsLabelRecoveryRequest::setLabelDelivery()
     * @uses UpsLabelRecoveryRequest::setTrackingNumber()
     * @uses UpsLabelRecoveryRequest::setMailInnovationsTrackingNumber()
     * @uses UpsLabelRecoveryRequest::setReferenceValues()
     * @uses UpsLabelRecoveryRequest::setUPSPremiumCareForm()
     * @param \Ups\upslabelStruct\UpsRequestType $request
     * @param \Ups\upslabelStruct\UpsLabelSpecificationType $labelSpecification
     * @param \Ups\upslabelStruct\UpsTranslateType $translate
     * @param \Ups\upslabelStruct\UpsLabelDeliveryType $labelDelivery
     * @param string $trackingNumber
     * @param string $mailInnovationsTrackingNumber
     * @param \Ups\upslabelStruct\UpsReferenceValuesType $referenceValues
     * @param \Ups\upslabelStruct\UpsLRUPSPremiumCareFormType $uPSPremiumCareForm
     */
    public function __construct(\Ups\upslabelStruct\UpsRequestType $request = null, \Ups\upslabelStruct\UpsLabelSpecificationType $labelSpecification = null, \Ups\upslabelStruct\UpsTranslateType $translate = null, \Ups\upslabelStruct\UpsLabelDeliveryType $labelDelivery = null, $trackingNumber = null, $mailInnovationsTrackingNumber = null, \Ups\upslabelStruct\UpsReferenceValuesType $referenceValues = null, \Ups\upslabelStruct\UpsLRUPSPremiumCareFormType $uPSPremiumCareForm = null)
    {
        $this
            ->setRequest($request)
            ->setLabelSpecification($labelSpecification)
            ->setTranslate($translate)
            ->setLabelDelivery($labelDelivery)
            ->setTrackingNumber($trackingNumber)
            ->setMailInnovationsTrackingNumber($mailInnovationsTrackingNumber)
            ->setReferenceValues($referenceValues)
            ->setUPSPremiumCareForm($uPSPremiumCareForm);
    }
    /**
     * Get Request value
     * @return \Ups\upslabelStruct\UpsRequestType|null
     */
    public function getRequest()
    {
        return $this->Request;
    }
    /**
     * Set Request value
     * @param \Ups\upslabelStruct\UpsRequestType $request
     * @return \Ups\upslabelStruct\UpsLabelRecoveryRequest
     */
    public function setRequest(\Ups\upslabelStruct\UpsRequestType $request = null)
    {
        $this->Request = $request;
        return $this;
    }
    /**
     * Get LabelSpecification value
     * @return \Ups\upslabelStruct\UpsLabelSpecificationType|null
     */
    public function getLabelSpecification()
    {
        return $this->LabelSpecification;
    }
    /**
     * Set LabelSpecification value
     * @param \Ups\upslabelStruct\UpsLabelSpecificationType $labelSpecification
     * @return \Ups\upslabelStruct\UpsLabelRecoveryRequest
     */
    public function setLabelSpecification(\Ups\upslabelStruct\UpsLabelSpecificationType $labelSpecification = null)
    {
        $this->LabelSpecification = $labelSpecification;
        return $this;
    }
    /**
     * Get Translate value
     * @return \Ups\upslabelStruct\UpsTranslateType|null
     */
    public function getTranslate()
    {
        return $this->Translate;
    }
    /**
     * Set Translate value
     * @param \Ups\upslabelStruct\UpsTranslateType $translate
     * @return \Ups\upslabelStruct\UpsLabelRecoveryRequest
     */
    public function setTranslate(\Ups\upslabelStruct\UpsTranslateType $translate = null)
    {
        $this->Translate = $translate;
        return $this;
    }
    /**
     * Get LabelDelivery value
     * @return \Ups\upslabelStruct\UpsLabelDeliveryType|null
     */
    public function getLabelDelivery()
    {
        return $this->LabelDelivery;
    }
    /**
     * Set LabelDelivery value
     * @param \Ups\upslabelStruct\UpsLabelDeliveryType $labelDelivery
     * @return \Ups\upslabelStruct\UpsLabelRecoveryRequest
     */
    public function setLabelDelivery(\Ups\upslabelStruct\UpsLabelDeliveryType $labelDelivery = null)
    {
        $this->LabelDelivery = $labelDelivery;
        return $this;
    }
    /**
     * Get TrackingNumber value
     * @return string|null
     */
    public function getTrackingNumber()
    {
        return $this->TrackingNumber;
    }
    /**
     * Set TrackingNumber value
     * @param string $trackingNumber
     * @return \Ups\upslabelStruct\UpsLabelRecoveryRequest
     */
    public function setTrackingNumber($trackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumber) && !is_string($trackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingNumber, true), gettype($trackingNumber)), __LINE__);
        }
        $this->TrackingNumber = $trackingNumber;
        return $this;
    }
    /**
     * Get MailInnovationsTrackingNumber value
     * @return string|null
     */
    public function getMailInnovationsTrackingNumber()
    {
        return $this->MailInnovationsTrackingNumber;
    }
    /**
     * Set MailInnovationsTrackingNumber value
     * @param string $mailInnovationsTrackingNumber
     * @return \Ups\upslabelStruct\UpsLabelRecoveryRequest
     */
    public function setMailInnovationsTrackingNumber($mailInnovationsTrackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($mailInnovationsTrackingNumber) && !is_string($mailInnovationsTrackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailInnovationsTrackingNumber, true), gettype($mailInnovationsTrackingNumber)), __LINE__);
        }
        $this->MailInnovationsTrackingNumber = $mailInnovationsTrackingNumber;
        return $this;
    }
    /**
     * Get ReferenceValues value
     * @return \Ups\upslabelStruct\UpsReferenceValuesType|null
     */
    public function getReferenceValues()
    {
        return $this->ReferenceValues;
    }
    /**
     * Set ReferenceValues value
     * @param \Ups\upslabelStruct\UpsReferenceValuesType $referenceValues
     * @return \Ups\upslabelStruct\UpsLabelRecoveryRequest
     */
    public function setReferenceValues(\Ups\upslabelStruct\UpsReferenceValuesType $referenceValues = null)
    {
        $this->ReferenceValues = $referenceValues;
        return $this;
    }
    /**
     * Get UPSPremiumCareForm value
     * @return \Ups\upslabelStruct\UpsLRUPSPremiumCareFormType|null
     */
    public function getUPSPremiumCareForm()
    {
        return $this->UPSPremiumCareForm;
    }
    /**
     * Set UPSPremiumCareForm value
     * @param \Ups\upslabelStruct\UpsLRUPSPremiumCareFormType $uPSPremiumCareForm
     * @return \Ups\upslabelStruct\UpsLabelRecoveryRequest
     */
    public function setUPSPremiumCareForm(\Ups\upslabelStruct\UpsLRUPSPremiumCareFormType $uPSPremiumCareForm = null)
    {
        $this->UPSPremiumCareForm = $uPSPremiumCareForm;
        return $this;
    }
}
