<?php

namespace Ups\upslabelStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImageType upslabelStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsImageType extends AbstractStructBase
{
    /**
     * The ImageFormat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upslabelStruct\UpsLabelImageFormatType
     */
    public $ImageFormat;
    /**
     * The GraphicImage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $GraphicImage;
    /**
     * Constructor method for ImageType
     * @uses UpsImageType::setImageFormat()
     * @uses UpsImageType::setGraphicImage()
     * @param \Ups\upslabelStruct\UpsLabelImageFormatType $imageFormat
     * @param string $graphicImage
     */
    public function __construct(\Ups\upslabelStruct\UpsLabelImageFormatType $imageFormat = null, $graphicImage = null)
    {
        $this
            ->setImageFormat($imageFormat)
            ->setGraphicImage($graphicImage);
    }
    /**
     * Get ImageFormat value
     * @return \Ups\upslabelStruct\UpsLabelImageFormatType|null
     */
    public function getImageFormat()
    {
        return $this->ImageFormat;
    }
    /**
     * Set ImageFormat value
     * @param \Ups\upslabelStruct\UpsLabelImageFormatType $imageFormat
     * @return \Ups\upslabelStruct\UpsImageType
     */
    public function setImageFormat(\Ups\upslabelStruct\UpsLabelImageFormatType $imageFormat = null)
    {
        $this->ImageFormat = $imageFormat;
        return $this;
    }
    /**
     * Get GraphicImage value
     * @return string|null
     */
    public function getGraphicImage()
    {
        return $this->GraphicImage;
    }
    /**
     * Set GraphicImage value
     * @param string $graphicImage
     * @return \Ups\upslabelStruct\UpsImageType
     */
    public function setGraphicImage($graphicImage = null)
    {
        // validation for constraint: string
        if (!is_null($graphicImage) && !is_string($graphicImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($graphicImage, true), gettype($graphicImage)), __LINE__);
        }
        $this->GraphicImage = $graphicImage;
        return $this;
    }
}
