<?php

namespace Ups\upslabelStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UPSSecurity upslabelStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsUPSSecurity extends AbstractStructBase
{
    /**
     * The UsernameToken
     * @var \Ups\upslabelStruct\UpsUsernameToken
     */
    public $UsernameToken;
    /**
     * The ServiceAccessToken
     * @var \Ups\upslabelStruct\UpsServiceAccessToken
     */
    public $ServiceAccessToken;
    /**
     * Constructor method for UPSSecurity
     * @uses UpsUPSSecurity::setUsernameToken()
     * @uses UpsUPSSecurity::setServiceAccessToken()
     * @param \Ups\upslabelStruct\UpsUsernameToken $usernameToken
     * @param \Ups\upslabelStruct\UpsServiceAccessToken $serviceAccessToken
     */
    public function __construct(\Ups\upslabelStruct\UpsUsernameToken $usernameToken = null, \Ups\upslabelStruct\UpsServiceAccessToken $serviceAccessToken = null)
    {
        $this
            ->setUsernameToken($usernameToken)
            ->setServiceAccessToken($serviceAccessToken);
    }
    /**
     * Get UsernameToken value
     * @return \Ups\upslabelStruct\UpsUsernameToken|null
     */
    public function getUsernameToken()
    {
        return $this->UsernameToken;
    }
    /**
     * Set UsernameToken value
     * @param \Ups\upslabelStruct\UpsUsernameToken $usernameToken
     * @return \Ups\upslabelStruct\UpsUPSSecurity
     */
    public function setUsernameToken(\Ups\upslabelStruct\UpsUsernameToken $usernameToken = null)
    {
        $this->UsernameToken = $usernameToken;
        return $this;
    }
    /**
     * Get ServiceAccessToken value
     * @return \Ups\upslabelStruct\UpsServiceAccessToken|null
     */
    public function getServiceAccessToken()
    {
        return $this->ServiceAccessToken;
    }
    /**
     * Set ServiceAccessToken value
     * @param \Ups\upslabelStruct\UpsServiceAccessToken $serviceAccessToken
     * @return \Ups\upslabelStruct\UpsUPSSecurity
     */
    public function setServiceAccessToken(\Ups\upslabelStruct\UpsServiceAccessToken $serviceAccessToken = null)
    {
        $this->ServiceAccessToken = $serviceAccessToken;
        return $this;
    }
}
