<?php

namespace Ups\upslabelStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LabelResultsType upslabelStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsLabelResultsType extends AbstractStructBase
{
    /**
     * The TrackingNumber
     * @var string
     */
    public $TrackingNumber;
    /**
     * The LabelImage
     * @var \Ups\upslabelStruct\UpsLabelImageType
     */
    public $LabelImage;
    /**
     * The Receipt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upslabelStruct\UpsReceiptType
     */
    public $Receipt;
    /**
     * The Form
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upslabelStruct\UpsFormType
     */
    public $Form;
    /**
     * The MailInnovationsTrackingNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MailInnovationsTrackingNumber;
    /**
     * The MailInnovationsLabelImage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upslabelStruct\UpsLabelImageType
     */
    public $MailInnovationsLabelImage;
    /**
     * Constructor method for LabelResultsType
     * @uses UpsLabelResultsType::setTrackingNumber()
     * @uses UpsLabelResultsType::setLabelImage()
     * @uses UpsLabelResultsType::setReceipt()
     * @uses UpsLabelResultsType::setForm()
     * @uses UpsLabelResultsType::setMailInnovationsTrackingNumber()
     * @uses UpsLabelResultsType::setMailInnovationsLabelImage()
     * @param string $trackingNumber
     * @param \Ups\upslabelStruct\UpsLabelImageType $labelImage
     * @param \Ups\upslabelStruct\UpsReceiptType $receipt
     * @param \Ups\upslabelStruct\UpsFormType $form
     * @param string $mailInnovationsTrackingNumber
     * @param \Ups\upslabelStruct\UpsLabelImageType $mailInnovationsLabelImage
     */
    public function __construct($trackingNumber = null, \Ups\upslabelStruct\UpsLabelImageType $labelImage = null, \Ups\upslabelStruct\UpsReceiptType $receipt = null, \Ups\upslabelStruct\UpsFormType $form = null, $mailInnovationsTrackingNumber = null, \Ups\upslabelStruct\UpsLabelImageType $mailInnovationsLabelImage = null)
    {
        $this
            ->setTrackingNumber($trackingNumber)
            ->setLabelImage($labelImage)
            ->setReceipt($receipt)
            ->setForm($form)
            ->setMailInnovationsTrackingNumber($mailInnovationsTrackingNumber)
            ->setMailInnovationsLabelImage($mailInnovationsLabelImage);
    }
    /**
     * Get TrackingNumber value
     * @return string|null
     */
    public function getTrackingNumber()
    {
        return $this->TrackingNumber;
    }
    /**
     * Set TrackingNumber value
     * @param string $trackingNumber
     * @return \Ups\upslabelStruct\UpsLabelResultsType
     */
    public function setTrackingNumber($trackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumber) && !is_string($trackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingNumber, true), gettype($trackingNumber)), __LINE__);
        }
        $this->TrackingNumber = $trackingNumber;
        return $this;
    }
    /**
     * Get LabelImage value
     * @return \Ups\upslabelStruct\UpsLabelImageType|null
     */
    public function getLabelImage()
    {
        return $this->LabelImage;
    }
    /**
     * Set LabelImage value
     * @param \Ups\upslabelStruct\UpsLabelImageType $labelImage
     * @return \Ups\upslabelStruct\UpsLabelResultsType
     */
    public function setLabelImage(\Ups\upslabelStruct\UpsLabelImageType $labelImage = null)
    {
        $this->LabelImage = $labelImage;
        return $this;
    }
    /**
     * Get Receipt value
     * @return \Ups\upslabelStruct\UpsReceiptType|null
     */
    public function getReceipt()
    {
        return $this->Receipt;
    }
    /**
     * Set Receipt value
     * @param \Ups\upslabelStruct\UpsReceiptType $receipt
     * @return \Ups\upslabelStruct\UpsLabelResultsType
     */
    public function setReceipt(\Ups\upslabelStruct\UpsReceiptType $receipt = null)
    {
        $this->Receipt = $receipt;
        return $this;
    }
    /**
     * Get Form value
     * @return \Ups\upslabelStruct\UpsFormType|null
     */
    public function getForm()
    {
        return $this->Form;
    }
    /**
     * Set Form value
     * @param \Ups\upslabelStruct\UpsFormType $form
     * @return \Ups\upslabelStruct\UpsLabelResultsType
     */
    public function setForm(\Ups\upslabelStruct\UpsFormType $form = null)
    {
        $this->Form = $form;
        return $this;
    }
    /**
     * Get MailInnovationsTrackingNumber value
     * @return string|null
     */
    public function getMailInnovationsTrackingNumber()
    {
        return $this->MailInnovationsTrackingNumber;
    }
    /**
     * Set MailInnovationsTrackingNumber value
     * @param string $mailInnovationsTrackingNumber
     * @return \Ups\upslabelStruct\UpsLabelResultsType
     */
    public function setMailInnovationsTrackingNumber($mailInnovationsTrackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($mailInnovationsTrackingNumber) && !is_string($mailInnovationsTrackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailInnovationsTrackingNumber, true), gettype($mailInnovationsTrackingNumber)), __LINE__);
        }
        $this->MailInnovationsTrackingNumber = $mailInnovationsTrackingNumber;
        return $this;
    }
    /**
     * Get MailInnovationsLabelImage value
     * @return \Ups\upslabelStruct\UpsLabelImageType|null
     */
    public function getMailInnovationsLabelImage()
    {
        return $this->MailInnovationsLabelImage;
    }
    /**
     * Set MailInnovationsLabelImage value
     * @param \Ups\upslabelStruct\UpsLabelImageType $mailInnovationsLabelImage
     * @return \Ups\upslabelStruct\UpsLabelResultsType
     */
    public function setMailInnovationsLabelImage(\Ups\upslabelStruct\UpsLabelImageType $mailInnovationsLabelImage = null)
    {
        $this->MailInnovationsLabelImage = $mailInnovationsLabelImage;
        return $this;
    }
}
