<?php

namespace Ups\upslabelStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TranslateType upslabelStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsTranslateType extends AbstractStructBase
{
    /**
     * The LanguageCode
     * @var string
     */
    public $LanguageCode;
    /**
     * The DialectCode
     * @var string
     */
    public $DialectCode;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * Constructor method for TranslateType
     * @uses UpsTranslateType::setLanguageCode()
     * @uses UpsTranslateType::setDialectCode()
     * @uses UpsTranslateType::setCode()
     * @param string $languageCode
     * @param string $dialectCode
     * @param string $code
     */
    public function __construct($languageCode = null, $dialectCode = null, $code = null)
    {
        $this
            ->setLanguageCode($languageCode)
            ->setDialectCode($dialectCode)
            ->setCode($code);
    }
    /**
     * Get LanguageCode value
     * @return string|null
     */
    public function getLanguageCode()
    {
        return $this->LanguageCode;
    }
    /**
     * Set LanguageCode value
     * @param string $languageCode
     * @return \Ups\upslabelStruct\UpsTranslateType
     */
    public function setLanguageCode($languageCode = null)
    {
        // validation for constraint: string
        if (!is_null($languageCode) && !is_string($languageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($languageCode, true), gettype($languageCode)), __LINE__);
        }
        $this->LanguageCode = $languageCode;
        return $this;
    }
    /**
     * Get DialectCode value
     * @return string|null
     */
    public function getDialectCode()
    {
        return $this->DialectCode;
    }
    /**
     * Set DialectCode value
     * @param string $dialectCode
     * @return \Ups\upslabelStruct\UpsTranslateType
     */
    public function setDialectCode($dialectCode = null)
    {
        // validation for constraint: string
        if (!is_null($dialectCode) && !is_string($dialectCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dialectCode, true), gettype($dialectCode)), __LINE__);
        }
        $this->DialectCode = $dialectCode;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Ups\upslabelStruct\UpsTranslateType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
}
