<?php

namespace Ups\upslabelStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponseImageDetailType upslabelStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsResponseImageDetailType extends AbstractStructBase
{
    /**
     * The ImageFormat
     * @var \Ups\upslabelStruct\UpsImageFormatCodeType
     */
    public $ImageFormat;
    /**
     * The GraphicImage
     * @var string
     */
    public $GraphicImage;
    /**
     * Constructor method for ResponseImageDetailType
     * @uses UpsResponseImageDetailType::setImageFormat()
     * @uses UpsResponseImageDetailType::setGraphicImage()
     * @param \Ups\upslabelStruct\UpsImageFormatCodeType $imageFormat
     * @param string $graphicImage
     */
    public function __construct(\Ups\upslabelStruct\UpsImageFormatCodeType $imageFormat = null, $graphicImage = null)
    {
        $this
            ->setImageFormat($imageFormat)
            ->setGraphicImage($graphicImage);
    }
    /**
     * Get ImageFormat value
     * @return \Ups\upslabelStruct\UpsImageFormatCodeType|null
     */
    public function getImageFormat()
    {
        return $this->ImageFormat;
    }
    /**
     * Set ImageFormat value
     * @param \Ups\upslabelStruct\UpsImageFormatCodeType $imageFormat
     * @return \Ups\upslabelStruct\UpsResponseImageDetailType
     */
    public function setImageFormat(\Ups\upslabelStruct\UpsImageFormatCodeType $imageFormat = null)
    {
        $this->ImageFormat = $imageFormat;
        return $this;
    }
    /**
     * Get GraphicImage value
     * @return string|null
     */
    public function getGraphicImage()
    {
        return $this->GraphicImage;
    }
    /**
     * Set GraphicImage value
     * @param string $graphicImage
     * @return \Ups\upslabelStruct\UpsResponseImageDetailType
     */
    public function setGraphicImage($graphicImage = null)
    {
        // validation for constraint: string
        if (!is_null($graphicImage) && !is_string($graphicImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($graphicImage, true), gettype($graphicImage)), __LINE__);
        }
        $this->GraphicImage = $graphicImage;
        return $this;
    }
}
