<?php

namespace Ups\upslabelStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LabelSpecificationType upslabelStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsLabelSpecificationType extends AbstractStructBase
{
    /**
     * The HTTPUserAgent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $HTTPUserAgent;
    /**
     * The LabelImageFormat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upslabelStruct\UpsLabelImageFormatType
     */
    public $LabelImageFormat;
    /**
     * The LabelStockSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upslabelStruct\UpsLabelStockSizeType
     */
    public $LabelStockSize;
    /**
     * Constructor method for LabelSpecificationType
     * @uses UpsLabelSpecificationType::setHTTPUserAgent()
     * @uses UpsLabelSpecificationType::setLabelImageFormat()
     * @uses UpsLabelSpecificationType::setLabelStockSize()
     * @param string $hTTPUserAgent
     * @param \Ups\upslabelStruct\UpsLabelImageFormatType $labelImageFormat
     * @param \Ups\upslabelStruct\UpsLabelStockSizeType $labelStockSize
     */
    public function __construct($hTTPUserAgent = null, \Ups\upslabelStruct\UpsLabelImageFormatType $labelImageFormat = null, \Ups\upslabelStruct\UpsLabelStockSizeType $labelStockSize = null)
    {
        $this
            ->setHTTPUserAgent($hTTPUserAgent)
            ->setLabelImageFormat($labelImageFormat)
            ->setLabelStockSize($labelStockSize);
    }
    /**
     * Get HTTPUserAgent value
     * @return string|null
     */
    public function getHTTPUserAgent()
    {
        return $this->HTTPUserAgent;
    }
    /**
     * Set HTTPUserAgent value
     * @param string $hTTPUserAgent
     * @return \Ups\upslabelStruct\UpsLabelSpecificationType
     */
    public function setHTTPUserAgent($hTTPUserAgent = null)
    {
        // validation for constraint: string
        if (!is_null($hTTPUserAgent) && !is_string($hTTPUserAgent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hTTPUserAgent, true), gettype($hTTPUserAgent)), __LINE__);
        }
        $this->HTTPUserAgent = $hTTPUserAgent;
        return $this;
    }
    /**
     * Get LabelImageFormat value
     * @return \Ups\upslabelStruct\UpsLabelImageFormatType|null
     */
    public function getLabelImageFormat()
    {
        return $this->LabelImageFormat;
    }
    /**
     * Set LabelImageFormat value
     * @param \Ups\upslabelStruct\UpsLabelImageFormatType $labelImageFormat
     * @return \Ups\upslabelStruct\UpsLabelSpecificationType
     */
    public function setLabelImageFormat(\Ups\upslabelStruct\UpsLabelImageFormatType $labelImageFormat = null)
    {
        $this->LabelImageFormat = $labelImageFormat;
        return $this;
    }
    /**
     * Get LabelStockSize value
     * @return \Ups\upslabelStruct\UpsLabelStockSizeType|null
     */
    public function getLabelStockSize()
    {
        return $this->LabelStockSize;
    }
    /**
     * Set LabelStockSize value
     * @param \Ups\upslabelStruct\UpsLabelStockSizeType $labelStockSize
     * @return \Ups\upslabelStruct\UpsLabelSpecificationType
     */
    public function setLabelStockSize(\Ups\upslabelStruct\UpsLabelStockSizeType $labelStockSize = null)
    {
        $this->LabelStockSize = $labelStockSize;
        return $this;
    }
}
