<?php

namespace Ups\upslabelStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LabelRecoveryResponse upslabelStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsLabelRecoveryResponse extends AbstractStructBase
{
    /**
     * The Response
     * Meta information extracted from the WSDL
     * - ref: common:Response
     * @var \Ups\upslabelStruct\UpsResponseType
     */
    public $Response;
    /**
     * The ShipmentIdentificationNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ShipmentIdentificationNumber;
    /**
     * The CODTurnInPage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upslabelStruct\UpsResponseImageType
     */
    public $CODTurnInPage;
    /**
     * The Form
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upslabelStruct\UpsFormType
     */
    public $Form;
    /**
     * The HighValueReport
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upslabelStruct\UpsHighValueReportType
     */
    public $HighValueReport;
    /**
     * The LabelResults
     * Meta information extracted from the WSDL
     * - choice: LabelResults | TrackingCandidate
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * @var \Ups\upslabelStruct\UpsLabelResultsType
     */
    public $LabelResults;
    /**
     * The TrackingCandidate
     * Meta information extracted from the WSDL
     * - choice: LabelResults | TrackingCandidate
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * @var \Ups\upslabelStruct\UpsTrackingCandidateType
     */
    public $TrackingCandidate;
    /**
     * Constructor method for LabelRecoveryResponse
     * @uses UpsLabelRecoveryResponse::setResponse()
     * @uses UpsLabelRecoveryResponse::setShipmentIdentificationNumber()
     * @uses UpsLabelRecoveryResponse::setCODTurnInPage()
     * @uses UpsLabelRecoveryResponse::setForm()
     * @uses UpsLabelRecoveryResponse::setHighValueReport()
     * @uses UpsLabelRecoveryResponse::setLabelResults()
     * @uses UpsLabelRecoveryResponse::setTrackingCandidate()
     * @param \Ups\upslabelStruct\UpsResponseType $response
     * @param string $shipmentIdentificationNumber
     * @param \Ups\upslabelStruct\UpsResponseImageType $cODTurnInPage
     * @param \Ups\upslabelStruct\UpsFormType $form
     * @param \Ups\upslabelStruct\UpsHighValueReportType $highValueReport
     * @param \Ups\upslabelStruct\UpsLabelResultsType $labelResults
     * @param \Ups\upslabelStruct\UpsTrackingCandidateType $trackingCandidate
     */
    public function __construct(\Ups\upslabelStruct\UpsResponseType $response = null, $shipmentIdentificationNumber = null, \Ups\upslabelStruct\UpsResponseImageType $cODTurnInPage = null, \Ups\upslabelStruct\UpsFormType $form = null, \Ups\upslabelStruct\UpsHighValueReportType $highValueReport = null, \Ups\upslabelStruct\UpsLabelResultsType $labelResults = null, \Ups\upslabelStruct\UpsTrackingCandidateType $trackingCandidate = null)
    {
        $this
            ->setResponse($response)
            ->setShipmentIdentificationNumber($shipmentIdentificationNumber)
            ->setCODTurnInPage($cODTurnInPage)
            ->setForm($form)
            ->setHighValueReport($highValueReport)
            ->setLabelResults($labelResults)
            ->setTrackingCandidate($trackingCandidate);
    }
    /**
     * Get Response value
     * @return \Ups\upslabelStruct\UpsResponseType|null
     */
    public function getResponse()
    {
        return $this->Response;
    }
    /**
     * Set Response value
     * @param \Ups\upslabelStruct\UpsResponseType $response
     * @return \Ups\upslabelStruct\UpsLabelRecoveryResponse
     */
    public function setResponse(\Ups\upslabelStruct\UpsResponseType $response = null)
    {
        $this->Response = $response;
        return $this;
    }
    /**
     * Get ShipmentIdentificationNumber value
     * @return string|null
     */
    public function getShipmentIdentificationNumber()
    {
        return $this->ShipmentIdentificationNumber;
    }
    /**
     * Set ShipmentIdentificationNumber value
     * @param string $shipmentIdentificationNumber
     * @return \Ups\upslabelStruct\UpsLabelRecoveryResponse
     */
    public function setShipmentIdentificationNumber($shipmentIdentificationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentIdentificationNumber) && !is_string($shipmentIdentificationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentIdentificationNumber, true), gettype($shipmentIdentificationNumber)), __LINE__);
        }
        $this->ShipmentIdentificationNumber = $shipmentIdentificationNumber;
        return $this;
    }
    /**
     * Get CODTurnInPage value
     * @return \Ups\upslabelStruct\UpsResponseImageType|null
     */
    public function getCODTurnInPage()
    {
        return $this->CODTurnInPage;
    }
    /**
     * Set CODTurnInPage value
     * @param \Ups\upslabelStruct\UpsResponseImageType $cODTurnInPage
     * @return \Ups\upslabelStruct\UpsLabelRecoveryResponse
     */
    public function setCODTurnInPage(\Ups\upslabelStruct\UpsResponseImageType $cODTurnInPage = null)
    {
        $this->CODTurnInPage = $cODTurnInPage;
        return $this;
    }
    /**
     * Get Form value
     * @return \Ups\upslabelStruct\UpsFormType|null
     */
    public function getForm()
    {
        return $this->Form;
    }
    /**
     * Set Form value
     * @param \Ups\upslabelStruct\UpsFormType $form
     * @return \Ups\upslabelStruct\UpsLabelRecoveryResponse
     */
    public function setForm(\Ups\upslabelStruct\UpsFormType $form = null)
    {
        $this->Form = $form;
        return $this;
    }
    /**
     * Get HighValueReport value
     * @return \Ups\upslabelStruct\UpsHighValueReportType|null
     */
    public function getHighValueReport()
    {
        return $this->HighValueReport;
    }
    /**
     * Set HighValueReport value
     * @param \Ups\upslabelStruct\UpsHighValueReportType $highValueReport
     * @return \Ups\upslabelStruct\UpsLabelRecoveryResponse
     */
    public function setHighValueReport(\Ups\upslabelStruct\UpsHighValueReportType $highValueReport = null)
    {
        $this->HighValueReport = $highValueReport;
        return $this;
    }
    /**
     * Get LabelResults value
     * @return \Ups\upslabelStruct\UpsLabelResultsType|null
     */
    public function getLabelResults()
    {
        return isset($this->LabelResults) ? $this->LabelResults : null;
    }
    /**
     * This method is responsible for validating the value passed to the setLabelResults method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLabelResults method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateLabelResultsForChoiceConstraintsFromSetLabelResults($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'TrackingCandidate',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property LabelResults can\'t be set as the property %s is already set. Only one property must be set among these properties: LabelResults, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set LabelResults value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Ups\upslabelStruct\UpsLabelResultsType $labelResults
     * @return \Ups\upslabelStruct\UpsLabelRecoveryResponse
     */
    public function setLabelResults(\Ups\upslabelStruct\UpsLabelResultsType $labelResults = null)
    {
        // validation for constraint: choice(LabelResults, TrackingCandidate)
        if ('' !== ($labelResultsChoiceErrorMessage = self::validateLabelResultsForChoiceConstraintsFromSetLabelResults($labelResults))) {
            throw new \InvalidArgumentException($labelResultsChoiceErrorMessage, __LINE__);
        }
        if (is_null($labelResults) || (is_array($labelResults) && empty($labelResults))) {
            unset($this->LabelResults);
        } else {
            $this->LabelResults = $labelResults;
        }
        return $this;
    }
    /**
     * Get TrackingCandidate value
     * @return \Ups\upslabelStruct\UpsTrackingCandidateType|null
     */
    public function getTrackingCandidate()
    {
        return isset($this->TrackingCandidate) ? $this->TrackingCandidate : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTrackingCandidate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTrackingCandidate method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTrackingCandidateForChoiceConstraintsFromSetTrackingCandidate($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'LabelResults',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property TrackingCandidate can\'t be set as the property %s is already set. Only one property must be set among these properties: TrackingCandidate, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set TrackingCandidate value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Ups\upslabelStruct\UpsTrackingCandidateType $trackingCandidate
     * @return \Ups\upslabelStruct\UpsLabelRecoveryResponse
     */
    public function setTrackingCandidate(\Ups\upslabelStruct\UpsTrackingCandidateType $trackingCandidate = null)
    {
        // validation for constraint: choice(LabelResults, TrackingCandidate)
        if ('' !== ($trackingCandidateChoiceErrorMessage = self::validateTrackingCandidateForChoiceConstraintsFromSetTrackingCandidate($trackingCandidate))) {
            throw new \InvalidArgumentException($trackingCandidateChoiceErrorMessage, __LINE__);
        }
        if (is_null($trackingCandidate) || (is_array($trackingCandidate) && empty($trackingCandidate))) {
            unset($this->TrackingCandidate);
        } else {
            $this->TrackingCandidate = $trackingCandidate;
        }
        return $this;
    }
}
