<?php

namespace Ups\upslabelStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ErrorDetailType upslabelStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsErrorDetailType extends AbstractStructBase
{
    /**
     * The Severity
     * @var string
     */
    public $Severity;
    /**
     * The PrimaryErrorCode
     * @var \Ups\upslabelStruct\UpsCodeType
     */
    public $PrimaryErrorCode;
    /**
     * The MinimumRetrySeconds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MinimumRetrySeconds;
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upslabelStruct\UpsLocationType
     */
    public $Location;
    /**
     * The SubErrorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups\upslabelStruct\UpsCodeType[]
     */
    public $SubErrorCode;
    /**
     * The AdditionalInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups\upslabelStruct\UpsAdditionalInfoType[]
     */
    public $AdditionalInformation;
    /**
     * The ElementLevelInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upslabelStruct\UpsElementLevelInformationType
     */
    public $ElementLevelInformation;
    /**
     * Constructor method for ErrorDetailType
     * @uses UpsErrorDetailType::setSeverity()
     * @uses UpsErrorDetailType::setPrimaryErrorCode()
     * @uses UpsErrorDetailType::setMinimumRetrySeconds()
     * @uses UpsErrorDetailType::setLocation()
     * @uses UpsErrorDetailType::setSubErrorCode()
     * @uses UpsErrorDetailType::setAdditionalInformation()
     * @uses UpsErrorDetailType::setElementLevelInformation()
     * @param string $severity
     * @param \Ups\upslabelStruct\UpsCodeType $primaryErrorCode
     * @param string $minimumRetrySeconds
     * @param \Ups\upslabelStruct\UpsLocationType $location
     * @param \Ups\upslabelStruct\UpsCodeType[] $subErrorCode
     * @param \Ups\upslabelStruct\UpsAdditionalInfoType[] $additionalInformation
     * @param \Ups\upslabelStruct\UpsElementLevelInformationType $elementLevelInformation
     */
    public function __construct($severity = null, \Ups\upslabelStruct\UpsCodeType $primaryErrorCode = null, $minimumRetrySeconds = null, \Ups\upslabelStruct\UpsLocationType $location = null, array $subErrorCode = array(), array $additionalInformation = array(), \Ups\upslabelStruct\UpsElementLevelInformationType $elementLevelInformation = null)
    {
        $this
            ->setSeverity($severity)
            ->setPrimaryErrorCode($primaryErrorCode)
            ->setMinimumRetrySeconds($minimumRetrySeconds)
            ->setLocation($location)
            ->setSubErrorCode($subErrorCode)
            ->setAdditionalInformation($additionalInformation)
            ->setElementLevelInformation($elementLevelInformation);
    }
    /**
     * Get Severity value
     * @return string|null
     */
    public function getSeverity()
    {
        return $this->Severity;
    }
    /**
     * Set Severity value
     * @param string $severity
     * @return \Ups\upslabelStruct\UpsErrorDetailType
     */
    public function setSeverity($severity = null)
    {
        // validation for constraint: string
        if (!is_null($severity) && !is_string($severity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($severity, true), gettype($severity)), __LINE__);
        }
        $this->Severity = $severity;
        return $this;
    }
    /**
     * Get PrimaryErrorCode value
     * @return \Ups\upslabelStruct\UpsCodeType|null
     */
    public function getPrimaryErrorCode()
    {
        return $this->PrimaryErrorCode;
    }
    /**
     * Set PrimaryErrorCode value
     * @param \Ups\upslabelStruct\UpsCodeType $primaryErrorCode
     * @return \Ups\upslabelStruct\UpsErrorDetailType
     */
    public function setPrimaryErrorCode(\Ups\upslabelStruct\UpsCodeType $primaryErrorCode = null)
    {
        $this->PrimaryErrorCode = $primaryErrorCode;
        return $this;
    }
    /**
     * Get MinimumRetrySeconds value
     * @return string|null
     */
    public function getMinimumRetrySeconds()
    {
        return $this->MinimumRetrySeconds;
    }
    /**
     * Set MinimumRetrySeconds value
     * @param string $minimumRetrySeconds
     * @return \Ups\upslabelStruct\UpsErrorDetailType
     */
    public function setMinimumRetrySeconds($minimumRetrySeconds = null)
    {
        // validation for constraint: string
        if (!is_null($minimumRetrySeconds) && !is_string($minimumRetrySeconds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minimumRetrySeconds, true), gettype($minimumRetrySeconds)), __LINE__);
        }
        $this->MinimumRetrySeconds = $minimumRetrySeconds;
        return $this;
    }
    /**
     * Get Location value
     * @return \Ups\upslabelStruct\UpsLocationType|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param \Ups\upslabelStruct\UpsLocationType $location
     * @return \Ups\upslabelStruct\UpsErrorDetailType
     */
    public function setLocation(\Ups\upslabelStruct\UpsLocationType $location = null)
    {
        $this->Location = $location;
        return $this;
    }
    /**
     * Get SubErrorCode value
     * @return \Ups\upslabelStruct\UpsCodeType[]|null
     */
    public function getSubErrorCode()
    {
        return $this->SubErrorCode;
    }
    /**
     * This method is responsible for validating the values passed to the setSubErrorCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubErrorCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubErrorCodeForArrayConstraintsFromSetSubErrorCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $errorDetailTypeSubErrorCodeItem) {
            // validation for constraint: itemType
            if (!$errorDetailTypeSubErrorCodeItem instanceof \Ups\upslabelStruct\UpsCodeType) {
                $invalidValues[] = is_object($errorDetailTypeSubErrorCodeItem) ? get_class($errorDetailTypeSubErrorCodeItem) : sprintf('%s(%s)', gettype($errorDetailTypeSubErrorCodeItem), var_export($errorDetailTypeSubErrorCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SubErrorCode property can only contain items of type \Ups\upslabelStruct\UpsCodeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SubErrorCode value
     * @throws \InvalidArgumentException
     * @param \Ups\upslabelStruct\UpsCodeType[] $subErrorCode
     * @return \Ups\upslabelStruct\UpsErrorDetailType
     */
    public function setSubErrorCode(array $subErrorCode = array())
    {
        // validation for constraint: array
        if ('' !== ($subErrorCodeArrayErrorMessage = self::validateSubErrorCodeForArrayConstraintsFromSetSubErrorCode($subErrorCode))) {
            throw new \InvalidArgumentException($subErrorCodeArrayErrorMessage, __LINE__);
        }
        $this->SubErrorCode = $subErrorCode;
        return $this;
    }
    /**
     * Add item to SubErrorCode value
     * @throws \InvalidArgumentException
     * @param \Ups\upslabelStruct\UpsCodeType $item
     * @return \Ups\upslabelStruct\UpsErrorDetailType
     */
    public function addToSubErrorCode(\Ups\upslabelStruct\UpsCodeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups\upslabelStruct\UpsCodeType) {
            throw new \InvalidArgumentException(sprintf('The SubErrorCode property can only contain items of type \Ups\upslabelStruct\UpsCodeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SubErrorCode[] = $item;
        return $this;
    }
    /**
     * Get AdditionalInformation value
     * @return \Ups\upslabelStruct\UpsAdditionalInfoType[]|null
     */
    public function getAdditionalInformation()
    {
        return $this->AdditionalInformation;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalInformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalInformation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalInformationForArrayConstraintsFromSetAdditionalInformation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $errorDetailTypeAdditionalInformationItem) {
            // validation for constraint: itemType
            if (!$errorDetailTypeAdditionalInformationItem instanceof \Ups\upslabelStruct\UpsAdditionalInfoType) {
                $invalidValues[] = is_object($errorDetailTypeAdditionalInformationItem) ? get_class($errorDetailTypeAdditionalInformationItem) : sprintf('%s(%s)', gettype($errorDetailTypeAdditionalInformationItem), var_export($errorDetailTypeAdditionalInformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdditionalInformation property can only contain items of type \Ups\upslabelStruct\UpsAdditionalInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdditionalInformation value
     * @throws \InvalidArgumentException
     * @param \Ups\upslabelStruct\UpsAdditionalInfoType[] $additionalInformation
     * @return \Ups\upslabelStruct\UpsErrorDetailType
     */
    public function setAdditionalInformation(array $additionalInformation = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalInformationArrayErrorMessage = self::validateAdditionalInformationForArrayConstraintsFromSetAdditionalInformation($additionalInformation))) {
            throw new \InvalidArgumentException($additionalInformationArrayErrorMessage, __LINE__);
        }
        $this->AdditionalInformation = $additionalInformation;
        return $this;
    }
    /**
     * Add item to AdditionalInformation value
     * @throws \InvalidArgumentException
     * @param \Ups\upslabelStruct\UpsAdditionalInfoType $item
     * @return \Ups\upslabelStruct\UpsErrorDetailType
     */
    public function addToAdditionalInformation(\Ups\upslabelStruct\UpsAdditionalInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups\upslabelStruct\UpsAdditionalInfoType) {
            throw new \InvalidArgumentException(sprintf('The AdditionalInformation property can only contain items of type \Ups\upslabelStruct\UpsAdditionalInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AdditionalInformation[] = $item;
        return $this;
    }
    /**
     * Get ElementLevelInformation value
     * @return \Ups\upslabelStruct\UpsElementLevelInformationType|null
     */
    public function getElementLevelInformation()
    {
        return $this->ElementLevelInformation;
    }
    /**
     * Set ElementLevelInformation value
     * @param \Ups\upslabelStruct\UpsElementLevelInformationType $elementLevelInformation
     * @return \Ups\upslabelStruct\UpsErrorDetailType
     */
    public function setElementLevelInformation(\Ups\upslabelStruct\UpsElementLevelInformationType $elementLevelInformation = null)
    {
        $this->ElementLevelInformation = $elementLevelInformation;
        return $this;
    }
}
