<?php

namespace Ups;

/**
 * Class which returns the class map definition
 * @package Ups
 */
class UpsClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'UPSSecurity' => '\\Ups\\upslabelStruct\\UpsUPSSecurity',
            'UsernameToken' => '\\Ups\\upslabelStruct\\UpsUsernameToken',
            'ServiceAccessToken' => '\\Ups\\upslabelStruct\\UpsServiceAccessToken',
            'Errors' => '\\Ups\\upslabelStruct\\UpsErrors',
            'ErrorDetailType' => '\\Ups\\upslabelStruct\\UpsErrorDetailType',
            'ElementLevelInformationType' => '\\Ups\\upslabelStruct\\UpsElementLevelInformationType',
            'ElementIdentifierType' => '\\Ups\\upslabelStruct\\UpsElementIdentifierType',
            'CodeType' => '\\Ups\\upslabelStruct\\UpsCodeType',
            'AdditionalInfoType' => '\\Ups\\upslabelStruct\\UpsAdditionalInfoType',
            'AdditionalCodeDescType' => '\\Ups\\upslabelStruct\\UpsAdditionalCodeDescType',
            'LocationType' => '\\Ups\\upslabelStruct\\UpsLocationType',
            'ClientInformationType' => '\\Ups\\upslabelStruct\\UpsClientInformationType',
            'Property' => '\\Ups\\upslabelStruct\\UpsProperty',
            'RequestType' => '\\Ups\\upslabelStruct\\UpsRequestType',
            'TransactionReferenceType' => '\\Ups\\upslabelStruct\\UpsTransactionReferenceType',
            'ResponseType' => '\\Ups\\upslabelStruct\\UpsResponseType',
            'CodeDescriptionType' => '\\Ups\\upslabelStruct\\UpsCodeDescriptionType',
            'DetailType' => '\\Ups\\upslabelStruct\\UpsDetailType',
            'LabelRecoveryRequest' => '\\Ups\\upslabelStruct\\UpsLabelRecoveryRequest',
            'ReferenceValuesType' => '\\Ups\\upslabelStruct\\UpsReferenceValuesType',
            'ReferenceNumberType' => '\\Ups\\upslabelStruct\\UpsReferenceNumberType',
            'LabelSpecificationType' => '\\Ups\\upslabelStruct\\UpsLabelSpecificationType',
            'LabelStockSizeType' => '\\Ups\\upslabelStruct\\UpsLabelStockSizeType',
            'LabelImageFormatType' => '\\Ups\\upslabelStruct\\UpsLabelImageFormatType',
            'TranslateType' => '\\Ups\\upslabelStruct\\UpsTranslateType',
            'LabelDeliveryType' => '\\Ups\\upslabelStruct\\UpsLabelDeliveryType',
            'LabelRecoveryResponse' => '\\Ups\\upslabelStruct\\UpsLabelRecoveryResponse',
            'LabelResultsType' => '\\Ups\\upslabelStruct\\UpsLabelResultsType',
            'LabelImageType' => '\\Ups\\upslabelStruct\\UpsLabelImageType',
            'ReceiptType' => '\\Ups\\upslabelStruct\\UpsReceiptType',
            'ImageType' => '\\Ups\\upslabelStruct\\UpsImageType',
            'TrackingCandidateType' => '\\Ups\\upslabelStruct\\UpsTrackingCandidateType',
            'PickupDateRangeType' => '\\Ups\\upslabelStruct\\UpsPickupDateRangeType',
            'ResponseImageType' => '\\Ups\\upslabelStruct\\UpsResponseImageType',
            'ResponseImageDetailType' => '\\Ups\\upslabelStruct\\UpsResponseImageDetailType',
            'ImageFormatCodeType' => '\\Ups\\upslabelStruct\\UpsImageFormatCodeType',
            'FormType' => '\\Ups\\upslabelStruct\\UpsFormType',
            'FormImageType' => '\\Ups\\upslabelStruct\\UpsFormImageType',
            'HighValueReportType' => '\\Ups\\upslabelStruct\\UpsHighValueReportType',
            'HVRImageType' => '\\Ups\\upslabelStruct\\UpsHVRImageType',
            'LRUPSPremiumCareFormType' => '\\Ups\\upslabelStruct\\UpsLRUPSPremiumCareFormType',
        );
    }
}
