<?php

namespace Ups\upslabelStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestType upslabelStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsRequestType extends AbstractStructBase
{
    /**
     * The RequestOption
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $RequestOption;
    /**
     * The SubVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SubVersion;
    /**
     * The TransactionReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upslabelStruct\UpsTransactionReferenceType
     */
    public $TransactionReference;
    /**
     * Constructor method for RequestType
     * @uses UpsRequestType::setRequestOption()
     * @uses UpsRequestType::setSubVersion()
     * @uses UpsRequestType::setTransactionReference()
     * @param string[] $requestOption
     * @param string $subVersion
     * @param \Ups\upslabelStruct\UpsTransactionReferenceType $transactionReference
     */
    public function __construct(array $requestOption = array(), $subVersion = null, \Ups\upslabelStruct\UpsTransactionReferenceType $transactionReference = null)
    {
        $this
            ->setRequestOption($requestOption)
            ->setSubVersion($subVersion)
            ->setTransactionReference($transactionReference);
    }
    /**
     * Get RequestOption value
     * @return string[]|null
     */
    public function getRequestOption()
    {
        return $this->RequestOption;
    }
    /**
     * This method is responsible for validating the values passed to the setRequestOption method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequestOption method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequestOptionForArrayConstraintsFromSetRequestOption(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requestTypeRequestOptionItem) {
            // validation for constraint: itemType
            if (!is_string($requestTypeRequestOptionItem)) {
                $invalidValues[] = is_object($requestTypeRequestOptionItem) ? get_class($requestTypeRequestOptionItem) : sprintf('%s(%s)', gettype($requestTypeRequestOptionItem), var_export($requestTypeRequestOptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RequestOption property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RequestOption value
     * @throws \InvalidArgumentException
     * @param string[] $requestOption
     * @return \Ups\upslabelStruct\UpsRequestType
     */
    public function setRequestOption(array $requestOption = array())
    {
        // validation for constraint: array
        if ('' !== ($requestOptionArrayErrorMessage = self::validateRequestOptionForArrayConstraintsFromSetRequestOption($requestOption))) {
            throw new \InvalidArgumentException($requestOptionArrayErrorMessage, __LINE__);
        }
        $this->RequestOption = $requestOption;
        return $this;
    }
    /**
     * Add item to RequestOption value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Ups\upslabelStruct\UpsRequestType
     */
    public function addToRequestOption($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The RequestOption property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RequestOption[] = $item;
        return $this;
    }
    /**
     * Get SubVersion value
     * @return string|null
     */
    public function getSubVersion()
    {
        return $this->SubVersion;
    }
    /**
     * Set SubVersion value
     * @param string $subVersion
     * @return \Ups\upslabelStruct\UpsRequestType
     */
    public function setSubVersion($subVersion = null)
    {
        // validation for constraint: string
        if (!is_null($subVersion) && !is_string($subVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subVersion, true), gettype($subVersion)), __LINE__);
        }
        $this->SubVersion = $subVersion;
        return $this;
    }
    /**
     * Get TransactionReference value
     * @return \Ups\upslabelStruct\UpsTransactionReferenceType|null
     */
    public function getTransactionReference()
    {
        return $this->TransactionReference;
    }
    /**
     * Set TransactionReference value
     * @param \Ups\upslabelStruct\UpsTransactionReferenceType $transactionReference
     * @return \Ups\upslabelStruct\UpsRequestType
     */
    public function setTransactionReference(\Ups\upslabelStruct\UpsTransactionReferenceType $transactionReference = null)
    {
        $this->TransactionReference = $transactionReference;
        return $this;
    }
}
