<?php

namespace Ups\upslabelStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReceiptType upslabelStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsReceiptType extends AbstractStructBase
{
    /**
     * The HTMLImage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $HTMLImage;
    /**
     * The Image
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups\upslabelStruct\UpsImageType
     */
    public $Image;
    /**
     * The URL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $URL;
    /**
     * Constructor method for ReceiptType
     * @uses UpsReceiptType::setHTMLImage()
     * @uses UpsReceiptType::setImage()
     * @uses UpsReceiptType::setURL()
     * @param string $hTMLImage
     * @param \Ups\upslabelStruct\UpsImageType $image
     * @param string $uRL
     */
    public function __construct($hTMLImage = null, \Ups\upslabelStruct\UpsImageType $image = null, $uRL = null)
    {
        $this
            ->setHTMLImage($hTMLImage)
            ->setImage($image)
            ->setURL($uRL);
    }
    /**
     * Get HTMLImage value
     * @return string|null
     */
    public function getHTMLImage()
    {
        return $this->HTMLImage;
    }
    /**
     * Set HTMLImage value
     * @param string $hTMLImage
     * @return \Ups\upslabelStruct\UpsReceiptType
     */
    public function setHTMLImage($hTMLImage = null)
    {
        // validation for constraint: string
        if (!is_null($hTMLImage) && !is_string($hTMLImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hTMLImage, true), gettype($hTMLImage)), __LINE__);
        }
        $this->HTMLImage = $hTMLImage;
        return $this;
    }
    /**
     * Get Image value
     * @return \Ups\upslabelStruct\UpsImageType|null
     */
    public function getImage()
    {
        return $this->Image;
    }
    /**
     * Set Image value
     * @param \Ups\upslabelStruct\UpsImageType $image
     * @return \Ups\upslabelStruct\UpsReceiptType
     */
    public function setImage(\Ups\upslabelStruct\UpsImageType $image = null)
    {
        $this->Image = $image;
        return $this;
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @param string $uRL
     * @return \Ups\upslabelStruct\UpsReceiptType
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRL, true), gettype($uRL)), __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
}
