<?php

namespace Ups\upslabelStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LRUPSPremiumCareFormType upslabelStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsLRUPSPremiumCareFormType extends AbstractStructBase
{
    /**
     * The PageSize
     * @var string
     */
    public $PageSize;
    /**
     * The PrintType
     * @var string
     */
    public $PrintType;
    /**
     * Constructor method for LRUPSPremiumCareFormType
     * @uses UpsLRUPSPremiumCareFormType::setPageSize()
     * @uses UpsLRUPSPremiumCareFormType::setPrintType()
     * @param string $pageSize
     * @param string $printType
     */
    public function __construct($pageSize = null, $printType = null)
    {
        $this
            ->setPageSize($pageSize)
            ->setPrintType($printType);
    }
    /**
     * Get PageSize value
     * @return string|null
     */
    public function getPageSize()
    {
        return $this->PageSize;
    }
    /**
     * Set PageSize value
     * @param string $pageSize
     * @return \Ups\upslabelStruct\UpsLRUPSPremiumCareFormType
     */
    public function setPageSize($pageSize = null)
    {
        // validation for constraint: string
        if (!is_null($pageSize) && !is_string($pageSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pageSize, true), gettype($pageSize)), __LINE__);
        }
        $this->PageSize = $pageSize;
        return $this;
    }
    /**
     * Get PrintType value
     * @return string|null
     */
    public function getPrintType()
    {
        return $this->PrintType;
    }
    /**
     * Set PrintType value
     * @param string $printType
     * @return \Ups\upslabelStruct\UpsLRUPSPremiumCareFormType
     */
    public function setPrintType($printType = null)
    {
        // validation for constraint: string
        if (!is_null($printType) && !is_string($printType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printType, true), gettype($printType)), __LINE__);
        }
        $this->PrintType = $printType;
        return $this;
    }
}
