<?php

namespace Ups\upslabelStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ElementLevelInformationType upslabelStruct
 * @package Ups
 * @subpackage Structs
 */
class UpsElementLevelInformationType extends AbstractStructBase
{
    /**
     * The Level
     * @var string
     */
    public $Level;
    /**
     * The ElementIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups\upslabelStruct\UpsElementIdentifierType[]
     */
    public $ElementIdentifier;
    /**
     * Constructor method for ElementLevelInformationType
     * @uses UpsElementLevelInformationType::setLevel()
     * @uses UpsElementLevelInformationType::setElementIdentifier()
     * @param string $level
     * @param \Ups\upslabelStruct\UpsElementIdentifierType[] $elementIdentifier
     */
    public function __construct($level = null, array $elementIdentifier = array())
    {
        $this
            ->setLevel($level)
            ->setElementIdentifier($elementIdentifier);
    }
    /**
     * Get Level value
     * @return string|null
     */
    public function getLevel()
    {
        return $this->Level;
    }
    /**
     * Set Level value
     * @param string $level
     * @return \Ups\upslabelStruct\UpsElementLevelInformationType
     */
    public function setLevel($level = null)
    {
        // validation for constraint: string
        if (!is_null($level) && !is_string($level)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($level, true), gettype($level)), __LINE__);
        }
        $this->Level = $level;
        return $this;
    }
    /**
     * Get ElementIdentifier value
     * @return \Ups\upslabelStruct\UpsElementIdentifierType[]|null
     */
    public function getElementIdentifier()
    {
        return $this->ElementIdentifier;
    }
    /**
     * This method is responsible for validating the values passed to the setElementIdentifier method
     * This method is willingly generated in order to preserve the one-line inline validation within the setElementIdentifier method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateElementIdentifierForArrayConstraintsFromSetElementIdentifier(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $elementLevelInformationTypeElementIdentifierItem) {
            // validation for constraint: itemType
            if (!$elementLevelInformationTypeElementIdentifierItem instanceof \Ups\upslabelStruct\UpsElementIdentifierType) {
                $invalidValues[] = is_object($elementLevelInformationTypeElementIdentifierItem) ? get_class($elementLevelInformationTypeElementIdentifierItem) : sprintf('%s(%s)', gettype($elementLevelInformationTypeElementIdentifierItem), var_export($elementLevelInformationTypeElementIdentifierItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ElementIdentifier property can only contain items of type \Ups\upslabelStruct\UpsElementIdentifierType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ElementIdentifier value
     * @throws \InvalidArgumentException
     * @param \Ups\upslabelStruct\UpsElementIdentifierType[] $elementIdentifier
     * @return \Ups\upslabelStruct\UpsElementLevelInformationType
     */
    public function setElementIdentifier(array $elementIdentifier = array())
    {
        // validation for constraint: array
        if ('' !== ($elementIdentifierArrayErrorMessage = self::validateElementIdentifierForArrayConstraintsFromSetElementIdentifier($elementIdentifier))) {
            throw new \InvalidArgumentException($elementIdentifierArrayErrorMessage, __LINE__);
        }
        $this->ElementIdentifier = $elementIdentifier;
        return $this;
    }
    /**
     * Add item to ElementIdentifier value
     * @throws \InvalidArgumentException
     * @param \Ups\upslabelStruct\UpsElementIdentifierType $item
     * @return \Ups\upslabelStruct\UpsElementLevelInformationType
     */
    public function addToElementIdentifier(\Ups\upslabelStruct\UpsElementIdentifierType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups\upslabelStruct\UpsElementIdentifierType) {
            throw new \InvalidArgumentException(sprintf('The ElementIdentifier property can only contain items of type \Ups\upslabelStruct\UpsElementIdentifierType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ElementIdentifier[] = $item;
        return $this;
    }
}
