<?php

namespace App\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SDTWSCFEConsultarCFEsEmitidosInV2 StructType
 * @subpackage Structs
 */
class SDTWSCFEConsultarCFEsEmitidosInV2 extends AbstractStructBase
{
    /**
     * The Conexion
     * @var \App\Soap\StructType\SDTWSCFEConexionV1
     */
    public $Conexion;
    /**
     * The EI
     * @var string
     */
    public $EI;
    /**
     * The EmisorCFETipo
     * @var string
     */
    public $EmisorCFETipo;
    /**
     * The TipoDeCFEReceptorNacional
     * @var string
     */
    public $TipoDeCFEReceptorNacional;
    /**
     * The TipoDeCFESiRequiereRUT
     * @var string
     */
    public $TipoDeCFESiRequiereRUT;
    /**
     * The FechaEmisionDesde
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FechaEmisionDesde;
    /**
     * The FechaEmisionHasta
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FechaEmisionHasta;
    /**
     * The EstadoLocal
     * @var string
     */
    public $EstadoLocal;
    /**
     * The EstadoDGI
     * @var string
     */
    public $EstadoDGI;
    /**
     * The EstadoReceptor
     * @var string
     */
    public $EstadoReceptor;
    /**
     * The RegistrosPorPagina
     * @var int
     */
    public $RegistrosPorPagina;
    /**
     * The Pagina
     * @var int
     */
    public $Pagina;
    /**
     * Constructor method for SDTWSCFEConsultarCFEsEmitidosInV2
     * @uses SDTWSCFEConsultarCFEsEmitidosInV2::setConexion()
     * @uses SDTWSCFEConsultarCFEsEmitidosInV2::setEI()
     * @uses SDTWSCFEConsultarCFEsEmitidosInV2::setEmisorCFETipo()
     * @uses SDTWSCFEConsultarCFEsEmitidosInV2::setTipoDeCFEReceptorNacional()
     * @uses SDTWSCFEConsultarCFEsEmitidosInV2::setTipoDeCFESiRequiereRUT()
     * @uses SDTWSCFEConsultarCFEsEmitidosInV2::setFechaEmisionDesde()
     * @uses SDTWSCFEConsultarCFEsEmitidosInV2::setFechaEmisionHasta()
     * @uses SDTWSCFEConsultarCFEsEmitidosInV2::setEstadoLocal()
     * @uses SDTWSCFEConsultarCFEsEmitidosInV2::setEstadoDGI()
     * @uses SDTWSCFEConsultarCFEsEmitidosInV2::setEstadoReceptor()
     * @uses SDTWSCFEConsultarCFEsEmitidosInV2::setRegistrosPorPagina()
     * @uses SDTWSCFEConsultarCFEsEmitidosInV2::setPagina()
     * @param \App\Soap\StructType\SDTWSCFEConexionV1 $conexion
     * @param string $eI
     * @param string $emisorCFETipo
     * @param string $tipoDeCFEReceptorNacional
     * @param string $tipoDeCFESiRequiereRUT
     * @param string $fechaEmisionDesde
     * @param string $fechaEmisionHasta
     * @param string $estadoLocal
     * @param string $estadoDGI
     * @param string $estadoReceptor
     * @param int $registrosPorPagina
     * @param int $pagina
     */
    public function __construct(\App\Soap\StructType\SDTWSCFEConexionV1 $conexion = null, $eI = null, $emisorCFETipo = null, $tipoDeCFEReceptorNacional = null, $tipoDeCFESiRequiereRUT = null, $fechaEmisionDesde = null, $fechaEmisionHasta = null, $estadoLocal = null, $estadoDGI = null, $estadoReceptor = null, $registrosPorPagina = null, $pagina = null)
    {
        $this
            ->setConexion($conexion)
            ->setEI($eI)
            ->setEmisorCFETipo($emisorCFETipo)
            ->setTipoDeCFEReceptorNacional($tipoDeCFEReceptorNacional)
            ->setTipoDeCFESiRequiereRUT($tipoDeCFESiRequiereRUT)
            ->setFechaEmisionDesde($fechaEmisionDesde)
            ->setFechaEmisionHasta($fechaEmisionHasta)
            ->setEstadoLocal($estadoLocal)
            ->setEstadoDGI($estadoDGI)
            ->setEstadoReceptor($estadoReceptor)
            ->setRegistrosPorPagina($registrosPorPagina)
            ->setPagina($pagina);
    }
    /**
     * Get Conexion value
     * @return \App\Soap\StructType\SDTWSCFEConexionV1|null
     */
    public function getConexion()
    {
        return $this->Conexion;
    }
    /**
     * Set Conexion value
     * @param \App\Soap\StructType\SDTWSCFEConexionV1 $conexion
     * @return \App\Soap\StructType\SDTWSCFEConsultarCFEsEmitidosInV2
     */
    public function setConexion(\App\Soap\StructType\SDTWSCFEConexionV1 $conexion = null)
    {
        $this->Conexion = $conexion;
        return $this;
    }
    /**
     * Get EI value
     * @return string|null
     */
    public function getEI()
    {
        return $this->EI;
    }
    /**
     * Set EI value
     * @param string $eI
     * @return \App\Soap\StructType\SDTWSCFEConsultarCFEsEmitidosInV2
     */
    public function setEI($eI = null)
    {
        // validation for constraint: string
        if (!is_null($eI) && !is_string($eI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eI, true), gettype($eI)), __LINE__);
        }
        $this->EI = $eI;
        return $this;
    }
    /**
     * Get EmisorCFETipo value
     * @return string|null
     */
    public function getEmisorCFETipo()
    {
        return $this->EmisorCFETipo;
    }
    /**
     * Set EmisorCFETipo value
     * @param string $emisorCFETipo
     * @return \App\Soap\StructType\SDTWSCFEConsultarCFEsEmitidosInV2
     */
    public function setEmisorCFETipo($emisorCFETipo = null)
    {
        // validation for constraint: string
        if (!is_null($emisorCFETipo) && !is_string($emisorCFETipo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emisorCFETipo, true), gettype($emisorCFETipo)), __LINE__);
        }
        $this->EmisorCFETipo = $emisorCFETipo;
        return $this;
    }
    /**
     * Get TipoDeCFEReceptorNacional value
     * @return string|null
     */
    public function getTipoDeCFEReceptorNacional()
    {
        return $this->TipoDeCFEReceptorNacional;
    }
    /**
     * Set TipoDeCFEReceptorNacional value
     * @param string $tipoDeCFEReceptorNacional
     * @return \App\Soap\StructType\SDTWSCFEConsultarCFEsEmitidosInV2
     */
    public function setTipoDeCFEReceptorNacional($tipoDeCFEReceptorNacional = null)
    {
        // validation for constraint: string
        if (!is_null($tipoDeCFEReceptorNacional) && !is_string($tipoDeCFEReceptorNacional)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoDeCFEReceptorNacional, true), gettype($tipoDeCFEReceptorNacional)), __LINE__);
        }
        $this->TipoDeCFEReceptorNacional = $tipoDeCFEReceptorNacional;
        return $this;
    }
    /**
     * Get TipoDeCFESiRequiereRUT value
     * @return string|null
     */
    public function getTipoDeCFESiRequiereRUT()
    {
        return $this->TipoDeCFESiRequiereRUT;
    }
    /**
     * Set TipoDeCFESiRequiereRUT value
     * @param string $tipoDeCFESiRequiereRUT
     * @return \App\Soap\StructType\SDTWSCFEConsultarCFEsEmitidosInV2
     */
    public function setTipoDeCFESiRequiereRUT($tipoDeCFESiRequiereRUT = null)
    {
        // validation for constraint: string
        if (!is_null($tipoDeCFESiRequiereRUT) && !is_string($tipoDeCFESiRequiereRUT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoDeCFESiRequiereRUT, true), gettype($tipoDeCFESiRequiereRUT)), __LINE__);
        }
        $this->TipoDeCFESiRequiereRUT = $tipoDeCFESiRequiereRUT;
        return $this;
    }
    /**
     * Get FechaEmisionDesde value
     * @return string|null
     */
    public function getFechaEmisionDesde()
    {
        return $this->FechaEmisionDesde;
    }
    /**
     * Set FechaEmisionDesde value
     * @param string $fechaEmisionDesde
     * @return \App\Soap\StructType\SDTWSCFEConsultarCFEsEmitidosInV2
     */
    public function setFechaEmisionDesde($fechaEmisionDesde = null)
    {
        // validation for constraint: string
        if (!is_null($fechaEmisionDesde) && !is_string($fechaEmisionDesde)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaEmisionDesde, true), gettype($fechaEmisionDesde)), __LINE__);
        }
        $this->FechaEmisionDesde = $fechaEmisionDesde;
        return $this;
    }
    /**
     * Get FechaEmisionHasta value
     * @return string|null
     */
    public function getFechaEmisionHasta()
    {
        return $this->FechaEmisionHasta;
    }
    /**
     * Set FechaEmisionHasta value
     * @param string $fechaEmisionHasta
     * @return \App\Soap\StructType\SDTWSCFEConsultarCFEsEmitidosInV2
     */
    public function setFechaEmisionHasta($fechaEmisionHasta = null)
    {
        // validation for constraint: string
        if (!is_null($fechaEmisionHasta) && !is_string($fechaEmisionHasta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaEmisionHasta, true), gettype($fechaEmisionHasta)), __LINE__);
        }
        $this->FechaEmisionHasta = $fechaEmisionHasta;
        return $this;
    }
    /**
     * Get EstadoLocal value
     * @return string|null
     */
    public function getEstadoLocal()
    {
        return $this->EstadoLocal;
    }
    /**
     * Set EstadoLocal value
     * @param string $estadoLocal
     * @return \App\Soap\StructType\SDTWSCFEConsultarCFEsEmitidosInV2
     */
    public function setEstadoLocal($estadoLocal = null)
    {
        // validation for constraint: string
        if (!is_null($estadoLocal) && !is_string($estadoLocal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estadoLocal, true), gettype($estadoLocal)), __LINE__);
        }
        $this->EstadoLocal = $estadoLocal;
        return $this;
    }
    /**
     * Get EstadoDGI value
     * @return string|null
     */
    public function getEstadoDGI()
    {
        return $this->EstadoDGI;
    }
    /**
     * Set EstadoDGI value
     * @param string $estadoDGI
     * @return \App\Soap\StructType\SDTWSCFEConsultarCFEsEmitidosInV2
     */
    public function setEstadoDGI($estadoDGI = null)
    {
        // validation for constraint: string
        if (!is_null($estadoDGI) && !is_string($estadoDGI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estadoDGI, true), gettype($estadoDGI)), __LINE__);
        }
        $this->EstadoDGI = $estadoDGI;
        return $this;
    }
    /**
     * Get EstadoReceptor value
     * @return string|null
     */
    public function getEstadoReceptor()
    {
        return $this->EstadoReceptor;
    }
    /**
     * Set EstadoReceptor value
     * @param string $estadoReceptor
     * @return \App\Soap\StructType\SDTWSCFEConsultarCFEsEmitidosInV2
     */
    public function setEstadoReceptor($estadoReceptor = null)
    {
        // validation for constraint: string
        if (!is_null($estadoReceptor) && !is_string($estadoReceptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estadoReceptor, true), gettype($estadoReceptor)), __LINE__);
        }
        $this->EstadoReceptor = $estadoReceptor;
        return $this;
    }
    /**
     * Get RegistrosPorPagina value
     * @return int|null
     */
    public function getRegistrosPorPagina()
    {
        return $this->RegistrosPorPagina;
    }
    /**
     * Set RegistrosPorPagina value
     * @param int $registrosPorPagina
     * @return \App\Soap\StructType\SDTWSCFEConsultarCFEsEmitidosInV2
     */
    public function setRegistrosPorPagina($registrosPorPagina = null)
    {
        // validation for constraint: int
        if (!is_null($registrosPorPagina) && !(is_int($registrosPorPagina) || ctype_digit($registrosPorPagina))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($registrosPorPagina, true), gettype($registrosPorPagina)), __LINE__);
        }
        $this->RegistrosPorPagina = $registrosPorPagina;
        return $this;
    }
    /**
     * Get Pagina value
     * @return int|null
     */
    public function getPagina()
    {
        return $this->Pagina;
    }
    /**
     * Set Pagina value
     * @param int $pagina
     * @return \App\Soap\StructType\SDTWSCFEConsultarCFEsEmitidosInV2
     */
    public function setPagina($pagina = null)
    {
        // validation for constraint: int
        if (!is_null($pagina) && !(is_int($pagina) || ctype_digit($pagina))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pagina, true), gettype($pagina)), __LINE__);
        }
        $this->Pagina = $pagina;
        return $this;
    }
}
