<?php

namespace App\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * eFactura.WebServices.SDTWSCFEResultadoEnvioCFEsInV3.CFEsItem StructType
 * @subpackage Structs
 */
class EFactura_WebServices_SDTWSCFEResultadoEnvioCFEsInV3_CFEsItem extends AbstractStructBase
{
    /**
     * The EI
     * @var string
     */
    public $EI;
    /**
     * The EmisorTipo
     * @var string
     */
    public $EmisorTipo;
    /**
     * The EmisorSerie
     * @var string
     */
    public $EmisorSerie;
    /**
     * The EmisorNumero
     * @var int
     */
    public $EmisorNumero;
    /**
     * The CFESerie
     * @var string
     */
    public $CFESerie;
    /**
     * The CFENumero
     * @var int
     */
    public $CFENumero;
    /**
     * Constructor method for
     * eFactura.WebServices.SDTWSCFEResultadoEnvioCFEsInV3.CFEsItem
     * @uses EFactura_WebServices_SDTWSCFEResultadoEnvioCFEsInV3_CFEsItem::setEI()
     * @uses EFactura_WebServices_SDTWSCFEResultadoEnvioCFEsInV3_CFEsItem::setEmisorTipo()
     * @uses EFactura_WebServices_SDTWSCFEResultadoEnvioCFEsInV3_CFEsItem::setEmisorSerie()
     * @uses EFactura_WebServices_SDTWSCFEResultadoEnvioCFEsInV3_CFEsItem::setEmisorNumero()
     * @uses EFactura_WebServices_SDTWSCFEResultadoEnvioCFEsInV3_CFEsItem::setCFESerie()
     * @uses EFactura_WebServices_SDTWSCFEResultadoEnvioCFEsInV3_CFEsItem::setCFENumero()
     * @param string $eI
     * @param string $emisorTipo
     * @param string $emisorSerie
     * @param int $emisorNumero
     * @param string $cFESerie
     * @param int $cFENumero
     */
    public function __construct($eI = null, $emisorTipo = null, $emisorSerie = null, $emisorNumero = null, $cFESerie = null, $cFENumero = null)
    {
        $this
            ->setEI($eI)
            ->setEmisorTipo($emisorTipo)
            ->setEmisorSerie($emisorSerie)
            ->setEmisorNumero($emisorNumero)
            ->setCFESerie($cFESerie)
            ->setCFENumero($cFENumero);
    }
    /**
     * Get EI value
     * @return string|null
     */
    public function getEI()
    {
        return $this->EI;
    }
    /**
     * Set EI value
     * @param string $eI
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEResultadoEnvioCFEsInV3_CFEsItem
     */
    public function setEI($eI = null)
    {
        // validation for constraint: string
        if (!is_null($eI) && !is_string($eI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eI, true), gettype($eI)), __LINE__);
        }
        $this->EI = $eI;
        return $this;
    }
    /**
     * Get EmisorTipo value
     * @return string|null
     */
    public function getEmisorTipo()
    {
        return $this->EmisorTipo;
    }
    /**
     * Set EmisorTipo value
     * @param string $emisorTipo
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEResultadoEnvioCFEsInV3_CFEsItem
     */
    public function setEmisorTipo($emisorTipo = null)
    {
        // validation for constraint: string
        if (!is_null($emisorTipo) && !is_string($emisorTipo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emisorTipo, true), gettype($emisorTipo)), __LINE__);
        }
        $this->EmisorTipo = $emisorTipo;
        return $this;
    }
    /**
     * Get EmisorSerie value
     * @return string|null
     */
    public function getEmisorSerie()
    {
        return $this->EmisorSerie;
    }
    /**
     * Set EmisorSerie value
     * @param string $emisorSerie
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEResultadoEnvioCFEsInV3_CFEsItem
     */
    public function setEmisorSerie($emisorSerie = null)
    {
        // validation for constraint: string
        if (!is_null($emisorSerie) && !is_string($emisorSerie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emisorSerie, true), gettype($emisorSerie)), __LINE__);
        }
        $this->EmisorSerie = $emisorSerie;
        return $this;
    }
    /**
     * Get EmisorNumero value
     * @return int|null
     */
    public function getEmisorNumero()
    {
        return $this->EmisorNumero;
    }
    /**
     * Set EmisorNumero value
     * @param int $emisorNumero
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEResultadoEnvioCFEsInV3_CFEsItem
     */
    public function setEmisorNumero($emisorNumero = null)
    {
        // validation for constraint: int
        if (!is_null($emisorNumero) && !(is_int($emisorNumero) || ctype_digit($emisorNumero))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($emisorNumero, true), gettype($emisorNumero)), __LINE__);
        }
        $this->EmisorNumero = $emisorNumero;
        return $this;
    }
    /**
     * Get CFESerie value
     * @return string|null
     */
    public function getCFESerie()
    {
        return $this->CFESerie;
    }
    /**
     * Set CFESerie value
     * @param string $cFESerie
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEResultadoEnvioCFEsInV3_CFEsItem
     */
    public function setCFESerie($cFESerie = null)
    {
        // validation for constraint: string
        if (!is_null($cFESerie) && !is_string($cFESerie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cFESerie, true), gettype($cFESerie)), __LINE__);
        }
        $this->CFESerie = $cFESerie;
        return $this;
    }
    /**
     * Get CFENumero value
     * @return int|null
     */
    public function getCFENumero()
    {
        return $this->CFENumero;
    }
    /**
     * Set CFENumero value
     * @param int $cFENumero
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEResultadoEnvioCFEsInV3_CFEsItem
     */
    public function setCFENumero($cFENumero = null)
    {
        // validation for constraint: int
        if (!is_null($cFENumero) && !(is_int($cFENumero) || ctype_digit($cFENumero))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cFENumero, true), gettype($cFENumero)), __LINE__);
        }
        $this->CFENumero = $cFENumero;
        return $this;
    }
}
