<?php

namespace App\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for eFactura.WebServices.SDTWSCFEResponderCFEsInV2.CFEsItem
 * StructType
 * @subpackage Structs
 */
class EFactura_WebServices_SDTWSCFEResponderCFEsInV2_CFEsItem extends AbstractStructBase
{
    /**
     * The EmisorRUT
     * @var string
     */
    public $EmisorRUT;
    /**
     * The EmisorCFETipo
     * @var string
     */
    public $EmisorCFETipo;
    /**
     * The CFESerie
     * @var string
     */
    public $CFESerie;
    /**
     * The CFENumero
     * @var int
     */
    public $CFENumero;
    /**
     * The Accion
     * @var string
     */
    public $Accion;
    /**
     * The MotivoDeRechazo
     * @var string
     */
    public $MotivoDeRechazo;
    /**
     * The Detalle
     * @var string
     */
    public $Detalle;
    /**
     * Constructor method for eFactura.WebServices.SDTWSCFEResponderCFEsInV2.CFEsItem
     * @uses EFactura_WebServices_SDTWSCFEResponderCFEsInV2_CFEsItem::setEmisorRUT()
     * @uses EFactura_WebServices_SDTWSCFEResponderCFEsInV2_CFEsItem::setEmisorCFETipo()
     * @uses EFactura_WebServices_SDTWSCFEResponderCFEsInV2_CFEsItem::setCFESerie()
     * @uses EFactura_WebServices_SDTWSCFEResponderCFEsInV2_CFEsItem::setCFENumero()
     * @uses EFactura_WebServices_SDTWSCFEResponderCFEsInV2_CFEsItem::setAccion()
     * @uses EFactura_WebServices_SDTWSCFEResponderCFEsInV2_CFEsItem::setMotivoDeRechazo()
     * @uses EFactura_WebServices_SDTWSCFEResponderCFEsInV2_CFEsItem::setDetalle()
     * @param string $emisorRUT
     * @param string $emisorCFETipo
     * @param string $cFESerie
     * @param int $cFENumero
     * @param string $accion
     * @param string $motivoDeRechazo
     * @param string $detalle
     */
    public function __construct($emisorRUT = null, $emisorCFETipo = null, $cFESerie = null, $cFENumero = null, $accion = null, $motivoDeRechazo = null, $detalle = null)
    {
        $this
            ->setEmisorRUT($emisorRUT)
            ->setEmisorCFETipo($emisorCFETipo)
            ->setCFESerie($cFESerie)
            ->setCFENumero($cFENumero)
            ->setAccion($accion)
            ->setMotivoDeRechazo($motivoDeRechazo)
            ->setDetalle($detalle);
    }
    /**
     * Get EmisorRUT value
     * @return string|null
     */
    public function getEmisorRUT()
    {
        return $this->EmisorRUT;
    }
    /**
     * Set EmisorRUT value
     * @param string $emisorRUT
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEResponderCFEsInV2_CFEsItem
     */
    public function setEmisorRUT($emisorRUT = null)
    {
        // validation for constraint: string
        if (!is_null($emisorRUT) && !is_string($emisorRUT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emisorRUT, true), gettype($emisorRUT)), __LINE__);
        }
        $this->EmisorRUT = $emisorRUT;
        return $this;
    }
    /**
     * Get EmisorCFETipo value
     * @return string|null
     */
    public function getEmisorCFETipo()
    {
        return $this->EmisorCFETipo;
    }
    /**
     * Set EmisorCFETipo value
     * @param string $emisorCFETipo
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEResponderCFEsInV2_CFEsItem
     */
    public function setEmisorCFETipo($emisorCFETipo = null)
    {
        // validation for constraint: string
        if (!is_null($emisorCFETipo) && !is_string($emisorCFETipo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emisorCFETipo, true), gettype($emisorCFETipo)), __LINE__);
        }
        $this->EmisorCFETipo = $emisorCFETipo;
        return $this;
    }
    /**
     * Get CFESerie value
     * @return string|null
     */
    public function getCFESerie()
    {
        return $this->CFESerie;
    }
    /**
     * Set CFESerie value
     * @param string $cFESerie
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEResponderCFEsInV2_CFEsItem
     */
    public function setCFESerie($cFESerie = null)
    {
        // validation for constraint: string
        if (!is_null($cFESerie) && !is_string($cFESerie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cFESerie, true), gettype($cFESerie)), __LINE__);
        }
        $this->CFESerie = $cFESerie;
        return $this;
    }
    /**
     * Get CFENumero value
     * @return int|null
     */
    public function getCFENumero()
    {
        return $this->CFENumero;
    }
    /**
     * Set CFENumero value
     * @param int $cFENumero
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEResponderCFEsInV2_CFEsItem
     */
    public function setCFENumero($cFENumero = null)
    {
        // validation for constraint: int
        if (!is_null($cFENumero) && !(is_int($cFENumero) || ctype_digit($cFENumero))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cFENumero, true), gettype($cFENumero)), __LINE__);
        }
        $this->CFENumero = $cFENumero;
        return $this;
    }
    /**
     * Get Accion value
     * @return string|null
     */
    public function getAccion()
    {
        return $this->Accion;
    }
    /**
     * Set Accion value
     * @param string $accion
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEResponderCFEsInV2_CFEsItem
     */
    public function setAccion($accion = null)
    {
        // validation for constraint: string
        if (!is_null($accion) && !is_string($accion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accion, true), gettype($accion)), __LINE__);
        }
        $this->Accion = $accion;
        return $this;
    }
    /**
     * Get MotivoDeRechazo value
     * @return string|null
     */
    public function getMotivoDeRechazo()
    {
        return $this->MotivoDeRechazo;
    }
    /**
     * Set MotivoDeRechazo value
     * @param string $motivoDeRechazo
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEResponderCFEsInV2_CFEsItem
     */
    public function setMotivoDeRechazo($motivoDeRechazo = null)
    {
        // validation for constraint: string
        if (!is_null($motivoDeRechazo) && !is_string($motivoDeRechazo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($motivoDeRechazo, true), gettype($motivoDeRechazo)), __LINE__);
        }
        $this->MotivoDeRechazo = $motivoDeRechazo;
        return $this;
    }
    /**
     * Get Detalle value
     * @return string|null
     */
    public function getDetalle()
    {
        return $this->Detalle;
    }
    /**
     * Set Detalle value
     * @param string $detalle
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEResponderCFEsInV2_CFEsItem
     */
    public function setDetalle($detalle = null)
    {
        // validation for constraint: string
        if (!is_null($detalle) && !is_string($detalle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($detalle, true), gettype($detalle)), __LINE__);
        }
        $this->Detalle = $detalle;
        return $this;
    }
}
