<?php

namespace App\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for eFactura.WebServices.SDTWSCFEEnviarCFEOutV4.Respuesta
 * StructType
 * @subpackage Structs
 */
class EFactura_WebServices_SDTWSCFEEnviarCFEOutV4_Respuesta extends AbstractStructBase
{
    /**
     * The CFESerie
     * @var string
     */
    public $CFESerie;
    /**
     * The CFENumero
     * @var int
     */
    public $CFENumero;
    /**
     * The DigestValue
     * @var string
     */
    public $DigestValue;
    /**
     * The PDFLink
     * @var string
     */
    public $PDFLink;
    /**
     * The DGILink
     * @var string
     */
    public $DGILink;
    /**
     * The QR
     * @var string
     */
    public $QR;
    /**
     * The EstadoLocal
     * @var string
     */
    public $EstadoLocal;
    /**
     * The CAE
     * @var \App\Soap\StructType\SDTWSCFEV1CAEData
     */
    public $CAE;
    /**
     * The Cobranza
     * @var \App\Soap\StructType\SDTWSCFECobranzaDataV1
     */
    public $Cobranza;
    /**
     * Constructor method for eFactura.WebServices.SDTWSCFEEnviarCFEOutV4.Respuesta
     * @uses EFactura_WebServices_SDTWSCFEEnviarCFEOutV4_Respuesta::setCFESerie()
     * @uses EFactura_WebServices_SDTWSCFEEnviarCFEOutV4_Respuesta::setCFENumero()
     * @uses EFactura_WebServices_SDTWSCFEEnviarCFEOutV4_Respuesta::setDigestValue()
     * @uses EFactura_WebServices_SDTWSCFEEnviarCFEOutV4_Respuesta::setPDFLink()
     * @uses EFactura_WebServices_SDTWSCFEEnviarCFEOutV4_Respuesta::setDGILink()
     * @uses EFactura_WebServices_SDTWSCFEEnviarCFEOutV4_Respuesta::setQR()
     * @uses EFactura_WebServices_SDTWSCFEEnviarCFEOutV4_Respuesta::setEstadoLocal()
     * @uses EFactura_WebServices_SDTWSCFEEnviarCFEOutV4_Respuesta::setCAE()
     * @uses EFactura_WebServices_SDTWSCFEEnviarCFEOutV4_Respuesta::setCobranza()
     * @param string $cFESerie
     * @param int $cFENumero
     * @param string $digestValue
     * @param string $pDFLink
     * @param string $dGILink
     * @param string $qR
     * @param string $estadoLocal
     * @param \App\Soap\StructType\SDTWSCFEV1CAEData $cAE
     * @param \App\Soap\StructType\SDTWSCFECobranzaDataV1 $cobranza
     */
    public function __construct($cFESerie = null, $cFENumero = null, $digestValue = null, $pDFLink = null, $dGILink = null, $qR = null, $estadoLocal = null, \App\Soap\StructType\SDTWSCFEV1CAEData $cAE = null, \App\Soap\StructType\SDTWSCFECobranzaDataV1 $cobranza = null)
    {
        $this
            ->setCFESerie($cFESerie)
            ->setCFENumero($cFENumero)
            ->setDigestValue($digestValue)
            ->setPDFLink($pDFLink)
            ->setDGILink($dGILink)
            ->setQR($qR)
            ->setEstadoLocal($estadoLocal)
            ->setCAE($cAE)
            ->setCobranza($cobranza);
    }
    /**
     * Get CFESerie value
     * @return string|null
     */
    public function getCFESerie()
    {
        return $this->CFESerie;
    }
    /**
     * Set CFESerie value
     * @param string $cFESerie
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEEnviarCFEOutV4_Respuesta
     */
    public function setCFESerie($cFESerie = null)
    {
        // validation for constraint: string
        if (!is_null($cFESerie) && !is_string($cFESerie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cFESerie, true), gettype($cFESerie)), __LINE__);
        }
        $this->CFESerie = $cFESerie;
        return $this;
    }
    /**
     * Get CFENumero value
     * @return int|null
     */
    public function getCFENumero()
    {
        return $this->CFENumero;
    }
    /**
     * Set CFENumero value
     * @param int $cFENumero
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEEnviarCFEOutV4_Respuesta
     */
    public function setCFENumero($cFENumero = null)
    {
        // validation for constraint: int
        if (!is_null($cFENumero) && !(is_int($cFENumero) || ctype_digit($cFENumero))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cFENumero, true), gettype($cFENumero)), __LINE__);
        }
        $this->CFENumero = $cFENumero;
        return $this;
    }
    /**
     * Get DigestValue value
     * @return string|null
     */
    public function getDigestValue()
    {
        return $this->DigestValue;
    }
    /**
     * Set DigestValue value
     * @param string $digestValue
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEEnviarCFEOutV4_Respuesta
     */
    public function setDigestValue($digestValue = null)
    {
        // validation for constraint: string
        if (!is_null($digestValue) && !is_string($digestValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($digestValue, true), gettype($digestValue)), __LINE__);
        }
        $this->DigestValue = $digestValue;
        return $this;
    }
    /**
     * Get PDFLink value
     * @return string|null
     */
    public function getPDFLink()
    {
        return $this->PDFLink;
    }
    /**
     * Set PDFLink value
     * @param string $pDFLink
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEEnviarCFEOutV4_Respuesta
     */
    public function setPDFLink($pDFLink = null)
    {
        // validation for constraint: string
        if (!is_null($pDFLink) && !is_string($pDFLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pDFLink, true), gettype($pDFLink)), __LINE__);
        }
        $this->PDFLink = $pDFLink;
        return $this;
    }
    /**
     * Get DGILink value
     * @return string|null
     */
    public function getDGILink()
    {
        return $this->DGILink;
    }
    /**
     * Set DGILink value
     * @param string $dGILink
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEEnviarCFEOutV4_Respuesta
     */
    public function setDGILink($dGILink = null)
    {
        // validation for constraint: string
        if (!is_null($dGILink) && !is_string($dGILink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dGILink, true), gettype($dGILink)), __LINE__);
        }
        $this->DGILink = $dGILink;
        return $this;
    }
    /**
     * Get QR value
     * @return string|null
     */
    public function getQR()
    {
        return $this->QR;
    }
    /**
     * Set QR value
     * @param string $qR
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEEnviarCFEOutV4_Respuesta
     */
    public function setQR($qR = null)
    {
        // validation for constraint: string
        if (!is_null($qR) && !is_string($qR)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qR, true), gettype($qR)), __LINE__);
        }
        $this->QR = $qR;
        return $this;
    }
    /**
     * Get EstadoLocal value
     * @return string|null
     */
    public function getEstadoLocal()
    {
        return $this->EstadoLocal;
    }
    /**
     * Set EstadoLocal value
     * @param string $estadoLocal
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEEnviarCFEOutV4_Respuesta
     */
    public function setEstadoLocal($estadoLocal = null)
    {
        // validation for constraint: string
        if (!is_null($estadoLocal) && !is_string($estadoLocal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estadoLocal, true), gettype($estadoLocal)), __LINE__);
        }
        $this->EstadoLocal = $estadoLocal;
        return $this;
    }
    /**
     * Get CAE value
     * @return \App\Soap\StructType\SDTWSCFEV1CAEData|null
     */
    public function getCAE()
    {
        return $this->CAE;
    }
    /**
     * Set CAE value
     * @param \App\Soap\StructType\SDTWSCFEV1CAEData $cAE
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEEnviarCFEOutV4_Respuesta
     */
    public function setCAE(\App\Soap\StructType\SDTWSCFEV1CAEData $cAE = null)
    {
        $this->CAE = $cAE;
        return $this;
    }
    /**
     * Get Cobranza value
     * @return \App\Soap\StructType\SDTWSCFECobranzaDataV1|null
     */
    public function getCobranza()
    {
        return $this->Cobranza;
    }
    /**
     * Set Cobranza value
     * @param \App\Soap\StructType\SDTWSCFECobranzaDataV1 $cobranza
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEEnviarCFEOutV4_Respuesta
     */
    public function setCobranza(\App\Soap\StructType\SDTWSCFECobranzaDataV1 $cobranza = null)
    {
        $this->Cobranza = $cobranza;
        return $this;
    }
}
