<?php

namespace App\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * eFactura.WebServices.SDTWSCFEConsultarCFEsEmtidosOutV1.Item StructType
 * @subpackage Structs
 */
class EFactura_WebServices_SDTWSCFEConsultarCFEsEmtidosOutV1_Item extends AbstractStructBase
{
    /**
     * The EmisorCFETipo
     * @var string
     */
    public $EmisorCFETipo;
    /**
     * The EsNacional
     * @var string
     */
    public $EsNacional;
    /**
     * The RequiereRUT
     * @var string
     */
    public $RequiereRUT;
    /**
     * The Serie
     * @var string
     */
    public $Serie;
    /**
     * The Numero
     * @var int
     */
    public $Numero;
    /**
     * The EstadoLocal
     * @var string
     */
    public $EstadoLocal;
    /**
     * The EstadoDGI
     * @var string
     */
    public $EstadoDGI;
    /**
     * The EstadoReceptor
     * @var string
     */
    public $EstadoReceptor;
    /**
     * The FechaEmision
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FechaEmision;
    /**
     * The ReceptorDenominacionSocial
     * @var string
     */
    public $ReceptorDenominacionSocial;
    /**
     * The ReceptorDocumento
     * @var string
     */
    public $ReceptorDocumento;
    /**
     * The ReceptorTipoDeDocumentoPaisId
     * @var string
     */
    public $ReceptorTipoDeDocumentoPaisId;
    /**
     * The ReceptorCiudad
     * @var string
     */
    public $ReceptorCiudad;
    /**
     * The ReceptorLocalidad
     * @var string
     */
    public $ReceptorLocalidad;
    /**
     * The ReceptorDireccion
     * @var string
     */
    public $ReceptorDireccion;
    /**
     * The Moneda
     * @var string
     */
    public $Moneda;
    /**
     * The TipoCambio
     * @var float
     */
    public $TipoCambio;
    /**
     * The Total
     * @var float
     */
    public $Total;
    /**
     * Constructor method for
     * eFactura.WebServices.SDTWSCFEConsultarCFEsEmtidosOutV1.Item
     * @uses EFactura_WebServices_SDTWSCFEConsultarCFEsEmtidosOutV1_Item::setEmisorCFETipo()
     * @uses EFactura_WebServices_SDTWSCFEConsultarCFEsEmtidosOutV1_Item::setEsNacional()
     * @uses EFactura_WebServices_SDTWSCFEConsultarCFEsEmtidosOutV1_Item::setRequiereRUT()
     * @uses EFactura_WebServices_SDTWSCFEConsultarCFEsEmtidosOutV1_Item::setSerie()
     * @uses EFactura_WebServices_SDTWSCFEConsultarCFEsEmtidosOutV1_Item::setNumero()
     * @uses EFactura_WebServices_SDTWSCFEConsultarCFEsEmtidosOutV1_Item::setEstadoLocal()
     * @uses EFactura_WebServices_SDTWSCFEConsultarCFEsEmtidosOutV1_Item::setEstadoDGI()
     * @uses EFactura_WebServices_SDTWSCFEConsultarCFEsEmtidosOutV1_Item::setEstadoReceptor()
     * @uses EFactura_WebServices_SDTWSCFEConsultarCFEsEmtidosOutV1_Item::setFechaEmision()
     * @uses EFactura_WebServices_SDTWSCFEConsultarCFEsEmtidosOutV1_Item::setReceptorDenominacionSocial()
     * @uses EFactura_WebServices_SDTWSCFEConsultarCFEsEmtidosOutV1_Item::setReceptorDocumento()
     * @uses EFactura_WebServices_SDTWSCFEConsultarCFEsEmtidosOutV1_Item::setReceptorTipoDeDocumentoPaisId()
     * @uses EFactura_WebServices_SDTWSCFEConsultarCFEsEmtidosOutV1_Item::setReceptorCiudad()
     * @uses EFactura_WebServices_SDTWSCFEConsultarCFEsEmtidosOutV1_Item::setReceptorLocalidad()
     * @uses EFactura_WebServices_SDTWSCFEConsultarCFEsEmtidosOutV1_Item::setReceptorDireccion()
     * @uses EFactura_WebServices_SDTWSCFEConsultarCFEsEmtidosOutV1_Item::setMoneda()
     * @uses EFactura_WebServices_SDTWSCFEConsultarCFEsEmtidosOutV1_Item::setTipoCambio()
     * @uses EFactura_WebServices_SDTWSCFEConsultarCFEsEmtidosOutV1_Item::setTotal()
     * @param string $emisorCFETipo
     * @param string $esNacional
     * @param string $requiereRUT
     * @param string $serie
     * @param int $numero
     * @param string $estadoLocal
     * @param string $estadoDGI
     * @param string $estadoReceptor
     * @param string $fechaEmision
     * @param string $receptorDenominacionSocial
     * @param string $receptorDocumento
     * @param string $receptorTipoDeDocumentoPaisId
     * @param string $receptorCiudad
     * @param string $receptorLocalidad
     * @param string $receptorDireccion
     * @param string $moneda
     * @param float $tipoCambio
     * @param float $total
     */
    public function __construct($emisorCFETipo = null, $esNacional = null, $requiereRUT = null, $serie = null, $numero = null, $estadoLocal = null, $estadoDGI = null, $estadoReceptor = null, $fechaEmision = null, $receptorDenominacionSocial = null, $receptorDocumento = null, $receptorTipoDeDocumentoPaisId = null, $receptorCiudad = null, $receptorLocalidad = null, $receptorDireccion = null, $moneda = null, $tipoCambio = null, $total = null)
    {
        $this
            ->setEmisorCFETipo($emisorCFETipo)
            ->setEsNacional($esNacional)
            ->setRequiereRUT($requiereRUT)
            ->setSerie($serie)
            ->setNumero($numero)
            ->setEstadoLocal($estadoLocal)
            ->setEstadoDGI($estadoDGI)
            ->setEstadoReceptor($estadoReceptor)
            ->setFechaEmision($fechaEmision)
            ->setReceptorDenominacionSocial($receptorDenominacionSocial)
            ->setReceptorDocumento($receptorDocumento)
            ->setReceptorTipoDeDocumentoPaisId($receptorTipoDeDocumentoPaisId)
            ->setReceptorCiudad($receptorCiudad)
            ->setReceptorLocalidad($receptorLocalidad)
            ->setReceptorDireccion($receptorDireccion)
            ->setMoneda($moneda)
            ->setTipoCambio($tipoCambio)
            ->setTotal($total);
    }
    /**
     * Get EmisorCFETipo value
     * @return string|null
     */
    public function getEmisorCFETipo()
    {
        return $this->EmisorCFETipo;
    }
    /**
     * Set EmisorCFETipo value
     * @param string $emisorCFETipo
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEConsultarCFEsEmtidosOutV1_Item
     */
    public function setEmisorCFETipo($emisorCFETipo = null)
    {
        // validation for constraint: string
        if (!is_null($emisorCFETipo) && !is_string($emisorCFETipo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emisorCFETipo, true), gettype($emisorCFETipo)), __LINE__);
        }
        $this->EmisorCFETipo = $emisorCFETipo;
        return $this;
    }
    /**
     * Get EsNacional value
     * @return string|null
     */
    public function getEsNacional()
    {
        return $this->EsNacional;
    }
    /**
     * Set EsNacional value
     * @param string $esNacional
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEConsultarCFEsEmtidosOutV1_Item
     */
    public function setEsNacional($esNacional = null)
    {
        // validation for constraint: string
        if (!is_null($esNacional) && !is_string($esNacional)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($esNacional, true), gettype($esNacional)), __LINE__);
        }
        $this->EsNacional = $esNacional;
        return $this;
    }
    /**
     * Get RequiereRUT value
     * @return string|null
     */
    public function getRequiereRUT()
    {
        return $this->RequiereRUT;
    }
    /**
     * Set RequiereRUT value
     * @param string $requiereRUT
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEConsultarCFEsEmtidosOutV1_Item
     */
    public function setRequiereRUT($requiereRUT = null)
    {
        // validation for constraint: string
        if (!is_null($requiereRUT) && !is_string($requiereRUT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requiereRUT, true), gettype($requiereRUT)), __LINE__);
        }
        $this->RequiereRUT = $requiereRUT;
        return $this;
    }
    /**
     * Get Serie value
     * @return string|null
     */
    public function getSerie()
    {
        return $this->Serie;
    }
    /**
     * Set Serie value
     * @param string $serie
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEConsultarCFEsEmtidosOutV1_Item
     */
    public function setSerie($serie = null)
    {
        // validation for constraint: string
        if (!is_null($serie) && !is_string($serie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serie, true), gettype($serie)), __LINE__);
        }
        $this->Serie = $serie;
        return $this;
    }
    /**
     * Get Numero value
     * @return int|null
     */
    public function getNumero()
    {
        return $this->Numero;
    }
    /**
     * Set Numero value
     * @param int $numero
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEConsultarCFEsEmtidosOutV1_Item
     */
    public function setNumero($numero = null)
    {
        // validation for constraint: int
        if (!is_null($numero) && !(is_int($numero) || ctype_digit($numero))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numero, true), gettype($numero)), __LINE__);
        }
        $this->Numero = $numero;
        return $this;
    }
    /**
     * Get EstadoLocal value
     * @return string|null
     */
    public function getEstadoLocal()
    {
        return $this->EstadoLocal;
    }
    /**
     * Set EstadoLocal value
     * @param string $estadoLocal
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEConsultarCFEsEmtidosOutV1_Item
     */
    public function setEstadoLocal($estadoLocal = null)
    {
        // validation for constraint: string
        if (!is_null($estadoLocal) && !is_string($estadoLocal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estadoLocal, true), gettype($estadoLocal)), __LINE__);
        }
        $this->EstadoLocal = $estadoLocal;
        return $this;
    }
    /**
     * Get EstadoDGI value
     * @return string|null
     */
    public function getEstadoDGI()
    {
        return $this->EstadoDGI;
    }
    /**
     * Set EstadoDGI value
     * @param string $estadoDGI
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEConsultarCFEsEmtidosOutV1_Item
     */
    public function setEstadoDGI($estadoDGI = null)
    {
        // validation for constraint: string
        if (!is_null($estadoDGI) && !is_string($estadoDGI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estadoDGI, true), gettype($estadoDGI)), __LINE__);
        }
        $this->EstadoDGI = $estadoDGI;
        return $this;
    }
    /**
     * Get EstadoReceptor value
     * @return string|null
     */
    public function getEstadoReceptor()
    {
        return $this->EstadoReceptor;
    }
    /**
     * Set EstadoReceptor value
     * @param string $estadoReceptor
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEConsultarCFEsEmtidosOutV1_Item
     */
    public function setEstadoReceptor($estadoReceptor = null)
    {
        // validation for constraint: string
        if (!is_null($estadoReceptor) && !is_string($estadoReceptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estadoReceptor, true), gettype($estadoReceptor)), __LINE__);
        }
        $this->EstadoReceptor = $estadoReceptor;
        return $this;
    }
    /**
     * Get FechaEmision value
     * @return string|null
     */
    public function getFechaEmision()
    {
        return $this->FechaEmision;
    }
    /**
     * Set FechaEmision value
     * @param string $fechaEmision
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEConsultarCFEsEmtidosOutV1_Item
     */
    public function setFechaEmision($fechaEmision = null)
    {
        // validation for constraint: string
        if (!is_null($fechaEmision) && !is_string($fechaEmision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaEmision, true), gettype($fechaEmision)), __LINE__);
        }
        $this->FechaEmision = $fechaEmision;
        return $this;
    }
    /**
     * Get ReceptorDenominacionSocial value
     * @return string|null
     */
    public function getReceptorDenominacionSocial()
    {
        return $this->ReceptorDenominacionSocial;
    }
    /**
     * Set ReceptorDenominacionSocial value
     * @param string $receptorDenominacionSocial
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEConsultarCFEsEmtidosOutV1_Item
     */
    public function setReceptorDenominacionSocial($receptorDenominacionSocial = null)
    {
        // validation for constraint: string
        if (!is_null($receptorDenominacionSocial) && !is_string($receptorDenominacionSocial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receptorDenominacionSocial, true), gettype($receptorDenominacionSocial)), __LINE__);
        }
        $this->ReceptorDenominacionSocial = $receptorDenominacionSocial;
        return $this;
    }
    /**
     * Get ReceptorDocumento value
     * @return string|null
     */
    public function getReceptorDocumento()
    {
        return $this->ReceptorDocumento;
    }
    /**
     * Set ReceptorDocumento value
     * @param string $receptorDocumento
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEConsultarCFEsEmtidosOutV1_Item
     */
    public function setReceptorDocumento($receptorDocumento = null)
    {
        // validation for constraint: string
        if (!is_null($receptorDocumento) && !is_string($receptorDocumento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receptorDocumento, true), gettype($receptorDocumento)), __LINE__);
        }
        $this->ReceptorDocumento = $receptorDocumento;
        return $this;
    }
    /**
     * Get ReceptorTipoDeDocumentoPaisId value
     * @return string|null
     */
    public function getReceptorTipoDeDocumentoPaisId()
    {
        return $this->ReceptorTipoDeDocumentoPaisId;
    }
    /**
     * Set ReceptorTipoDeDocumentoPaisId value
     * @param string $receptorTipoDeDocumentoPaisId
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEConsultarCFEsEmtidosOutV1_Item
     */
    public function setReceptorTipoDeDocumentoPaisId($receptorTipoDeDocumentoPaisId = null)
    {
        // validation for constraint: string
        if (!is_null($receptorTipoDeDocumentoPaisId) && !is_string($receptorTipoDeDocumentoPaisId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receptorTipoDeDocumentoPaisId, true), gettype($receptorTipoDeDocumentoPaisId)), __LINE__);
        }
        $this->ReceptorTipoDeDocumentoPaisId = $receptorTipoDeDocumentoPaisId;
        return $this;
    }
    /**
     * Get ReceptorCiudad value
     * @return string|null
     */
    public function getReceptorCiudad()
    {
        return $this->ReceptorCiudad;
    }
    /**
     * Set ReceptorCiudad value
     * @param string $receptorCiudad
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEConsultarCFEsEmtidosOutV1_Item
     */
    public function setReceptorCiudad($receptorCiudad = null)
    {
        // validation for constraint: string
        if (!is_null($receptorCiudad) && !is_string($receptorCiudad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receptorCiudad, true), gettype($receptorCiudad)), __LINE__);
        }
        $this->ReceptorCiudad = $receptorCiudad;
        return $this;
    }
    /**
     * Get ReceptorLocalidad value
     * @return string|null
     */
    public function getReceptorLocalidad()
    {
        return $this->ReceptorLocalidad;
    }
    /**
     * Set ReceptorLocalidad value
     * @param string $receptorLocalidad
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEConsultarCFEsEmtidosOutV1_Item
     */
    public function setReceptorLocalidad($receptorLocalidad = null)
    {
        // validation for constraint: string
        if (!is_null($receptorLocalidad) && !is_string($receptorLocalidad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receptorLocalidad, true), gettype($receptorLocalidad)), __LINE__);
        }
        $this->ReceptorLocalidad = $receptorLocalidad;
        return $this;
    }
    /**
     * Get ReceptorDireccion value
     * @return string|null
     */
    public function getReceptorDireccion()
    {
        return $this->ReceptorDireccion;
    }
    /**
     * Set ReceptorDireccion value
     * @param string $receptorDireccion
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEConsultarCFEsEmtidosOutV1_Item
     */
    public function setReceptorDireccion($receptorDireccion = null)
    {
        // validation for constraint: string
        if (!is_null($receptorDireccion) && !is_string($receptorDireccion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receptorDireccion, true), gettype($receptorDireccion)), __LINE__);
        }
        $this->ReceptorDireccion = $receptorDireccion;
        return $this;
    }
    /**
     * Get Moneda value
     * @return string|null
     */
    public function getMoneda()
    {
        return $this->Moneda;
    }
    /**
     * Set Moneda value
     * @param string $moneda
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEConsultarCFEsEmtidosOutV1_Item
     */
    public function setMoneda($moneda = null)
    {
        // validation for constraint: string
        if (!is_null($moneda) && !is_string($moneda)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($moneda, true), gettype($moneda)), __LINE__);
        }
        $this->Moneda = $moneda;
        return $this;
    }
    /**
     * Get TipoCambio value
     * @return float|null
     */
    public function getTipoCambio()
    {
        return $this->TipoCambio;
    }
    /**
     * Set TipoCambio value
     * @param float $tipoCambio
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEConsultarCFEsEmtidosOutV1_Item
     */
    public function setTipoCambio($tipoCambio = null)
    {
        // validation for constraint: float
        if (!is_null($tipoCambio) && !(is_float($tipoCambio) || is_numeric($tipoCambio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tipoCambio, true), gettype($tipoCambio)), __LINE__);
        }
        $this->TipoCambio = $tipoCambio;
        return $this;
    }
    /**
     * Get Total value
     * @return float|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param float $total
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEConsultarCFEsEmtidosOutV1_Item
     */
    public function setTotal($total = null)
    {
        // validation for constraint: float
        if (!is_null($total) && !(is_float($total) || is_numeric($total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        $this->Total = $total;
        return $this;
    }
}
