<?php

namespace App\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for eFactura.WebServices.SDTCFEV4.ComplementoFiscal StructType
 * @subpackage Structs
 */
class EFactura_WebServices_SDTCFEV4_ComplementoFiscal extends AbstractStructBase
{
    /**
     * The RUCEmisor
     * @var string
     */
    public $RUCEmisor;
    /**
     * The TipoDocumentoMandante
     * @var string
     */
    public $TipoDocumentoMandante;
    /**
     * The DocumentoMandante
     * @var string
     */
    public $DocumentoMandante;
    /**
     * The NombreMandante
     * @var string
     */
    public $NombreMandante;
    /**
     * The Pais
     * @var string
     */
    public $Pais;
    /**
     * The Encriptar
     * @var bool
     */
    public $Encriptar;
    /**
     * Constructor method for eFactura.WebServices.SDTCFEV4.ComplementoFiscal
     * @uses EFactura_WebServices_SDTCFEV4_ComplementoFiscal::setRUCEmisor()
     * @uses EFactura_WebServices_SDTCFEV4_ComplementoFiscal::setTipoDocumentoMandante()
     * @uses EFactura_WebServices_SDTCFEV4_ComplementoFiscal::setDocumentoMandante()
     * @uses EFactura_WebServices_SDTCFEV4_ComplementoFiscal::setNombreMandante()
     * @uses EFactura_WebServices_SDTCFEV4_ComplementoFiscal::setPais()
     * @uses EFactura_WebServices_SDTCFEV4_ComplementoFiscal::setEncriptar()
     * @param string $rUCEmisor
     * @param string $tipoDocumentoMandante
     * @param string $documentoMandante
     * @param string $nombreMandante
     * @param string $pais
     * @param bool $encriptar
     */
    public function __construct($rUCEmisor = null, $tipoDocumentoMandante = null, $documentoMandante = null, $nombreMandante = null, $pais = null, $encriptar = null)
    {
        $this
            ->setRUCEmisor($rUCEmisor)
            ->setTipoDocumentoMandante($tipoDocumentoMandante)
            ->setDocumentoMandante($documentoMandante)
            ->setNombreMandante($nombreMandante)
            ->setPais($pais)
            ->setEncriptar($encriptar);
    }
    /**
     * Get RUCEmisor value
     * @return string|null
     */
    public function getRUCEmisor()
    {
        return $this->RUCEmisor;
    }
    /**
     * Set RUCEmisor value
     * @param string $rUCEmisor
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_ComplementoFiscal
     */
    public function setRUCEmisor($rUCEmisor = null)
    {
        // validation for constraint: string
        if (!is_null($rUCEmisor) && !is_string($rUCEmisor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rUCEmisor, true), gettype($rUCEmisor)), __LINE__);
        }
        $this->RUCEmisor = $rUCEmisor;
        return $this;
    }
    /**
     * Get TipoDocumentoMandante value
     * @return string|null
     */
    public function getTipoDocumentoMandante()
    {
        return $this->TipoDocumentoMandante;
    }
    /**
     * Set TipoDocumentoMandante value
     * @param string $tipoDocumentoMandante
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_ComplementoFiscal
     */
    public function setTipoDocumentoMandante($tipoDocumentoMandante = null)
    {
        // validation for constraint: string
        if (!is_null($tipoDocumentoMandante) && !is_string($tipoDocumentoMandante)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoDocumentoMandante, true), gettype($tipoDocumentoMandante)), __LINE__);
        }
        $this->TipoDocumentoMandante = $tipoDocumentoMandante;
        return $this;
    }
    /**
     * Get DocumentoMandante value
     * @return string|null
     */
    public function getDocumentoMandante()
    {
        return $this->DocumentoMandante;
    }
    /**
     * Set DocumentoMandante value
     * @param string $documentoMandante
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_ComplementoFiscal
     */
    public function setDocumentoMandante($documentoMandante = null)
    {
        // validation for constraint: string
        if (!is_null($documentoMandante) && !is_string($documentoMandante)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentoMandante, true), gettype($documentoMandante)), __LINE__);
        }
        $this->DocumentoMandante = $documentoMandante;
        return $this;
    }
    /**
     * Get NombreMandante value
     * @return string|null
     */
    public function getNombreMandante()
    {
        return $this->NombreMandante;
    }
    /**
     * Set NombreMandante value
     * @param string $nombreMandante
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_ComplementoFiscal
     */
    public function setNombreMandante($nombreMandante = null)
    {
        // validation for constraint: string
        if (!is_null($nombreMandante) && !is_string($nombreMandante)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nombreMandante, true), gettype($nombreMandante)), __LINE__);
        }
        $this->NombreMandante = $nombreMandante;
        return $this;
    }
    /**
     * Get Pais value
     * @return string|null
     */
    public function getPais()
    {
        return $this->Pais;
    }
    /**
     * Set Pais value
     * @param string $pais
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_ComplementoFiscal
     */
    public function setPais($pais = null)
    {
        // validation for constraint: string
        if (!is_null($pais) && !is_string($pais)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pais, true), gettype($pais)), __LINE__);
        }
        $this->Pais = $pais;
        return $this;
    }
    /**
     * Get Encriptar value
     * @return bool|null
     */
    public function getEncriptar()
    {
        return $this->Encriptar;
    }
    /**
     * Set Encriptar value
     * @param bool $encriptar
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_ComplementoFiscal
     */
    public function setEncriptar($encriptar = null)
    {
        // validation for constraint: boolean
        if (!is_null($encriptar) && !is_bool($encriptar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($encriptar, true), gettype($encriptar)), __LINE__);
        }
        $this->Encriptar = $encriptar;
        return $this;
    }
}
