<?php

namespace App\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for eFactura.WebServices.SDTCFEV2.ReferenciaItem StructType
 * @subpackage Structs
 */
class EFactura_WebServices_SDTCFEV2_ReferenciaItem extends AbstractStructBase
{
    /**
     * The NumeroDeLinea
     * @var string
     */
    public $NumeroDeLinea;
    /**
     * The CFETipo
     * @var string
     */
    public $CFETipo;
    /**
     * The CFESerie
     * @var string
     */
    public $CFESerie;
    /**
     * The CFENumero
     * @var int
     */
    public $CFENumero;
    /**
     * The Motivo
     * @var string
     */
    public $Motivo;
    /**
     * The Fecha
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Fecha;
    /**
     * Constructor method for eFactura.WebServices.SDTCFEV2.ReferenciaItem
     * @uses EFactura_WebServices_SDTCFEV2_ReferenciaItem::setNumeroDeLinea()
     * @uses EFactura_WebServices_SDTCFEV2_ReferenciaItem::setCFETipo()
     * @uses EFactura_WebServices_SDTCFEV2_ReferenciaItem::setCFESerie()
     * @uses EFactura_WebServices_SDTCFEV2_ReferenciaItem::setCFENumero()
     * @uses EFactura_WebServices_SDTCFEV2_ReferenciaItem::setMotivo()
     * @uses EFactura_WebServices_SDTCFEV2_ReferenciaItem::setFecha()
     * @param string $numeroDeLinea
     * @param string $cFETipo
     * @param string $cFESerie
     * @param int $cFENumero
     * @param string $motivo
     * @param string $fecha
     */
    public function __construct($numeroDeLinea = null, $cFETipo = null, $cFESerie = null, $cFENumero = null, $motivo = null, $fecha = null)
    {
        $this
            ->setNumeroDeLinea($numeroDeLinea)
            ->setCFETipo($cFETipo)
            ->setCFESerie($cFESerie)
            ->setCFENumero($cFENumero)
            ->setMotivo($motivo)
            ->setFecha($fecha);
    }
    /**
     * Get NumeroDeLinea value
     * @return string|null
     */
    public function getNumeroDeLinea()
    {
        return $this->NumeroDeLinea;
    }
    /**
     * Set NumeroDeLinea value
     * @param string $numeroDeLinea
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV2_ReferenciaItem
     */
    public function setNumeroDeLinea($numeroDeLinea = null)
    {
        // validation for constraint: string
        if (!is_null($numeroDeLinea) && !is_string($numeroDeLinea)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroDeLinea, true), gettype($numeroDeLinea)), __LINE__);
        }
        $this->NumeroDeLinea = $numeroDeLinea;
        return $this;
    }
    /**
     * Get CFETipo value
     * @return string|null
     */
    public function getCFETipo()
    {
        return $this->CFETipo;
    }
    /**
     * Set CFETipo value
     * @param string $cFETipo
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV2_ReferenciaItem
     */
    public function setCFETipo($cFETipo = null)
    {
        // validation for constraint: string
        if (!is_null($cFETipo) && !is_string($cFETipo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cFETipo, true), gettype($cFETipo)), __LINE__);
        }
        $this->CFETipo = $cFETipo;
        return $this;
    }
    /**
     * Get CFESerie value
     * @return string|null
     */
    public function getCFESerie()
    {
        return $this->CFESerie;
    }
    /**
     * Set CFESerie value
     * @param string $cFESerie
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV2_ReferenciaItem
     */
    public function setCFESerie($cFESerie = null)
    {
        // validation for constraint: string
        if (!is_null($cFESerie) && !is_string($cFESerie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cFESerie, true), gettype($cFESerie)), __LINE__);
        }
        $this->CFESerie = $cFESerie;
        return $this;
    }
    /**
     * Get CFENumero value
     * @return int|null
     */
    public function getCFENumero()
    {
        return $this->CFENumero;
    }
    /**
     * Set CFENumero value
     * @param int $cFENumero
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV2_ReferenciaItem
     */
    public function setCFENumero($cFENumero = null)
    {
        // validation for constraint: int
        if (!is_null($cFENumero) && !(is_int($cFENumero) || ctype_digit($cFENumero))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cFENumero, true), gettype($cFENumero)), __LINE__);
        }
        $this->CFENumero = $cFENumero;
        return $this;
    }
    /**
     * Get Motivo value
     * @return string|null
     */
    public function getMotivo()
    {
        return $this->Motivo;
    }
    /**
     * Set Motivo value
     * @param string $motivo
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV2_ReferenciaItem
     */
    public function setMotivo($motivo = null)
    {
        // validation for constraint: string
        if (!is_null($motivo) && !is_string($motivo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($motivo, true), gettype($motivo)), __LINE__);
        }
        $this->Motivo = $motivo;
        return $this;
    }
    /**
     * Get Fecha value
     * @return string|null
     */
    public function getFecha()
    {
        return $this->Fecha;
    }
    /**
     * Set Fecha value
     * @param string $fecha
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV2_ReferenciaItem
     */
    public function setFecha($fecha = null)
    {
        // validation for constraint: string
        if (!is_null($fecha) && !is_string($fecha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fecha, true), gettype($fecha)), __LINE__);
        }
        $this->Fecha = $fecha;
        return $this;
    }
}
