<?php

namespace App\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for eFactura.Definiciones.SDTCFEInterno.Cobranza StructType
 * @subpackage Structs
 */
class EFactura_Definiciones_SDTCFEInterno_Cobranza extends AbstractStructBase
{
    /**
     * The RedDeCobranza
     * @var string
     */
    public $RedDeCobranza;
    /**
     * The CodigoEmpresa
     * @var string
     */
    public $CodigoEmpresa;
    /**
     * The NumeroCliente
     * @var int
     */
    public $NumeroCliente;
    /**
     * The Moneda
     * @var string
     */
    public $Moneda;
    /**
     * The Cuota
     * @var string
     */
    public $Cuota;
    /**
     * The Mora
     * @var int
     */
    public $Mora;
    /**
     * The MoraPorcentaje
     * @var string
     */
    public $MoraPorcentaje;
    /**
     * The Cuenta
     * @var int
     */
    public $Cuenta;
    /**
     * The AplicaDescuentoIVA
     * @var string
     */
    public $AplicaDescuentoIVA;
    /**
     * The ImporteImponible
     * @var float
     */
    public $ImporteImponible;
    /**
     * The ImporteMinimo
     * @var float
     */
    public $ImporteMinimo;
    /**
     * The ImporteTotal
     * @var float
     */
    public $ImporteTotal;
    /**
     * Constructor method for eFactura.Definiciones.SDTCFEInterno.Cobranza
     * @uses EFactura_Definiciones_SDTCFEInterno_Cobranza::setRedDeCobranza()
     * @uses EFactura_Definiciones_SDTCFEInterno_Cobranza::setCodigoEmpresa()
     * @uses EFactura_Definiciones_SDTCFEInterno_Cobranza::setNumeroCliente()
     * @uses EFactura_Definiciones_SDTCFEInterno_Cobranza::setMoneda()
     * @uses EFactura_Definiciones_SDTCFEInterno_Cobranza::setCuota()
     * @uses EFactura_Definiciones_SDTCFEInterno_Cobranza::setMora()
     * @uses EFactura_Definiciones_SDTCFEInterno_Cobranza::setMoraPorcentaje()
     * @uses EFactura_Definiciones_SDTCFEInterno_Cobranza::setCuenta()
     * @uses EFactura_Definiciones_SDTCFEInterno_Cobranza::setAplicaDescuentoIVA()
     * @uses EFactura_Definiciones_SDTCFEInterno_Cobranza::setImporteImponible()
     * @uses EFactura_Definiciones_SDTCFEInterno_Cobranza::setImporteMinimo()
     * @uses EFactura_Definiciones_SDTCFEInterno_Cobranza::setImporteTotal()
     * @param string $redDeCobranza
     * @param string $codigoEmpresa
     * @param int $numeroCliente
     * @param string $moneda
     * @param string $cuota
     * @param int $mora
     * @param string $moraPorcentaje
     * @param int $cuenta
     * @param string $aplicaDescuentoIVA
     * @param float $importeImponible
     * @param float $importeMinimo
     * @param float $importeTotal
     */
    public function __construct($redDeCobranza = null, $codigoEmpresa = null, $numeroCliente = null, $moneda = null, $cuota = null, $mora = null, $moraPorcentaje = null, $cuenta = null, $aplicaDescuentoIVA = null, $importeImponible = null, $importeMinimo = null, $importeTotal = null)
    {
        $this
            ->setRedDeCobranza($redDeCobranza)
            ->setCodigoEmpresa($codigoEmpresa)
            ->setNumeroCliente($numeroCliente)
            ->setMoneda($moneda)
            ->setCuota($cuota)
            ->setMora($mora)
            ->setMoraPorcentaje($moraPorcentaje)
            ->setCuenta($cuenta)
            ->setAplicaDescuentoIVA($aplicaDescuentoIVA)
            ->setImporteImponible($importeImponible)
            ->setImporteMinimo($importeMinimo)
            ->setImporteTotal($importeTotal);
    }
    /**
     * Get RedDeCobranza value
     * @return string|null
     */
    public function getRedDeCobranza()
    {
        return $this->RedDeCobranza;
    }
    /**
     * Set RedDeCobranza value
     * @param string $redDeCobranza
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_Cobranza
     */
    public function setRedDeCobranza($redDeCobranza = null)
    {
        // validation for constraint: string
        if (!is_null($redDeCobranza) && !is_string($redDeCobranza)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($redDeCobranza, true), gettype($redDeCobranza)), __LINE__);
        }
        $this->RedDeCobranza = $redDeCobranza;
        return $this;
    }
    /**
     * Get CodigoEmpresa value
     * @return string|null
     */
    public function getCodigoEmpresa()
    {
        return $this->CodigoEmpresa;
    }
    /**
     * Set CodigoEmpresa value
     * @param string $codigoEmpresa
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_Cobranza
     */
    public function setCodigoEmpresa($codigoEmpresa = null)
    {
        // validation for constraint: string
        if (!is_null($codigoEmpresa) && !is_string($codigoEmpresa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoEmpresa, true), gettype($codigoEmpresa)), __LINE__);
        }
        $this->CodigoEmpresa = $codigoEmpresa;
        return $this;
    }
    /**
     * Get NumeroCliente value
     * @return int|null
     */
    public function getNumeroCliente()
    {
        return $this->NumeroCliente;
    }
    /**
     * Set NumeroCliente value
     * @param int $numeroCliente
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_Cobranza
     */
    public function setNumeroCliente($numeroCliente = null)
    {
        // validation for constraint: int
        if (!is_null($numeroCliente) && !(is_int($numeroCliente) || ctype_digit($numeroCliente))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numeroCliente, true), gettype($numeroCliente)), __LINE__);
        }
        $this->NumeroCliente = $numeroCliente;
        return $this;
    }
    /**
     * Get Moneda value
     * @return string|null
     */
    public function getMoneda()
    {
        return $this->Moneda;
    }
    /**
     * Set Moneda value
     * @param string $moneda
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_Cobranza
     */
    public function setMoneda($moneda = null)
    {
        // validation for constraint: string
        if (!is_null($moneda) && !is_string($moneda)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($moneda, true), gettype($moneda)), __LINE__);
        }
        $this->Moneda = $moneda;
        return $this;
    }
    /**
     * Get Cuota value
     * @return string|null
     */
    public function getCuota()
    {
        return $this->Cuota;
    }
    /**
     * Set Cuota value
     * @param string $cuota
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_Cobranza
     */
    public function setCuota($cuota = null)
    {
        // validation for constraint: string
        if (!is_null($cuota) && !is_string($cuota)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cuota, true), gettype($cuota)), __LINE__);
        }
        $this->Cuota = $cuota;
        return $this;
    }
    /**
     * Get Mora value
     * @return int|null
     */
    public function getMora()
    {
        return $this->Mora;
    }
    /**
     * Set Mora value
     * @param int $mora
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_Cobranza
     */
    public function setMora($mora = null)
    {
        // validation for constraint: int
        if (!is_null($mora) && !(is_int($mora) || ctype_digit($mora))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mora, true), gettype($mora)), __LINE__);
        }
        $this->Mora = $mora;
        return $this;
    }
    /**
     * Get MoraPorcentaje value
     * @return string|null
     */
    public function getMoraPorcentaje()
    {
        return $this->MoraPorcentaje;
    }
    /**
     * Set MoraPorcentaje value
     * @param string $moraPorcentaje
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_Cobranza
     */
    public function setMoraPorcentaje($moraPorcentaje = null)
    {
        // validation for constraint: string
        if (!is_null($moraPorcentaje) && !is_string($moraPorcentaje)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($moraPorcentaje, true), gettype($moraPorcentaje)), __LINE__);
        }
        $this->MoraPorcentaje = $moraPorcentaje;
        return $this;
    }
    /**
     * Get Cuenta value
     * @return int|null
     */
    public function getCuenta()
    {
        return $this->Cuenta;
    }
    /**
     * Set Cuenta value
     * @param int $cuenta
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_Cobranza
     */
    public function setCuenta($cuenta = null)
    {
        // validation for constraint: int
        if (!is_null($cuenta) && !(is_int($cuenta) || ctype_digit($cuenta))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cuenta, true), gettype($cuenta)), __LINE__);
        }
        $this->Cuenta = $cuenta;
        return $this;
    }
    /**
     * Get AplicaDescuentoIVA value
     * @return string|null
     */
    public function getAplicaDescuentoIVA()
    {
        return $this->AplicaDescuentoIVA;
    }
    /**
     * Set AplicaDescuentoIVA value
     * @param string $aplicaDescuentoIVA
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_Cobranza
     */
    public function setAplicaDescuentoIVA($aplicaDescuentoIVA = null)
    {
        // validation for constraint: string
        if (!is_null($aplicaDescuentoIVA) && !is_string($aplicaDescuentoIVA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aplicaDescuentoIVA, true), gettype($aplicaDescuentoIVA)), __LINE__);
        }
        $this->AplicaDescuentoIVA = $aplicaDescuentoIVA;
        return $this;
    }
    /**
     * Get ImporteImponible value
     * @return float|null
     */
    public function getImporteImponible()
    {
        return $this->ImporteImponible;
    }
    /**
     * Set ImporteImponible value
     * @param float $importeImponible
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_Cobranza
     */
    public function setImporteImponible($importeImponible = null)
    {
        // validation for constraint: float
        if (!is_null($importeImponible) && !(is_float($importeImponible) || is_numeric($importeImponible))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($importeImponible, true), gettype($importeImponible)), __LINE__);
        }
        $this->ImporteImponible = $importeImponible;
        return $this;
    }
    /**
     * Get ImporteMinimo value
     * @return float|null
     */
    public function getImporteMinimo()
    {
        return $this->ImporteMinimo;
    }
    /**
     * Set ImporteMinimo value
     * @param float $importeMinimo
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_Cobranza
     */
    public function setImporteMinimo($importeMinimo = null)
    {
        // validation for constraint: float
        if (!is_null($importeMinimo) && !(is_float($importeMinimo) || is_numeric($importeMinimo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($importeMinimo, true), gettype($importeMinimo)), __LINE__);
        }
        $this->ImporteMinimo = $importeMinimo;
        return $this;
    }
    /**
     * Get ImporteTotal value
     * @return float|null
     */
    public function getImporteTotal()
    {
        return $this->ImporteTotal;
    }
    /**
     * Set ImporteTotal value
     * @param float $importeTotal
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_Cobranza
     */
    public function setImporteTotal($importeTotal = null)
    {
        // validation for constraint: float
        if (!is_null($importeTotal) && !(is_float($importeTotal) || is_numeric($importeTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($importeTotal, true), gettype($importeTotal)), __LINE__);
        }
        $this->ImporteTotal = $importeTotal;
        return $this;
    }
}
