<?php

namespace App\Soap;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'SDTWSCFEEnviarCFEInV5' => '\\App\\Soap\\StructType\\SDTWSCFEEnviarCFEInV5',
            'SDTWSCFEConexionV1' => '\\App\\Soap\\StructType\\SDTWSCFEConexionV1',
            'SDTCFEV4' => '\\App\\Soap\\StructType\\SDTCFEV4',
            'Detalle' => '\\App\\Soap\\StructType\\Detalle',
            'DescuentosRecargosGlobal' => '\\App\\Soap\\StructType\\DescuentosRecargosGlobal',
            'Subtotales' => '\\App\\Soap\\StructType\\Subtotales',
            'TotalesRetencionesPercepciones' => '\\App\\Soap\\StructType\\TotalesRetencionesPercepciones',
            'MediosPago' => '\\App\\Soap\\StructType\\MediosPago',
            'Referencia' => '\\App\\Soap\\StructType\\Referencia',
            'Adenda' => '\\App\\Soap\\StructType\\Adenda',
            'Notificar' => '\\App\\Soap\\StructType\\Notificar',
            'ComprobantesDePago' => '\\App\\Soap\\StructType\\ComprobantesDePago',
            'eFactura.WebServices.SDTCFEV4.Emisor' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTCFEV4_Emisor',
            'eFactura.WebServices.SDTCFEV4.ComplementoFiscal' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTCFEV4_ComplementoFiscal',
            'eFactura.WebServices.SDTCFEV4.PropietarioMercaderiaTransportada' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTCFEV4_PropietarioMercaderiaTransportada',
            'eFactura.WebServices.SDTCFEV4.Documento' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTCFEV4_Documento',
            'eFactura.WebServices.SDTCFEV4.Receptor' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTCFEV4_Receptor',
            'eFactura.WebServices.SDTCFEV4.Totales' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTCFEV4_Totales',
            'ArrayOfeFactura.WebServices.SDTCFEV4.DetalleItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_WebServices_SDTCFEV4_DetalleItem',
            'eFactura.WebServices.SDTCFEV4.DetalleItem' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTCFEV4_DetalleItem',
            'DescuentoRecargo' => '\\App\\Soap\\StructType\\DescuentoRecargo',
            'RetencionPercepcion' => '\\App\\Soap\\StructType\\RetencionPercepcion',
            'CodigosProductoServicio' => '\\App\\Soap\\StructType\\CodigosProductoServicio',
            'DatosAdicionales' => '\\App\\Soap\\StructType\\DatosAdicionales',
            'ArrayOfeFactura.WebServices.SDTCFEV4.DescuentosRecargosGlobalItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_WebServices_SDTCFEV4_DescuentosRecargosGlobalItem',
            'eFactura.WebServices.SDTCFEV4.DescuentosRecargosGlobalItem' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTCFEV4_DescuentosRecargosGlobalItem',
            'ArrayOfeFactura.WebServices.SDTCFEV4.SubtotalesItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_WebServices_SDTCFEV4_SubtotalesItem',
            'eFactura.WebServices.SDTCFEV4.SubtotalesItem' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTCFEV4_SubtotalesItem',
            'ArrayOfeFactura.WebServices.SDTCFEV4.TotalesRetencionesPercepcionesItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_WebServices_SDTCFEV4_TotalesRetencionesPercepcionesItem',
            'eFactura.WebServices.SDTCFEV4.TotalesRetencionesPercepcionesItem' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTCFEV4_TotalesRetencionesPercepcionesItem',
            'ArrayOfeFactura.WebServices.SDTCFEV4.MediosPagoItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_WebServices_SDTCFEV4_MediosPagoItem',
            'eFactura.WebServices.SDTCFEV4.MediosPagoItem' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTCFEV4_MediosPagoItem',
            'ArrayOfeFactura.WebServices.SDTCFEV4.ReferenciaItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_WebServices_SDTCFEV4_ReferenciaItem',
            'eFactura.WebServices.SDTCFEV4.ReferenciaItem' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTCFEV4_ReferenciaItem',
            'ArrayOfeFactura.WebServices.SDTCFEV4.AdendaItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_WebServices_SDTCFEV4_AdendaItem',
            'eFactura.WebServices.SDTCFEV4.AdendaItem' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTCFEV4_AdendaItem',
            'eFactura.WebServices.SDTCFEV4.Cobranza' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTCFEV4_Cobranza',
            'ArrayOfeFactura.WebServices.SDTCFEV4.NotificarItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_WebServices_SDTCFEV4_NotificarItem',
            'eFactura.WebServices.SDTCFEV4.NotificarItem' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTCFEV4_NotificarItem',
            'eFactura.WebServices.SDTCFEV4.PlanDePagos' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTCFEV4_PlanDePagos',
            'ArrayOfeFactura.WebServices.SDTCFEV4.ComprobantesDePagoItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_WebServices_SDTCFEV4_ComprobantesDePagoItem',
            'eFactura.WebServices.SDTCFEV4.ComprobantesDePagoItem' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTCFEV4_ComprobantesDePagoItem',
            'ArrayOfeFactura.WebServices.SDTCFEV4.DetalleItem.DescuentoRecargoItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_WebServices_SDTCFEV4_DetalleItem_DescuentoRecargoItem',
            'eFactura.WebServices.SDTCFEV4.DetalleItem.DescuentoRecargoItem' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTCFEV4_DetalleItem_DescuentoRecargoItem',
            'ArrayOfeFactura.WebServices.SDTCFEV4.DetalleItem.RetencionPercepcionItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_WebServices_SDTCFEV4_DetalleItem_RetencionPercepcionItem',
            'eFactura.WebServices.SDTCFEV4.DetalleItem.RetencionPercepcionItem' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTCFEV4_DetalleItem_RetencionPercepcionItem',
            'ArrayOfeFactura.WebServices.SDTCFEV4.DetalleItem.CodigosProductoServicioItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_WebServices_SDTCFEV4_DetalleItem_CodigosProductoServicioItem',
            'eFactura.WebServices.SDTCFEV4.DetalleItem.CodigosProductoServicioItem' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTCFEV4_DetalleItem_CodigosProductoServicioItem',
            'ArrayOfeFactura.WebServices.SDTCFEV4.DetalleItem.DatosAdicionalesItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_WebServices_SDTCFEV4_DetalleItem_DatosAdicionalesItem',
            'eFactura.WebServices.SDTCFEV4.DetalleItem.DatosAdicionalesItem' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTCFEV4_DetalleItem_DatosAdicionalesItem',
            'SDTWSCFEEnviarCFEOutV4' => '\\App\\Soap\\StructType\\SDTWSCFEEnviarCFEOutV4',
            'Mensajes' => '\\App\\Soap\\StructType\\Mensajes',
            'eFactura.WebServices.SDTWSCFEEnviarCFEOutV4.Error' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTWSCFEEnviarCFEOutV4_Error',
            'eFactura.WebServices.SDTWSCFEEnviarCFEOutV4.Respuesta' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTWSCFEEnviarCFEOutV4_Respuesta',
            'ArrayOfeFactura.WebServices.SDTWSCFEEnviarCFEOutV4.MensajesItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_WebServices_SDTWSCFEEnviarCFEOutV4_MensajesItem',
            'eFactura.WebServices.SDTWSCFEEnviarCFEOutV4.MensajesItem' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTWSCFEEnviarCFEOutV4_MensajesItem',
            'SDTMotivosDeRechazoCFE' => '\\App\\Soap\\StructType\\SDTMotivosDeRechazoCFE',
            'eFactura.BackOffice.SDTMotivosDeRechazoCFE.Item' => '\\App\\Soap\\StructType\\EFactura_BackOffice_SDTMotivosDeRechazoCFE_Item',
            'SDTWSCFEV1CAEData' => '\\App\\Soap\\StructType\\SDTWSCFEV1CAEData',
            'SDTWSCFECobranzaDataV1' => '\\App\\Soap\\StructType\\SDTWSCFECobranzaDataV1',
            'SDTWSCFEEnviarCFEsInV5' => '\\App\\Soap\\StructType\\SDTWSCFEEnviarCFEsInV5',
            'ArrayOfSDTCFEV4' => '\\App\\Soap\\ArrayType\\ArrayOfSDTCFEV4',
            'SDTWSCFEVEnviarCFEsOutV4' => '\\App\\Soap\\StructType\\SDTWSCFEVEnviarCFEsOutV4',
            'Respuesta' => '\\App\\Soap\\StructType\\Respuesta',
            'eFactura.WebServices.SDTWSCFEVEnviarCFEsOutV4.Error' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTWSCFEVEnviarCFEsOutV4_Error',
            'ArrayOfeFactura.WebServices.SDTWSCFEVEnviarCFEsOutV4.RespuestaItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_WebServices_SDTWSCFEVEnviarCFEsOutV4_RespuestaItem',
            'eFactura.WebServices.SDTWSCFEVEnviarCFEsOutV4.RespuestaItem' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTWSCFEVEnviarCFEsOutV4_RespuestaItem',
            'ArrayOfeFactura.WebServices.SDTWSCFEVEnviarCFEsOutV4.MensajesItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_WebServices_SDTWSCFEVEnviarCFEsOutV4_MensajesItem',
            'eFactura.WebServices.SDTWSCFEVEnviarCFEsOutV4.MensajesItem' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTWSCFEVEnviarCFEsOutV4_MensajesItem',
            'eFactura.WebServices.SDTWSCFEVEnviarCFEsOutV4.RespuestaItem.Error' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTWSCFEVEnviarCFEsOutV4_RespuestaItem_Error',
            'eFactura.WebServices.SDTWSCFEVEnviarCFEsOutV4.RespuestaItem.Datos' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTWSCFEVEnviarCFEsOutV4_RespuestaItem_Datos',
            'SDTWSCFEResultadoEnvioCFEInV3' => '\\App\\Soap\\StructType\\SDTWSCFEResultadoEnvioCFEInV3',
            'SDTWSCFEResultadoEnvioCFEOutV4' => '\\App\\Soap\\StructType\\SDTWSCFEResultadoEnvioCFEOutV4',
            'eFactura.WebServices.SDTWSCFEResultadoEnvioCFEOutV4.Error' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTWSCFEResultadoEnvioCFEOutV4_Error',
            'eFactura.WebServices.SDTWSCFEResultadoEnvioCFEOutV4.Respuesta' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTWSCFEResultadoEnvioCFEOutV4_Respuesta',
            'ArrayOfeFactura.WebServices.SDTWSCFEResultadoEnvioCFEOutV4.MensajesItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_WebServices_SDTWSCFEResultadoEnvioCFEOutV4_MensajesItem',
            'eFactura.WebServices.SDTWSCFEResultadoEnvioCFEOutV4.MensajesItem' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTWSCFEResultadoEnvioCFEOutV4_MensajesItem',
            'SDTWSCFEResultadoEnvioCFEsInV3' => '\\App\\Soap\\StructType\\SDTWSCFEResultadoEnvioCFEsInV3',
            'CFEs' => '\\App\\Soap\\StructType\\CFEs',
            'ArrayOfeFactura.WebServices.SDTWSCFEResultadoEnvioCFEsInV3.CFEsItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_WebServices_SDTWSCFEResultadoEnvioCFEsInV3_CFEsItem',
            'eFactura.WebServices.SDTWSCFEResultadoEnvioCFEsInV3.CFEsItem' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTWSCFEResultadoEnvioCFEsInV3_CFEsItem',
            'SDTWSCFEResultadoEnvioCFEsOutV4' => '\\App\\Soap\\StructType\\SDTWSCFEResultadoEnvioCFEsOutV4',
            'eFactura.WebServices.SDTWSCFEResultadoEnvioCFEsOutV4.Error' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTWSCFEResultadoEnvioCFEsOutV4_Error',
            'ArrayOfeFactura.WebServices.SDTWSCFEResultadoEnvioCFEsOutV4.RespuestaItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_WebServices_SDTWSCFEResultadoEnvioCFEsOutV4_RespuestaItem',
            'eFactura.WebServices.SDTWSCFEResultadoEnvioCFEsOutV4.RespuestaItem' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTWSCFEResultadoEnvioCFEsOutV4_RespuestaItem',
            'ArrayOfeFactura.WebServices.SDTWSCFEResultadoEnvioCFEsOutV4.MensajesItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_WebServices_SDTWSCFEResultadoEnvioCFEsOutV4_MensajesItem',
            'eFactura.WebServices.SDTWSCFEResultadoEnvioCFEsOutV4.MensajesItem' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTWSCFEResultadoEnvioCFEsOutV4_MensajesItem',
            'eFactura.WebServices.SDTWSCFEResultadoEnvioCFEsOutV4.RespuestaItem.Datos' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTWSCFEResultadoEnvioCFEsOutV4_RespuestaItem_Datos',
            'SDTWSCFEConsultarCFEsEmitidosInV2' => '\\App\\Soap\\StructType\\SDTWSCFEConsultarCFEsEmitidosInV2',
            'SDTWSCFEConsultarCFEsEmtidosOutV2' => '\\App\\Soap\\StructType\\SDTWSCFEConsultarCFEsEmtidosOutV2',
            'eFactura.WebServices.SDTWSCFEConsultarCFEsEmtidosOutV2.Error' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTWSCFEConsultarCFEsEmtidosOutV2_Error',
            'SDTWSCFEConsultarCFEsEmtidosOutV1' => '\\App\\Soap\\StructType\\SDTWSCFEConsultarCFEsEmtidosOutV1',
            'eFactura.WebServices.SDTWSCFEConsultarCFEsEmtidosOutV1.Item' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTWSCFEConsultarCFEsEmtidosOutV1_Item',
            'SDTWSCFEConsultarCFEsRecibidosInV1' => '\\App\\Soap\\StructType\\SDTWSCFEConsultarCFEsRecibidosInV1',
            'SDTWSCFEConsultarCFEsRecibidosOutV2' => '\\App\\Soap\\StructType\\SDTWSCFEConsultarCFEsRecibidosOutV2',
            'eFactura.WebServices.SDTWSCFEConsultarCFEsRecibidosOutV2.Error' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTWSCFEConsultarCFEsRecibidosOutV2_Error',
            'SDTWSCFEConsultarCFEsRecibidosOutV1' => '\\App\\Soap\\StructType\\SDTWSCFEConsultarCFEsRecibidosOutV1',
            'eFactura.WebServices.SDTWSCFEConsultarCFEsRecibidosOutV1.Item' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTWSCFEConsultarCFEsRecibidosOutV1_Item',
            'SDTWSCFEConsultarCFERecibidoDetalleInV1' => '\\App\\Soap\\StructType\\SDTWSCFEConsultarCFERecibidoDetalleInV1',
            'SDTWSCFEConsultarCFERecibidoDetalleOutV2' => '\\App\\Soap\\StructType\\SDTWSCFEConsultarCFERecibidoDetalleOutV2',
            'eFactura.WebServices.SDTWSCFEConsultarCFERecibidoDetalleOutV2.Error' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTWSCFEConsultarCFERecibidoDetalleOutV2_Error',
            'eFactura.WebServices.SDTWSCFEConsultarCFERecibidoDetalleOutV2.Respuesta' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTWSCFEConsultarCFERecibidoDetalleOutV2_Respuesta',
            'SDTCFEV2' => '\\App\\Soap\\StructType\\SDTCFEV2',
            'eFactura.WebServices.SDTCFEV2.Emisor' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTCFEV2_Emisor',
            'eFactura.WebServices.SDTCFEV2.ComplementoFiscal' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTCFEV2_ComplementoFiscal',
            'eFactura.WebServices.SDTCFEV2.PropietarioMercaderiaTransportada' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTCFEV2_PropietarioMercaderiaTransportada',
            'eFactura.WebServices.SDTCFEV2.Documento' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTCFEV2_Documento',
            'eFactura.WebServices.SDTCFEV2.Receptor' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTCFEV2_Receptor',
            'eFactura.WebServices.SDTCFEV2.Totales' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTCFEV2_Totales',
            'ArrayOfeFactura.WebServices.SDTCFEV2.DetalleItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_WebServices_SDTCFEV2_DetalleItem',
            'eFactura.WebServices.SDTCFEV2.DetalleItem' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTCFEV2_DetalleItem',
            'ArrayOfeFactura.WebServices.SDTCFEV2.DescuentosRecargosGlobalItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_WebServices_SDTCFEV2_DescuentosRecargosGlobalItem',
            'eFactura.WebServices.SDTCFEV2.DescuentosRecargosGlobalItem' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTCFEV2_DescuentosRecargosGlobalItem',
            'ArrayOfeFactura.WebServices.SDTCFEV2.SubtotalesItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_WebServices_SDTCFEV2_SubtotalesItem',
            'eFactura.WebServices.SDTCFEV2.SubtotalesItem' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTCFEV2_SubtotalesItem',
            'ArrayOfeFactura.WebServices.SDTCFEV2.TotalesRetencionesPercepcionesItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_WebServices_SDTCFEV2_TotalesRetencionesPercepcionesItem',
            'eFactura.WebServices.SDTCFEV2.TotalesRetencionesPercepcionesItem' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTCFEV2_TotalesRetencionesPercepcionesItem',
            'ArrayOfeFactura.WebServices.SDTCFEV2.MediosPagoItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_WebServices_SDTCFEV2_MediosPagoItem',
            'eFactura.WebServices.SDTCFEV2.MediosPagoItem' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTCFEV2_MediosPagoItem',
            'ArrayOfeFactura.WebServices.SDTCFEV2.ReferenciaItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_WebServices_SDTCFEV2_ReferenciaItem',
            'eFactura.WebServices.SDTCFEV2.ReferenciaItem' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTCFEV2_ReferenciaItem',
            'ArrayOfeFactura.WebServices.SDTCFEV2.AdendaItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_WebServices_SDTCFEV2_AdendaItem',
            'eFactura.WebServices.SDTCFEV2.AdendaItem' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTCFEV2_AdendaItem',
            'eFactura.WebServices.SDTCFEV2.Cobranza' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTCFEV2_Cobranza',
            'ArrayOfeFactura.WebServices.SDTCFEV2.NotificarItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_WebServices_SDTCFEV2_NotificarItem',
            'eFactura.WebServices.SDTCFEV2.NotificarItem' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTCFEV2_NotificarItem',
            'ArrayOfeFactura.WebServices.SDTCFEV2.DetalleItem.DescuentoRecargoItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_WebServices_SDTCFEV2_DetalleItem_DescuentoRecargoItem',
            'eFactura.WebServices.SDTCFEV2.DetalleItem.DescuentoRecargoItem' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTCFEV2_DetalleItem_DescuentoRecargoItem',
            'ArrayOfeFactura.WebServices.SDTCFEV2.DetalleItem.RetencionPercepcionItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_WebServices_SDTCFEV2_DetalleItem_RetencionPercepcionItem',
            'eFactura.WebServices.SDTCFEV2.DetalleItem.RetencionPercepcionItem' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTCFEV2_DetalleItem_RetencionPercepcionItem',
            'ArrayOfeFactura.WebServices.SDTCFEV2.DetalleItem.CodigosProductoServicioItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_WebServices_SDTCFEV2_DetalleItem_CodigosProductoServicioItem',
            'eFactura.WebServices.SDTCFEV2.DetalleItem.CodigosProductoServicioItem' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTCFEV2_DetalleItem_CodigosProductoServicioItem',
            'SDTWSCFEResponderCFEsInV2' => '\\App\\Soap\\StructType\\SDTWSCFEResponderCFEsInV2',
            'ArrayOfeFactura.WebServices.SDTWSCFEResponderCFEsInV2.CFEsItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_WebServices_SDTWSCFEResponderCFEsInV2_CFEsItem',
            'eFactura.WebServices.SDTWSCFEResponderCFEsInV2.CFEsItem' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTWSCFEResponderCFEsInV2_CFEsItem',
            'SDTWSCFEResponderCFEsOutV2' => '\\App\\Soap\\StructType\\SDTWSCFEResponderCFEsOutV2',
            'eFactura.WebServices.SDTWSCFEResponderCFEsOutV2.Error' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTWSCFEResponderCFEsOutV2_Error',
            'ArrayOfeFactura.WebServices.SDTWSCFEResponderCFEsOutV2.Item' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_WebServices_SDTWSCFEResponderCFEsOutV2_Item',
            'eFactura.WebServices.SDTWSCFEResponderCFEsOutV2.Item' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTWSCFEResponderCFEsOutV2_Item',
            'eFactura.WebServices.SDTWSCFEResponderCFEsOutV2.Item.Error' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTWSCFEResponderCFEsOutV2_Item_Error',
            'eFactura.WebServices.SDTWSCFEResponderCFEsOutV2.Item.Datos' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTWSCFEResponderCFEsOutV2_Item_Datos',
            'SDTWSCFEConsultarCFEEstadosHistoricoInV1' => '\\App\\Soap\\StructType\\SDTWSCFEConsultarCFEEstadosHistoricoInV1',
            'SDTWSCFEConsultarCFEEstadosHistoricoOutV2' => '\\App\\Soap\\StructType\\SDTWSCFEConsultarCFEEstadosHistoricoOutV2',
            'eFactura.WebServices.SDTWSCFEConsultarCFEEstadosHistoricoOutV2.Error' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTWSCFEConsultarCFEEstadosHistoricoOutV2_Error',
            'SDTWSCFEConsultarCFEEstadosHistoricoOutV1' => '\\App\\Soap\\StructType\\SDTWSCFEConsultarCFEEstadosHistoricoOutV1',
            'eFactura.WebServices.SDTWSCFEConsultarCFEEstadosHistoricoOutV1.CFE' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTWSCFEConsultarCFEEstadosHistoricoOutV1_CFE',
            'SDTWSEnviarNotificacionesInV1' => '\\App\\Soap\\StructType\\SDTWSEnviarNotificacionesInV1',
            'ArrayOfeFactura.WebServices.SDTWSEnviarNotificacionesInV1.Item' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_WebServices_SDTWSEnviarNotificacionesInV1_Item',
            'eFactura.WebServices.SDTWSEnviarNotificacionesInV1.Item' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTWSEnviarNotificacionesInV1_Item',
            'SDTWSEnviarNotificacionesOutV1' => '\\App\\Soap\\StructType\\SDTWSEnviarNotificacionesOutV1',
            'eFactura.WebServices.SDTWSEnviarNotificacionesOutV1.Error' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTWSEnviarNotificacionesOutV1_Error',
            'SDTWSPrevisualizarFormularioInV1' => '\\App\\Soap\\StructType\\SDTWSPrevisualizarFormularioInV1',
            'SDTCFEInterno' => '\\App\\Soap\\StructType\\SDTCFEInterno',
            'eFactura.Definiciones.SDTCFEInterno.Emisor' => '\\App\\Soap\\StructType\\EFactura_Definiciones_SDTCFEInterno_Emisor',
            'eFactura.Definiciones.SDTCFEInterno.ComplementoFiscal' => '\\App\\Soap\\StructType\\EFactura_Definiciones_SDTCFEInterno_ComplementoFiscal',
            'eFactura.Definiciones.SDTCFEInterno.PropietarioMercaderiaTransportada' => '\\App\\Soap\\StructType\\EFactura_Definiciones_SDTCFEInterno_PropietarioMercaderiaTransportada',
            'eFactura.Definiciones.SDTCFEInterno.Documento' => '\\App\\Soap\\StructType\\EFactura_Definiciones_SDTCFEInterno_Documento',
            'eFactura.Definiciones.SDTCFEInterno.Receptor' => '\\App\\Soap\\StructType\\EFactura_Definiciones_SDTCFEInterno_Receptor',
            'eFactura.Definiciones.SDTCFEInterno.Totales' => '\\App\\Soap\\StructType\\EFactura_Definiciones_SDTCFEInterno_Totales',
            'ArrayOfeFactura.Definiciones.SDTCFEInterno.DetalleItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_Definiciones_SDTCFEInterno_DetalleItem',
            'eFactura.Definiciones.SDTCFEInterno.DetalleItem' => '\\App\\Soap\\StructType\\EFactura_Definiciones_SDTCFEInterno_DetalleItem',
            'ArrayOfeFactura.Definiciones.SDTCFEInterno.DescuentosRecargosGlobalItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_Definiciones_SDTCFEInterno_DescuentosRecargosGlobalItem',
            'eFactura.Definiciones.SDTCFEInterno.DescuentosRecargosGlobalItem' => '\\App\\Soap\\StructType\\EFactura_Definiciones_SDTCFEInterno_DescuentosRecargosGlobalItem',
            'ArrayOfeFactura.Definiciones.SDTCFEInterno.SubtotalesItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_Definiciones_SDTCFEInterno_SubtotalesItem',
            'eFactura.Definiciones.SDTCFEInterno.SubtotalesItem' => '\\App\\Soap\\StructType\\EFactura_Definiciones_SDTCFEInterno_SubtotalesItem',
            'ArrayOfeFactura.Definiciones.SDTCFEInterno.TotalesRetencionesPercepcionesItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_Definiciones_SDTCFEInterno_TotalesRetencionesPercepcionesItem',
            'eFactura.Definiciones.SDTCFEInterno.TotalesRetencionesPercepcionesItem' => '\\App\\Soap\\StructType\\EFactura_Definiciones_SDTCFEInterno_TotalesRetencionesPercepcionesItem',
            'ArrayOfeFactura.Definiciones.SDTCFEInterno.MediosPagoItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_Definiciones_SDTCFEInterno_MediosPagoItem',
            'eFactura.Definiciones.SDTCFEInterno.MediosPagoItem' => '\\App\\Soap\\StructType\\EFactura_Definiciones_SDTCFEInterno_MediosPagoItem',
            'ArrayOfeFactura.Definiciones.SDTCFEInterno.ReferenciaItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_Definiciones_SDTCFEInterno_ReferenciaItem',
            'eFactura.Definiciones.SDTCFEInterno.ReferenciaItem' => '\\App\\Soap\\StructType\\EFactura_Definiciones_SDTCFEInterno_ReferenciaItem',
            'ArrayOfeFactura.Definiciones.SDTCFEInterno.AdendaItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_Definiciones_SDTCFEInterno_AdendaItem',
            'eFactura.Definiciones.SDTCFEInterno.AdendaItem' => '\\App\\Soap\\StructType\\EFactura_Definiciones_SDTCFEInterno_AdendaItem',
            'eFactura.Definiciones.SDTCFEInterno.Cobranza' => '\\App\\Soap\\StructType\\EFactura_Definiciones_SDTCFEInterno_Cobranza',
            'ArrayOfeFactura.Definiciones.SDTCFEInterno.NotificarItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_Definiciones_SDTCFEInterno_NotificarItem',
            'eFactura.Definiciones.SDTCFEInterno.NotificarItem' => '\\App\\Soap\\StructType\\EFactura_Definiciones_SDTCFEInterno_NotificarItem',
            'eFactura.Definiciones.SDTCFEInterno.PlanDePagos' => '\\App\\Soap\\StructType\\EFactura_Definiciones_SDTCFEInterno_PlanDePagos',
            'ArrayOfeFactura.Definiciones.SDTCFEInterno.ComprobantesDePagoItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_Definiciones_SDTCFEInterno_ComprobantesDePagoItem',
            'eFactura.Definiciones.SDTCFEInterno.ComprobantesDePagoItem' => '\\App\\Soap\\StructType\\EFactura_Definiciones_SDTCFEInterno_ComprobantesDePagoItem',
            'ArrayOfeFactura.Definiciones.SDTCFEInterno.DetalleItem.DescuentoRecargoItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_Definiciones_SDTCFEInterno_DetalleItem_DescuentoRecargoItem',
            'eFactura.Definiciones.SDTCFEInterno.DetalleItem.DescuentoRecargoItem' => '\\App\\Soap\\StructType\\EFactura_Definiciones_SDTCFEInterno_DetalleItem_DescuentoRecargoItem',
            'ArrayOfeFactura.Definiciones.SDTCFEInterno.DetalleItem.RetencionPercepcionItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_Definiciones_SDTCFEInterno_DetalleItem_RetencionPercepcionItem',
            'eFactura.Definiciones.SDTCFEInterno.DetalleItem.RetencionPercepcionItem' => '\\App\\Soap\\StructType\\EFactura_Definiciones_SDTCFEInterno_DetalleItem_RetencionPercepcionItem',
            'ArrayOfeFactura.Definiciones.SDTCFEInterno.DetalleItem.CodigosProductoServicioItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_Definiciones_SDTCFEInterno_DetalleItem_CodigosProductoServicioItem',
            'eFactura.Definiciones.SDTCFEInterno.DetalleItem.CodigosProductoServicioItem' => '\\App\\Soap\\StructType\\EFactura_Definiciones_SDTCFEInterno_DetalleItem_CodigosProductoServicioItem',
            'ArrayOfeFactura.Definiciones.SDTCFEInterno.DetalleItem.DatosAdicionalesItem' => '\\App\\Soap\\ArrayType\\ArrayOfeFactura_Definiciones_SDTCFEInterno_DetalleItem_DatosAdicionalesItem',
            'eFactura.Definiciones.SDTCFEInterno.DetalleItem.DatosAdicionalesItem' => '\\App\\Soap\\StructType\\EFactura_Definiciones_SDTCFEInterno_DetalleItem_DatosAdicionalesItem',
            'SDTWSPrevisualizarFormularioOutV1' => '\\App\\Soap\\StructType\\SDTWSPrevisualizarFormularioOutV1',
            'eFactura.WebServices.SDTWSPrevisualizarFormularioOutV1.Error' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTWSPrevisualizarFormularioOutV1_Error',
            'eFactura.WebServices.SDTWSPrevisualizarFormularioOutV1.Respuesta' => '\\App\\Soap\\StructType\\EFactura_WebServices_SDTWSPrevisualizarFormularioOutV1_Respuesta',
            'WSCFEV5.ENVIARCFE' => '\\App\\Soap\\StructType\\WSCFEV5_ENVIARCFE',
            'WSCFEV5.ENVIARCFEResponse' => '\\App\\Soap\\StructType\\WSCFEV5_ENVIARCFEResponse',
            'WSCFEV5.ENVIARCFES' => '\\App\\Soap\\StructType\\WSCFEV5_ENVIARCFES',
            'WSCFEV5.ENVIARCFESResponse' => '\\App\\Soap\\StructType\\WSCFEV5_ENVIARCFESResponse',
            'WSCFEV5.RESULTADOENVIOCFE' => '\\App\\Soap\\StructType\\WSCFEV5_RESULTADOENVIOCFE',
            'WSCFEV5.RESULTADOENVIOCFEResponse' => '\\App\\Soap\\StructType\\WSCFEV5_RESULTADOENVIOCFEResponse',
            'WSCFEV5.RESULTADOENVIOCFES' => '\\App\\Soap\\StructType\\WSCFEV5_RESULTADOENVIOCFES',
            'WSCFEV5.RESULTADOENVIOCFESResponse' => '\\App\\Soap\\StructType\\WSCFEV5_RESULTADOENVIOCFESResponse',
            'WSCFEV5.CONSULTARCFESEMITIDOS' => '\\App\\Soap\\StructType\\WSCFEV5_CONSULTARCFESEMITIDOS',
            'WSCFEV5.CONSULTARCFESEMITIDOSResponse' => '\\App\\Soap\\StructType\\WSCFEV5_CONSULTARCFESEMITIDOSResponse',
            'WSCFEV5.CONSULTARCFESRECIBIDOS' => '\\App\\Soap\\StructType\\WSCFEV5_CONSULTARCFESRECIBIDOS',
            'WSCFEV5.CONSULTARCFESRECIBIDOSResponse' => '\\App\\Soap\\StructType\\WSCFEV5_CONSULTARCFESRECIBIDOSResponse',
            'WSCFEV5.CONSULTARDETALLECFERECIBIDO' => '\\App\\Soap\\StructType\\WSCFEV5_CONSULTARDETALLECFERECIBIDO',
            'WSCFEV5.CONSULTARDETALLECFERECIBIDOResponse' => '\\App\\Soap\\StructType\\WSCFEV5_CONSULTARDETALLECFERECIBIDOResponse',
            'WSCFEV5.RESPONDERCFES' => '\\App\\Soap\\StructType\\WSCFEV5_RESPONDERCFES',
            'WSCFEV5.RESPONDERCFESResponse' => '\\App\\Soap\\StructType\\WSCFEV5_RESPONDERCFESResponse',
            'WSCFEV5.CONSULTARCFEESTADOSHISTORICO' => '\\App\\Soap\\StructType\\WSCFEV5_CONSULTARCFEESTADOSHISTORICO',
            'WSCFEV5.CONSULTARCFEESTADOSHISTORICOResponse' => '\\App\\Soap\\StructType\\WSCFEV5_CONSULTARCFEESTADOSHISTORICOResponse',
            'WSCFEV5.ENVIARNOTIFICACIONES' => '\\App\\Soap\\StructType\\WSCFEV5_ENVIARNOTIFICACIONES',
            'WSCFEV5.ENVIARNOTIFICACIONESResponse' => '\\App\\Soap\\StructType\\WSCFEV5_ENVIARNOTIFICACIONESResponse',
            'WSCFEV5.PREVISUALIZARFORMULARIO' => '\\App\\Soap\\StructType\\WSCFEV5_PREVISUALIZARFORMULARIO',
            'WSCFEV5.PREVISUALIZARFORMULARIOResponse' => '\\App\\Soap\\StructType\\WSCFEV5_PREVISUALIZARFORMULARIOResponse',
        );
    }
}
