<?php

namespace App\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SDTWSEnviarNotificacionesInV1 StructType
 * @subpackage Structs
 */
class SDTWSEnviarNotificacionesInV1 extends AbstractStructBase
{
    /**
     * The Conexion
     * @var \App\Soap\StructType\SDTWSCFEConexionV1
     */
    public $Conexion;
    /**
     * The EmisorTipo
     * @var string
     */
    public $EmisorTipo;
    /**
     * The EmisorSerie
     * @var string
     */
    public $EmisorSerie;
    /**
     * The EmisorNumero
     * @var int
     */
    public $EmisorNumero;
    /**
     * The CFESerie
     * @var string
     */
    public $CFESerie;
    /**
     * The CFENumero
     * @var int
     */
    public $CFENumero;
    /**
     * The Notificar
     * @var \App\Soap\StructType\Notificar
     */
    public $Notificar;
    /**
     * Constructor method for SDTWSEnviarNotificacionesInV1
     * @uses SDTWSEnviarNotificacionesInV1::setConexion()
     * @uses SDTWSEnviarNotificacionesInV1::setEmisorTipo()
     * @uses SDTWSEnviarNotificacionesInV1::setEmisorSerie()
     * @uses SDTWSEnviarNotificacionesInV1::setEmisorNumero()
     * @uses SDTWSEnviarNotificacionesInV1::setCFESerie()
     * @uses SDTWSEnviarNotificacionesInV1::setCFENumero()
     * @uses SDTWSEnviarNotificacionesInV1::setNotificar()
     * @param \App\Soap\StructType\SDTWSCFEConexionV1 $conexion
     * @param string $emisorTipo
     * @param string $emisorSerie
     * @param int $emisorNumero
     * @param string $cFESerie
     * @param int $cFENumero
     * @param \App\Soap\StructType\Notificar $notificar
     */
    public function __construct(\App\Soap\StructType\SDTWSCFEConexionV1 $conexion = null, $emisorTipo = null, $emisorSerie = null, $emisorNumero = null, $cFESerie = null, $cFENumero = null, \App\Soap\StructType\Notificar $notificar = null)
    {
        $this
            ->setConexion($conexion)
            ->setEmisorTipo($emisorTipo)
            ->setEmisorSerie($emisorSerie)
            ->setEmisorNumero($emisorNumero)
            ->setCFESerie($cFESerie)
            ->setCFENumero($cFENumero)
            ->setNotificar($notificar);
    }
    /**
     * Get Conexion value
     * @return \App\Soap\StructType\SDTWSCFEConexionV1|null
     */
    public function getConexion()
    {
        return $this->Conexion;
    }
    /**
     * Set Conexion value
     * @param \App\Soap\StructType\SDTWSCFEConexionV1 $conexion
     * @return \App\Soap\StructType\SDTWSEnviarNotificacionesInV1
     */
    public function setConexion(\App\Soap\StructType\SDTWSCFEConexionV1 $conexion = null)
    {
        $this->Conexion = $conexion;
        return $this;
    }
    /**
     * Get EmisorTipo value
     * @return string|null
     */
    public function getEmisorTipo()
    {
        return $this->EmisorTipo;
    }
    /**
     * Set EmisorTipo value
     * @param string $emisorTipo
     * @return \App\Soap\StructType\SDTWSEnviarNotificacionesInV1
     */
    public function setEmisorTipo($emisorTipo = null)
    {
        // validation for constraint: string
        if (!is_null($emisorTipo) && !is_string($emisorTipo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emisorTipo, true), gettype($emisorTipo)), __LINE__);
        }
        $this->EmisorTipo = $emisorTipo;
        return $this;
    }
    /**
     * Get EmisorSerie value
     * @return string|null
     */
    public function getEmisorSerie()
    {
        return $this->EmisorSerie;
    }
    /**
     * Set EmisorSerie value
     * @param string $emisorSerie
     * @return \App\Soap\StructType\SDTWSEnviarNotificacionesInV1
     */
    public function setEmisorSerie($emisorSerie = null)
    {
        // validation for constraint: string
        if (!is_null($emisorSerie) && !is_string($emisorSerie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emisorSerie, true), gettype($emisorSerie)), __LINE__);
        }
        $this->EmisorSerie = $emisorSerie;
        return $this;
    }
    /**
     * Get EmisorNumero value
     * @return int|null
     */
    public function getEmisorNumero()
    {
        return $this->EmisorNumero;
    }
    /**
     * Set EmisorNumero value
     * @param int $emisorNumero
     * @return \App\Soap\StructType\SDTWSEnviarNotificacionesInV1
     */
    public function setEmisorNumero($emisorNumero = null)
    {
        // validation for constraint: int
        if (!is_null($emisorNumero) && !(is_int($emisorNumero) || ctype_digit($emisorNumero))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($emisorNumero, true), gettype($emisorNumero)), __LINE__);
        }
        $this->EmisorNumero = $emisorNumero;
        return $this;
    }
    /**
     * Get CFESerie value
     * @return string|null
     */
    public function getCFESerie()
    {
        return $this->CFESerie;
    }
    /**
     * Set CFESerie value
     * @param string $cFESerie
     * @return \App\Soap\StructType\SDTWSEnviarNotificacionesInV1
     */
    public function setCFESerie($cFESerie = null)
    {
        // validation for constraint: string
        if (!is_null($cFESerie) && !is_string($cFESerie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cFESerie, true), gettype($cFESerie)), __LINE__);
        }
        $this->CFESerie = $cFESerie;
        return $this;
    }
    /**
     * Get CFENumero value
     * @return int|null
     */
    public function getCFENumero()
    {
        return $this->CFENumero;
    }
    /**
     * Set CFENumero value
     * @param int $cFENumero
     * @return \App\Soap\StructType\SDTWSEnviarNotificacionesInV1
     */
    public function setCFENumero($cFENumero = null)
    {
        // validation for constraint: int
        if (!is_null($cFENumero) && !(is_int($cFENumero) || ctype_digit($cFENumero))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cFENumero, true), gettype($cFENumero)), __LINE__);
        }
        $this->CFENumero = $cFENumero;
        return $this;
    }
    /**
     * Get Notificar value
     * @return \App\Soap\StructType\Notificar|null
     */
    public function getNotificar()
    {
        return $this->Notificar;
    }
    /**
     * Set Notificar value
     * @param \App\Soap\StructType\Notificar $notificar
     * @return \App\Soap\StructType\SDTWSEnviarNotificacionesInV1
     */
    public function setNotificar(\App\Soap\StructType\Notificar $notificar = null)
    {
        $this->Notificar = $notificar;
        return $this;
    }
}
