<?php

namespace App\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SDTWSCFEConsultarCFEsRecibidosInV1 StructType
 * @subpackage Structs
 */
class SDTWSCFEConsultarCFEsRecibidosInV1 extends AbstractStructBase
{
    /**
     * The Conexion
     * @var \App\Soap\StructType\SDTWSCFEConexionV1
     */
    public $Conexion;
    /**
     * The EmisorCFETipo
     * @var string
     */
    public $EmisorCFETipo;
    /**
     * The TipoDeCFEReceptorNacional
     * @var string
     */
    public $TipoDeCFEReceptorNacional;
    /**
     * The TipoDeCFESiRequiereRUT
     * @var string
     */
    public $TipoDeCFESiRequiereRUT;
    /**
     * The FechaEmisionDesde
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FechaEmisionDesde;
    /**
     * The FechaEmisionHasta
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FechaEmisionHasta;
    /**
     * The EstadoLocal
     * @var string
     */
    public $EstadoLocal;
    /**
     * The EstadoDGI
     * @var string
     */
    public $EstadoDGI;
    /**
     * The EstadoReceptor
     * @var string
     */
    public $EstadoReceptor;
    /**
     * The Pagina
     * @var int
     */
    public $Pagina;
    /**
     * The RegistrosPorPagina
     * @var int
     */
    public $RegistrosPorPagina;
    /**
     * Constructor method for SDTWSCFEConsultarCFEsRecibidosInV1
     * @uses SDTWSCFEConsultarCFEsRecibidosInV1::setConexion()
     * @uses SDTWSCFEConsultarCFEsRecibidosInV1::setEmisorCFETipo()
     * @uses SDTWSCFEConsultarCFEsRecibidosInV1::setTipoDeCFEReceptorNacional()
     * @uses SDTWSCFEConsultarCFEsRecibidosInV1::setTipoDeCFESiRequiereRUT()
     * @uses SDTWSCFEConsultarCFEsRecibidosInV1::setFechaEmisionDesde()
     * @uses SDTWSCFEConsultarCFEsRecibidosInV1::setFechaEmisionHasta()
     * @uses SDTWSCFEConsultarCFEsRecibidosInV1::setEstadoLocal()
     * @uses SDTWSCFEConsultarCFEsRecibidosInV1::setEstadoDGI()
     * @uses SDTWSCFEConsultarCFEsRecibidosInV1::setEstadoReceptor()
     * @uses SDTWSCFEConsultarCFEsRecibidosInV1::setPagina()
     * @uses SDTWSCFEConsultarCFEsRecibidosInV1::setRegistrosPorPagina()
     * @param \App\Soap\StructType\SDTWSCFEConexionV1 $conexion
     * @param string $emisorCFETipo
     * @param string $tipoDeCFEReceptorNacional
     * @param string $tipoDeCFESiRequiereRUT
     * @param string $fechaEmisionDesde
     * @param string $fechaEmisionHasta
     * @param string $estadoLocal
     * @param string $estadoDGI
     * @param string $estadoReceptor
     * @param int $pagina
     * @param int $registrosPorPagina
     */
    public function __construct(\App\Soap\StructType\SDTWSCFEConexionV1 $conexion = null, $emisorCFETipo = null, $tipoDeCFEReceptorNacional = null, $tipoDeCFESiRequiereRUT = null, $fechaEmisionDesde = null, $fechaEmisionHasta = null, $estadoLocal = null, $estadoDGI = null, $estadoReceptor = null, $pagina = null, $registrosPorPagina = null)
    {
        $this
            ->setConexion($conexion)
            ->setEmisorCFETipo($emisorCFETipo)
            ->setTipoDeCFEReceptorNacional($tipoDeCFEReceptorNacional)
            ->setTipoDeCFESiRequiereRUT($tipoDeCFESiRequiereRUT)
            ->setFechaEmisionDesde($fechaEmisionDesde)
            ->setFechaEmisionHasta($fechaEmisionHasta)
            ->setEstadoLocal($estadoLocal)
            ->setEstadoDGI($estadoDGI)
            ->setEstadoReceptor($estadoReceptor)
            ->setPagina($pagina)
            ->setRegistrosPorPagina($registrosPorPagina);
    }
    /**
     * Get Conexion value
     * @return \App\Soap\StructType\SDTWSCFEConexionV1|null
     */
    public function getConexion()
    {
        return $this->Conexion;
    }
    /**
     * Set Conexion value
     * @param \App\Soap\StructType\SDTWSCFEConexionV1 $conexion
     * @return \App\Soap\StructType\SDTWSCFEConsultarCFEsRecibidosInV1
     */
    public function setConexion(\App\Soap\StructType\SDTWSCFEConexionV1 $conexion = null)
    {
        $this->Conexion = $conexion;
        return $this;
    }
    /**
     * Get EmisorCFETipo value
     * @return string|null
     */
    public function getEmisorCFETipo()
    {
        return $this->EmisorCFETipo;
    }
    /**
     * Set EmisorCFETipo value
     * @param string $emisorCFETipo
     * @return \App\Soap\StructType\SDTWSCFEConsultarCFEsRecibidosInV1
     */
    public function setEmisorCFETipo($emisorCFETipo = null)
    {
        // validation for constraint: string
        if (!is_null($emisorCFETipo) && !is_string($emisorCFETipo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emisorCFETipo, true), gettype($emisorCFETipo)), __LINE__);
        }
        $this->EmisorCFETipo = $emisorCFETipo;
        return $this;
    }
    /**
     * Get TipoDeCFEReceptorNacional value
     * @return string|null
     */
    public function getTipoDeCFEReceptorNacional()
    {
        return $this->TipoDeCFEReceptorNacional;
    }
    /**
     * Set TipoDeCFEReceptorNacional value
     * @param string $tipoDeCFEReceptorNacional
     * @return \App\Soap\StructType\SDTWSCFEConsultarCFEsRecibidosInV1
     */
    public function setTipoDeCFEReceptorNacional($tipoDeCFEReceptorNacional = null)
    {
        // validation for constraint: string
        if (!is_null($tipoDeCFEReceptorNacional) && !is_string($tipoDeCFEReceptorNacional)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoDeCFEReceptorNacional, true), gettype($tipoDeCFEReceptorNacional)), __LINE__);
        }
        $this->TipoDeCFEReceptorNacional = $tipoDeCFEReceptorNacional;
        return $this;
    }
    /**
     * Get TipoDeCFESiRequiereRUT value
     * @return string|null
     */
    public function getTipoDeCFESiRequiereRUT()
    {
        return $this->TipoDeCFESiRequiereRUT;
    }
    /**
     * Set TipoDeCFESiRequiereRUT value
     * @param string $tipoDeCFESiRequiereRUT
     * @return \App\Soap\StructType\SDTWSCFEConsultarCFEsRecibidosInV1
     */
    public function setTipoDeCFESiRequiereRUT($tipoDeCFESiRequiereRUT = null)
    {
        // validation for constraint: string
        if (!is_null($tipoDeCFESiRequiereRUT) && !is_string($tipoDeCFESiRequiereRUT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoDeCFESiRequiereRUT, true), gettype($tipoDeCFESiRequiereRUT)), __LINE__);
        }
        $this->TipoDeCFESiRequiereRUT = $tipoDeCFESiRequiereRUT;
        return $this;
    }
    /**
     * Get FechaEmisionDesde value
     * @return string|null
     */
    public function getFechaEmisionDesde()
    {
        return $this->FechaEmisionDesde;
    }
    /**
     * Set FechaEmisionDesde value
     * @param string $fechaEmisionDesde
     * @return \App\Soap\StructType\SDTWSCFEConsultarCFEsRecibidosInV1
     */
    public function setFechaEmisionDesde($fechaEmisionDesde = null)
    {
        // validation for constraint: string
        if (!is_null($fechaEmisionDesde) && !is_string($fechaEmisionDesde)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaEmisionDesde, true), gettype($fechaEmisionDesde)), __LINE__);
        }
        $this->FechaEmisionDesde = $fechaEmisionDesde;
        return $this;
    }
    /**
     * Get FechaEmisionHasta value
     * @return string|null
     */
    public function getFechaEmisionHasta()
    {
        return $this->FechaEmisionHasta;
    }
    /**
     * Set FechaEmisionHasta value
     * @param string $fechaEmisionHasta
     * @return \App\Soap\StructType\SDTWSCFEConsultarCFEsRecibidosInV1
     */
    public function setFechaEmisionHasta($fechaEmisionHasta = null)
    {
        // validation for constraint: string
        if (!is_null($fechaEmisionHasta) && !is_string($fechaEmisionHasta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaEmisionHasta, true), gettype($fechaEmisionHasta)), __LINE__);
        }
        $this->FechaEmisionHasta = $fechaEmisionHasta;
        return $this;
    }
    /**
     * Get EstadoLocal value
     * @return string|null
     */
    public function getEstadoLocal()
    {
        return $this->EstadoLocal;
    }
    /**
     * Set EstadoLocal value
     * @param string $estadoLocal
     * @return \App\Soap\StructType\SDTWSCFEConsultarCFEsRecibidosInV1
     */
    public function setEstadoLocal($estadoLocal = null)
    {
        // validation for constraint: string
        if (!is_null($estadoLocal) && !is_string($estadoLocal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estadoLocal, true), gettype($estadoLocal)), __LINE__);
        }
        $this->EstadoLocal = $estadoLocal;
        return $this;
    }
    /**
     * Get EstadoDGI value
     * @return string|null
     */
    public function getEstadoDGI()
    {
        return $this->EstadoDGI;
    }
    /**
     * Set EstadoDGI value
     * @param string $estadoDGI
     * @return \App\Soap\StructType\SDTWSCFEConsultarCFEsRecibidosInV1
     */
    public function setEstadoDGI($estadoDGI = null)
    {
        // validation for constraint: string
        if (!is_null($estadoDGI) && !is_string($estadoDGI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estadoDGI, true), gettype($estadoDGI)), __LINE__);
        }
        $this->EstadoDGI = $estadoDGI;
        return $this;
    }
    /**
     * Get EstadoReceptor value
     * @return string|null
     */
    public function getEstadoReceptor()
    {
        return $this->EstadoReceptor;
    }
    /**
     * Set EstadoReceptor value
     * @param string $estadoReceptor
     * @return \App\Soap\StructType\SDTWSCFEConsultarCFEsRecibidosInV1
     */
    public function setEstadoReceptor($estadoReceptor = null)
    {
        // validation for constraint: string
        if (!is_null($estadoReceptor) && !is_string($estadoReceptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estadoReceptor, true), gettype($estadoReceptor)), __LINE__);
        }
        $this->EstadoReceptor = $estadoReceptor;
        return $this;
    }
    /**
     * Get Pagina value
     * @return int|null
     */
    public function getPagina()
    {
        return $this->Pagina;
    }
    /**
     * Set Pagina value
     * @param int $pagina
     * @return \App\Soap\StructType\SDTWSCFEConsultarCFEsRecibidosInV1
     */
    public function setPagina($pagina = null)
    {
        // validation for constraint: int
        if (!is_null($pagina) && !(is_int($pagina) || ctype_digit($pagina))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pagina, true), gettype($pagina)), __LINE__);
        }
        $this->Pagina = $pagina;
        return $this;
    }
    /**
     * Get RegistrosPorPagina value
     * @return int|null
     */
    public function getRegistrosPorPagina()
    {
        return $this->RegistrosPorPagina;
    }
    /**
     * Set RegistrosPorPagina value
     * @param int $registrosPorPagina
     * @return \App\Soap\StructType\SDTWSCFEConsultarCFEsRecibidosInV1
     */
    public function setRegistrosPorPagina($registrosPorPagina = null)
    {
        // validation for constraint: int
        if (!is_null($registrosPorPagina) && !(is_int($registrosPorPagina) || ctype_digit($registrosPorPagina))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($registrosPorPagina, true), gettype($registrosPorPagina)), __LINE__);
        }
        $this->RegistrosPorPagina = $registrosPorPagina;
        return $this;
    }
}
