<?php

namespace App\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SDTWSCFEConexionV1 StructType
 * @subpackage Structs
 */
class SDTWSCFEConexionV1 extends AbstractStructBase
{
    /**
     * The RUT
     * @var string
     */
    public $RUT;
    /**
     * The Sucursal
     * @var int
     */
    public $Sucursal;
    /**
     * The Usuario
     * @var string
     */
    public $Usuario;
    /**
     * The Password
     * @var string
     */
    public $Password;
    /**
     * The Ambiente
     * @var string
     */
    public $Ambiente;
    /**
     * Constructor method for SDTWSCFEConexionV1
     * @uses SDTWSCFEConexionV1::setRUT()
     * @uses SDTWSCFEConexionV1::setSucursal()
     * @uses SDTWSCFEConexionV1::setUsuario()
     * @uses SDTWSCFEConexionV1::setPassword()
     * @uses SDTWSCFEConexionV1::setAmbiente()
     * @param string $rUT
     * @param int $sucursal
     * @param string $usuario
     * @param string $password
     * @param string $ambiente
     */
    public function __construct($rUT = null, $sucursal = null, $usuario = null, $password = null, $ambiente = null)
    {
        $this
            ->setRUT($rUT)
            ->setSucursal($sucursal)
            ->setUsuario($usuario)
            ->setPassword($password)
            ->setAmbiente($ambiente);
    }
    /**
     * Get RUT value
     * @return string|null
     */
    public function getRUT()
    {
        return $this->RUT;
    }
    /**
     * Set RUT value
     * @param string $rUT
     * @return \App\Soap\StructType\SDTWSCFEConexionV1
     */
    public function setRUT($rUT = null)
    {
        // validation for constraint: string
        if (!is_null($rUT) && !is_string($rUT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rUT, true), gettype($rUT)), __LINE__);
        }
        $this->RUT = $rUT;
        return $this;
    }
    /**
     * Get Sucursal value
     * @return int|null
     */
    public function getSucursal()
    {
        return $this->Sucursal;
    }
    /**
     * Set Sucursal value
     * @param int $sucursal
     * @return \App\Soap\StructType\SDTWSCFEConexionV1
     */
    public function setSucursal($sucursal = null)
    {
        // validation for constraint: int
        if (!is_null($sucursal) && !(is_int($sucursal) || ctype_digit($sucursal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sucursal, true), gettype($sucursal)), __LINE__);
        }
        $this->Sucursal = $sucursal;
        return $this;
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \App\Soap\StructType\SDTWSCFEConexionV1
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \App\Soap\StructType\SDTWSCFEConexionV1
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get Ambiente value
     * @return string|null
     */
    public function getAmbiente()
    {
        return $this->Ambiente;
    }
    /**
     * Set Ambiente value
     * @param string $ambiente
     * @return \App\Soap\StructType\SDTWSCFEConexionV1
     */
    public function setAmbiente($ambiente = null)
    {
        // validation for constraint: string
        if (!is_null($ambiente) && !is_string($ambiente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ambiente, true), gettype($ambiente)), __LINE__);
        }
        $this->Ambiente = $ambiente;
        return $this;
    }
}
