<?php

namespace App\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * eFactura.WebServices.SDTWSCFEResultadoEnvioCFEOutV4.Respuesta StructType
 * @subpackage Structs
 */
class EFactura_WebServices_SDTWSCFEResultadoEnvioCFEOutV4_Respuesta extends AbstractStructBase
{
    /**
     * The CFESerie
     * @var string
     */
    public $CFESerie;
    /**
     * The CFENumero
     * @var int
     */
    public $CFENumero;
    /**
     * The DigestValue
     * @var string
     */
    public $DigestValue;
    /**
     * The PDFLink
     * @var string
     */
    public $PDFLink;
    /**
     * The DGILink
     * @var string
     */
    public $DGILink;
    /**
     * The QR
     * @var string
     */
    public $QR;
    /**
     * The EstadoLocal
     * @var string
     */
    public $EstadoLocal;
    /**
     * The EstadoDGI
     * @var string
     */
    public $EstadoDGI;
    /**
     * The EstadoReceptor
     * @var string
     */
    public $EstadoReceptor;
    /**
     * The ProximaConsulta
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ProximaConsulta;
    /**
     * The CAE
     * @var \App\Soap\StructType\SDTWSCFEV1CAEData
     */
    public $CAE;
    /**
     * The Cobranza
     * @var \App\Soap\StructType\SDTWSCFECobranzaDataV1
     */
    public $Cobranza;
    /**
     * Constructor method for
     * eFactura.WebServices.SDTWSCFEResultadoEnvioCFEOutV4.Respuesta
     * @uses EFactura_WebServices_SDTWSCFEResultadoEnvioCFEOutV4_Respuesta::setCFESerie()
     * @uses EFactura_WebServices_SDTWSCFEResultadoEnvioCFEOutV4_Respuesta::setCFENumero()
     * @uses EFactura_WebServices_SDTWSCFEResultadoEnvioCFEOutV4_Respuesta::setDigestValue()
     * @uses EFactura_WebServices_SDTWSCFEResultadoEnvioCFEOutV4_Respuesta::setPDFLink()
     * @uses EFactura_WebServices_SDTWSCFEResultadoEnvioCFEOutV4_Respuesta::setDGILink()
     * @uses EFactura_WebServices_SDTWSCFEResultadoEnvioCFEOutV4_Respuesta::setQR()
     * @uses EFactura_WebServices_SDTWSCFEResultadoEnvioCFEOutV4_Respuesta::setEstadoLocal()
     * @uses EFactura_WebServices_SDTWSCFEResultadoEnvioCFEOutV4_Respuesta::setEstadoDGI()
     * @uses EFactura_WebServices_SDTWSCFEResultadoEnvioCFEOutV4_Respuesta::setEstadoReceptor()
     * @uses EFactura_WebServices_SDTWSCFEResultadoEnvioCFEOutV4_Respuesta::setProximaConsulta()
     * @uses EFactura_WebServices_SDTWSCFEResultadoEnvioCFEOutV4_Respuesta::setCAE()
     * @uses EFactura_WebServices_SDTWSCFEResultadoEnvioCFEOutV4_Respuesta::setCobranza()
     * @param string $cFESerie
     * @param int $cFENumero
     * @param string $digestValue
     * @param string $pDFLink
     * @param string $dGILink
     * @param string $qR
     * @param string $estadoLocal
     * @param string $estadoDGI
     * @param string $estadoReceptor
     * @param string $proximaConsulta
     * @param \App\Soap\StructType\SDTWSCFEV1CAEData $cAE
     * @param \App\Soap\StructType\SDTWSCFECobranzaDataV1 $cobranza
     */
    public function __construct($cFESerie = null, $cFENumero = null, $digestValue = null, $pDFLink = null, $dGILink = null, $qR = null, $estadoLocal = null, $estadoDGI = null, $estadoReceptor = null, $proximaConsulta = null, \App\Soap\StructType\SDTWSCFEV1CAEData $cAE = null, \App\Soap\StructType\SDTWSCFECobranzaDataV1 $cobranza = null)
    {
        $this
            ->setCFESerie($cFESerie)
            ->setCFENumero($cFENumero)
            ->setDigestValue($digestValue)
            ->setPDFLink($pDFLink)
            ->setDGILink($dGILink)
            ->setQR($qR)
            ->setEstadoLocal($estadoLocal)
            ->setEstadoDGI($estadoDGI)
            ->setEstadoReceptor($estadoReceptor)
            ->setProximaConsulta($proximaConsulta)
            ->setCAE($cAE)
            ->setCobranza($cobranza);
    }
    /**
     * Get CFESerie value
     * @return string|null
     */
    public function getCFESerie()
    {
        return $this->CFESerie;
    }
    /**
     * Set CFESerie value
     * @param string $cFESerie
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEResultadoEnvioCFEOutV4_Respuesta
     */
    public function setCFESerie($cFESerie = null)
    {
        // validation for constraint: string
        if (!is_null($cFESerie) && !is_string($cFESerie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cFESerie, true), gettype($cFESerie)), __LINE__);
        }
        $this->CFESerie = $cFESerie;
        return $this;
    }
    /**
     * Get CFENumero value
     * @return int|null
     */
    public function getCFENumero()
    {
        return $this->CFENumero;
    }
    /**
     * Set CFENumero value
     * @param int $cFENumero
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEResultadoEnvioCFEOutV4_Respuesta
     */
    public function setCFENumero($cFENumero = null)
    {
        // validation for constraint: int
        if (!is_null($cFENumero) && !(is_int($cFENumero) || ctype_digit($cFENumero))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cFENumero, true), gettype($cFENumero)), __LINE__);
        }
        $this->CFENumero = $cFENumero;
        return $this;
    }
    /**
     * Get DigestValue value
     * @return string|null
     */
    public function getDigestValue()
    {
        return $this->DigestValue;
    }
    /**
     * Set DigestValue value
     * @param string $digestValue
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEResultadoEnvioCFEOutV4_Respuesta
     */
    public function setDigestValue($digestValue = null)
    {
        // validation for constraint: string
        if (!is_null($digestValue) && !is_string($digestValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($digestValue, true), gettype($digestValue)), __LINE__);
        }
        $this->DigestValue = $digestValue;
        return $this;
    }
    /**
     * Get PDFLink value
     * @return string|null
     */
    public function getPDFLink()
    {
        return $this->PDFLink;
    }
    /**
     * Set PDFLink value
     * @param string $pDFLink
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEResultadoEnvioCFEOutV4_Respuesta
     */
    public function setPDFLink($pDFLink = null)
    {
        // validation for constraint: string
        if (!is_null($pDFLink) && !is_string($pDFLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pDFLink, true), gettype($pDFLink)), __LINE__);
        }
        $this->PDFLink = $pDFLink;
        return $this;
    }
    /**
     * Get DGILink value
     * @return string|null
     */
    public function getDGILink()
    {
        return $this->DGILink;
    }
    /**
     * Set DGILink value
     * @param string $dGILink
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEResultadoEnvioCFEOutV4_Respuesta
     */
    public function setDGILink($dGILink = null)
    {
        // validation for constraint: string
        if (!is_null($dGILink) && !is_string($dGILink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dGILink, true), gettype($dGILink)), __LINE__);
        }
        $this->DGILink = $dGILink;
        return $this;
    }
    /**
     * Get QR value
     * @return string|null
     */
    public function getQR()
    {
        return $this->QR;
    }
    /**
     * Set QR value
     * @param string $qR
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEResultadoEnvioCFEOutV4_Respuesta
     */
    public function setQR($qR = null)
    {
        // validation for constraint: string
        if (!is_null($qR) && !is_string($qR)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qR, true), gettype($qR)), __LINE__);
        }
        $this->QR = $qR;
        return $this;
    }
    /**
     * Get EstadoLocal value
     * @return string|null
     */
    public function getEstadoLocal()
    {
        return $this->EstadoLocal;
    }
    /**
     * Set EstadoLocal value
     * @param string $estadoLocal
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEResultadoEnvioCFEOutV4_Respuesta
     */
    public function setEstadoLocal($estadoLocal = null)
    {
        // validation for constraint: string
        if (!is_null($estadoLocal) && !is_string($estadoLocal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estadoLocal, true), gettype($estadoLocal)), __LINE__);
        }
        $this->EstadoLocal = $estadoLocal;
        return $this;
    }
    /**
     * Get EstadoDGI value
     * @return string|null
     */
    public function getEstadoDGI()
    {
        return $this->EstadoDGI;
    }
    /**
     * Set EstadoDGI value
     * @param string $estadoDGI
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEResultadoEnvioCFEOutV4_Respuesta
     */
    public function setEstadoDGI($estadoDGI = null)
    {
        // validation for constraint: string
        if (!is_null($estadoDGI) && !is_string($estadoDGI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estadoDGI, true), gettype($estadoDGI)), __LINE__);
        }
        $this->EstadoDGI = $estadoDGI;
        return $this;
    }
    /**
     * Get EstadoReceptor value
     * @return string|null
     */
    public function getEstadoReceptor()
    {
        return $this->EstadoReceptor;
    }
    /**
     * Set EstadoReceptor value
     * @param string $estadoReceptor
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEResultadoEnvioCFEOutV4_Respuesta
     */
    public function setEstadoReceptor($estadoReceptor = null)
    {
        // validation for constraint: string
        if (!is_null($estadoReceptor) && !is_string($estadoReceptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estadoReceptor, true), gettype($estadoReceptor)), __LINE__);
        }
        $this->EstadoReceptor = $estadoReceptor;
        return $this;
    }
    /**
     * Get ProximaConsulta value
     * @return string|null
     */
    public function getProximaConsulta()
    {
        return $this->ProximaConsulta;
    }
    /**
     * Set ProximaConsulta value
     * @param string $proximaConsulta
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEResultadoEnvioCFEOutV4_Respuesta
     */
    public function setProximaConsulta($proximaConsulta = null)
    {
        // validation for constraint: string
        if (!is_null($proximaConsulta) && !is_string($proximaConsulta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($proximaConsulta, true), gettype($proximaConsulta)), __LINE__);
        }
        $this->ProximaConsulta = $proximaConsulta;
        return $this;
    }
    /**
     * Get CAE value
     * @return \App\Soap\StructType\SDTWSCFEV1CAEData|null
     */
    public function getCAE()
    {
        return $this->CAE;
    }
    /**
     * Set CAE value
     * @param \App\Soap\StructType\SDTWSCFEV1CAEData $cAE
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEResultadoEnvioCFEOutV4_Respuesta
     */
    public function setCAE(\App\Soap\StructType\SDTWSCFEV1CAEData $cAE = null)
    {
        $this->CAE = $cAE;
        return $this;
    }
    /**
     * Get Cobranza value
     * @return \App\Soap\StructType\SDTWSCFECobranzaDataV1|null
     */
    public function getCobranza()
    {
        return $this->Cobranza;
    }
    /**
     * Set Cobranza value
     * @param \App\Soap\StructType\SDTWSCFECobranzaDataV1 $cobranza
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEResultadoEnvioCFEOutV4_Respuesta
     */
    public function setCobranza(\App\Soap\StructType\SDTWSCFECobranzaDataV1 $cobranza = null)
    {
        $this->Cobranza = $cobranza;
        return $this;
    }
}
