<?php

namespace App\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * eFactura.WebServices.SDTWSCFEConsultarCFEsRecibidosOutV1.Item StructType
 * @subpackage Structs
 */
class EFactura_WebServices_SDTWSCFEConsultarCFEsRecibidosOutV1_Item extends AbstractStructBase
{
    /**
     * The RUT
     * @var string
     */
    public $RUT;
    /**
     * The DenominacionSocial
     * @var string
     */
    public $DenominacionSocial;
    /**
     * The EmisorCFETipo
     * @var string
     */
    public $EmisorCFETipo;
    /**
     * The Serie
     * @var string
     */
    public $Serie;
    /**
     * The Numero
     * @var int
     */
    public $Numero;
    /**
     * The EstadoLocal
     * @var string
     */
    public $EstadoLocal;
    /**
     * The EstadoDGI
     * @var string
     */
    public $EstadoDGI;
    /**
     * The EstadoReceptor
     * @var string
     */
    public $EstadoReceptor;
    /**
     * The FechaEmision
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FechaEmision;
    /**
     * The FechaVencimiento
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FechaVencimiento;
    /**
     * The Moneda
     * @var string
     */
    public $Moneda;
    /**
     * The TipoCambio
     * @var float
     */
    public $TipoCambio;
    /**
     * The MontoAPagar
     * @var float
     */
    public $MontoAPagar;
    /**
     * Constructor method for
     * eFactura.WebServices.SDTWSCFEConsultarCFEsRecibidosOutV1.Item
     * @uses EFactura_WebServices_SDTWSCFEConsultarCFEsRecibidosOutV1_Item::setRUT()
     * @uses EFactura_WebServices_SDTWSCFEConsultarCFEsRecibidosOutV1_Item::setDenominacionSocial()
     * @uses EFactura_WebServices_SDTWSCFEConsultarCFEsRecibidosOutV1_Item::setEmisorCFETipo()
     * @uses EFactura_WebServices_SDTWSCFEConsultarCFEsRecibidosOutV1_Item::setSerie()
     * @uses EFactura_WebServices_SDTWSCFEConsultarCFEsRecibidosOutV1_Item::setNumero()
     * @uses EFactura_WebServices_SDTWSCFEConsultarCFEsRecibidosOutV1_Item::setEstadoLocal()
     * @uses EFactura_WebServices_SDTWSCFEConsultarCFEsRecibidosOutV1_Item::setEstadoDGI()
     * @uses EFactura_WebServices_SDTWSCFEConsultarCFEsRecibidosOutV1_Item::setEstadoReceptor()
     * @uses EFactura_WebServices_SDTWSCFEConsultarCFEsRecibidosOutV1_Item::setFechaEmision()
     * @uses EFactura_WebServices_SDTWSCFEConsultarCFEsRecibidosOutV1_Item::setFechaVencimiento()
     * @uses EFactura_WebServices_SDTWSCFEConsultarCFEsRecibidosOutV1_Item::setMoneda()
     * @uses EFactura_WebServices_SDTWSCFEConsultarCFEsRecibidosOutV1_Item::setTipoCambio()
     * @uses EFactura_WebServices_SDTWSCFEConsultarCFEsRecibidosOutV1_Item::setMontoAPagar()
     * @param string $rUT
     * @param string $denominacionSocial
     * @param string $emisorCFETipo
     * @param string $serie
     * @param int $numero
     * @param string $estadoLocal
     * @param string $estadoDGI
     * @param string $estadoReceptor
     * @param string $fechaEmision
     * @param string $fechaVencimiento
     * @param string $moneda
     * @param float $tipoCambio
     * @param float $montoAPagar
     */
    public function __construct($rUT = null, $denominacionSocial = null, $emisorCFETipo = null, $serie = null, $numero = null, $estadoLocal = null, $estadoDGI = null, $estadoReceptor = null, $fechaEmision = null, $fechaVencimiento = null, $moneda = null, $tipoCambio = null, $montoAPagar = null)
    {
        $this
            ->setRUT($rUT)
            ->setDenominacionSocial($denominacionSocial)
            ->setEmisorCFETipo($emisorCFETipo)
            ->setSerie($serie)
            ->setNumero($numero)
            ->setEstadoLocal($estadoLocal)
            ->setEstadoDGI($estadoDGI)
            ->setEstadoReceptor($estadoReceptor)
            ->setFechaEmision($fechaEmision)
            ->setFechaVencimiento($fechaVencimiento)
            ->setMoneda($moneda)
            ->setTipoCambio($tipoCambio)
            ->setMontoAPagar($montoAPagar);
    }
    /**
     * Get RUT value
     * @return string|null
     */
    public function getRUT()
    {
        return $this->RUT;
    }
    /**
     * Set RUT value
     * @param string $rUT
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEConsultarCFEsRecibidosOutV1_Item
     */
    public function setRUT($rUT = null)
    {
        // validation for constraint: string
        if (!is_null($rUT) && !is_string($rUT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rUT, true), gettype($rUT)), __LINE__);
        }
        $this->RUT = $rUT;
        return $this;
    }
    /**
     * Get DenominacionSocial value
     * @return string|null
     */
    public function getDenominacionSocial()
    {
        return $this->DenominacionSocial;
    }
    /**
     * Set DenominacionSocial value
     * @param string $denominacionSocial
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEConsultarCFEsRecibidosOutV1_Item
     */
    public function setDenominacionSocial($denominacionSocial = null)
    {
        // validation for constraint: string
        if (!is_null($denominacionSocial) && !is_string($denominacionSocial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($denominacionSocial, true), gettype($denominacionSocial)), __LINE__);
        }
        $this->DenominacionSocial = $denominacionSocial;
        return $this;
    }
    /**
     * Get EmisorCFETipo value
     * @return string|null
     */
    public function getEmisorCFETipo()
    {
        return $this->EmisorCFETipo;
    }
    /**
     * Set EmisorCFETipo value
     * @param string $emisorCFETipo
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEConsultarCFEsRecibidosOutV1_Item
     */
    public function setEmisorCFETipo($emisorCFETipo = null)
    {
        // validation for constraint: string
        if (!is_null($emisorCFETipo) && !is_string($emisorCFETipo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emisorCFETipo, true), gettype($emisorCFETipo)), __LINE__);
        }
        $this->EmisorCFETipo = $emisorCFETipo;
        return $this;
    }
    /**
     * Get Serie value
     * @return string|null
     */
    public function getSerie()
    {
        return $this->Serie;
    }
    /**
     * Set Serie value
     * @param string $serie
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEConsultarCFEsRecibidosOutV1_Item
     */
    public function setSerie($serie = null)
    {
        // validation for constraint: string
        if (!is_null($serie) && !is_string($serie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serie, true), gettype($serie)), __LINE__);
        }
        $this->Serie = $serie;
        return $this;
    }
    /**
     * Get Numero value
     * @return int|null
     */
    public function getNumero()
    {
        return $this->Numero;
    }
    /**
     * Set Numero value
     * @param int $numero
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEConsultarCFEsRecibidosOutV1_Item
     */
    public function setNumero($numero = null)
    {
        // validation for constraint: int
        if (!is_null($numero) && !(is_int($numero) || ctype_digit($numero))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numero, true), gettype($numero)), __LINE__);
        }
        $this->Numero = $numero;
        return $this;
    }
    /**
     * Get EstadoLocal value
     * @return string|null
     */
    public function getEstadoLocal()
    {
        return $this->EstadoLocal;
    }
    /**
     * Set EstadoLocal value
     * @param string $estadoLocal
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEConsultarCFEsRecibidosOutV1_Item
     */
    public function setEstadoLocal($estadoLocal = null)
    {
        // validation for constraint: string
        if (!is_null($estadoLocal) && !is_string($estadoLocal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estadoLocal, true), gettype($estadoLocal)), __LINE__);
        }
        $this->EstadoLocal = $estadoLocal;
        return $this;
    }
    /**
     * Get EstadoDGI value
     * @return string|null
     */
    public function getEstadoDGI()
    {
        return $this->EstadoDGI;
    }
    /**
     * Set EstadoDGI value
     * @param string $estadoDGI
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEConsultarCFEsRecibidosOutV1_Item
     */
    public function setEstadoDGI($estadoDGI = null)
    {
        // validation for constraint: string
        if (!is_null($estadoDGI) && !is_string($estadoDGI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estadoDGI, true), gettype($estadoDGI)), __LINE__);
        }
        $this->EstadoDGI = $estadoDGI;
        return $this;
    }
    /**
     * Get EstadoReceptor value
     * @return string|null
     */
    public function getEstadoReceptor()
    {
        return $this->EstadoReceptor;
    }
    /**
     * Set EstadoReceptor value
     * @param string $estadoReceptor
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEConsultarCFEsRecibidosOutV1_Item
     */
    public function setEstadoReceptor($estadoReceptor = null)
    {
        // validation for constraint: string
        if (!is_null($estadoReceptor) && !is_string($estadoReceptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estadoReceptor, true), gettype($estadoReceptor)), __LINE__);
        }
        $this->EstadoReceptor = $estadoReceptor;
        return $this;
    }
    /**
     * Get FechaEmision value
     * @return string|null
     */
    public function getFechaEmision()
    {
        return $this->FechaEmision;
    }
    /**
     * Set FechaEmision value
     * @param string $fechaEmision
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEConsultarCFEsRecibidosOutV1_Item
     */
    public function setFechaEmision($fechaEmision = null)
    {
        // validation for constraint: string
        if (!is_null($fechaEmision) && !is_string($fechaEmision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaEmision, true), gettype($fechaEmision)), __LINE__);
        }
        $this->FechaEmision = $fechaEmision;
        return $this;
    }
    /**
     * Get FechaVencimiento value
     * @return string|null
     */
    public function getFechaVencimiento()
    {
        return $this->FechaVencimiento;
    }
    /**
     * Set FechaVencimiento value
     * @param string $fechaVencimiento
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEConsultarCFEsRecibidosOutV1_Item
     */
    public function setFechaVencimiento($fechaVencimiento = null)
    {
        // validation for constraint: string
        if (!is_null($fechaVencimiento) && !is_string($fechaVencimiento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaVencimiento, true), gettype($fechaVencimiento)), __LINE__);
        }
        $this->FechaVencimiento = $fechaVencimiento;
        return $this;
    }
    /**
     * Get Moneda value
     * @return string|null
     */
    public function getMoneda()
    {
        return $this->Moneda;
    }
    /**
     * Set Moneda value
     * @param string $moneda
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEConsultarCFEsRecibidosOutV1_Item
     */
    public function setMoneda($moneda = null)
    {
        // validation for constraint: string
        if (!is_null($moneda) && !is_string($moneda)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($moneda, true), gettype($moneda)), __LINE__);
        }
        $this->Moneda = $moneda;
        return $this;
    }
    /**
     * Get TipoCambio value
     * @return float|null
     */
    public function getTipoCambio()
    {
        return $this->TipoCambio;
    }
    /**
     * Set TipoCambio value
     * @param float $tipoCambio
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEConsultarCFEsRecibidosOutV1_Item
     */
    public function setTipoCambio($tipoCambio = null)
    {
        // validation for constraint: float
        if (!is_null($tipoCambio) && !(is_float($tipoCambio) || is_numeric($tipoCambio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tipoCambio, true), gettype($tipoCambio)), __LINE__);
        }
        $this->TipoCambio = $tipoCambio;
        return $this;
    }
    /**
     * Get MontoAPagar value
     * @return float|null
     */
    public function getMontoAPagar()
    {
        return $this->MontoAPagar;
    }
    /**
     * Set MontoAPagar value
     * @param float $montoAPagar
     * @return \App\Soap\StructType\EFactura_WebServices_SDTWSCFEConsultarCFEsRecibidosOutV1_Item
     */
    public function setMontoAPagar($montoAPagar = null)
    {
        // validation for constraint: float
        if (!is_null($montoAPagar) && !(is_float($montoAPagar) || is_numeric($montoAPagar))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($montoAPagar, true), gettype($montoAPagar)), __LINE__);
        }
        $this->MontoAPagar = $montoAPagar;
        return $this;
    }
}
