<?php

namespace App\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * eFactura.WebServices.SDTCFEV4.TotalesRetencionesPercepcionesItem StructType
 * @subpackage Structs
 */
class EFactura_WebServices_SDTCFEV4_TotalesRetencionesPercepcionesItem extends AbstractStructBase
{
    /**
     * The Codigo
     * @var string
     */
    public $Codigo;
    /**
     * The Descripcion
     * @var string
     */
    public $Descripcion;
    /**
     * The Valor
     * @var float
     */
    public $Valor;
    /**
     * Constructor method for
     * eFactura.WebServices.SDTCFEV4.TotalesRetencionesPercepcionesItem
     * @uses EFactura_WebServices_SDTCFEV4_TotalesRetencionesPercepcionesItem::setCodigo()
     * @uses EFactura_WebServices_SDTCFEV4_TotalesRetencionesPercepcionesItem::setDescripcion()
     * @uses EFactura_WebServices_SDTCFEV4_TotalesRetencionesPercepcionesItem::setValor()
     * @param string $codigo
     * @param string $descripcion
     * @param float $valor
     */
    public function __construct($codigo = null, $descripcion = null, $valor = null)
    {
        $this
            ->setCodigo($codigo)
            ->setDescripcion($descripcion)
            ->setValor($valor);
    }
    /**
     * Get Codigo value
     * @return string|null
     */
    public function getCodigo()
    {
        return $this->Codigo;
    }
    /**
     * Set Codigo value
     * @param string $codigo
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_TotalesRetencionesPercepcionesItem
     */
    public function setCodigo($codigo = null)
    {
        // validation for constraint: string
        if (!is_null($codigo) && !is_string($codigo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigo, true), gettype($codigo)), __LINE__);
        }
        $this->Codigo = $codigo;
        return $this;
    }
    /**
     * Get Descripcion value
     * @return string|null
     */
    public function getDescripcion()
    {
        return $this->Descripcion;
    }
    /**
     * Set Descripcion value
     * @param string $descripcion
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_TotalesRetencionesPercepcionesItem
     */
    public function setDescripcion($descripcion = null)
    {
        // validation for constraint: string
        if (!is_null($descripcion) && !is_string($descripcion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descripcion, true), gettype($descripcion)), __LINE__);
        }
        $this->Descripcion = $descripcion;
        return $this;
    }
    /**
     * Get Valor value
     * @return float|null
     */
    public function getValor()
    {
        return $this->Valor;
    }
    /**
     * Set Valor value
     * @param float $valor
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_TotalesRetencionesPercepcionesItem
     */
    public function setValor($valor = null)
    {
        // validation for constraint: float
        if (!is_null($valor) && !(is_float($valor) || is_numeric($valor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valor, true), gettype($valor)), __LINE__);
        }
        $this->Valor = $valor;
        return $this;
    }
}
