<?php

namespace App\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for eFactura.WebServices.SDTCFEV4.Totales StructType
 * @subpackage Structs
 */
class EFactura_WebServices_SDTCFEV4_Totales extends AbstractStructBase
{
    /**
     * The Moneda
     * @var string
     */
    public $Moneda;
    /**
     * The TipoCambio
     * @var float
     */
    public $TipoCambio;
    /**
     * The MontoNoGravado
     * @var float
     */
    public $MontoNoGravado;
    /**
     * The MontoExportado
     * @var float
     */
    public $MontoExportado;
    /**
     * The MontoImpuestoPercibido
     * @var float
     */
    public $MontoImpuestoPercibido;
    /**
     * The MontoIVAEnSuspenso
     * @var float
     */
    public $MontoIVAEnSuspenso;
    /**
     * The MontoNetoConIVATasaMinima
     * @var float
     */
    public $MontoNetoConIVATasaMinima;
    /**
     * The MontoNetoConIVATasaBasica
     * @var float
     */
    public $MontoNetoConIVATasaBasica;
    /**
     * The MontoNetoConIVAOtraTasa
     * @var float
     */
    public $MontoNetoConIVAOtraTasa;
    /**
     * The MontoIVAMinimo
     * @var float
     */
    public $MontoIVAMinimo;
    /**
     * The TasaIVAMinimo
     * @var float
     */
    public $TasaIVAMinimo;
    /**
     * The MontoIVABasico
     * @var float
     */
    public $MontoIVABasico;
    /**
     * The TasaIVABasico
     * @var float
     */
    public $TasaIVABasico;
    /**
     * The MontoIVAOtraTasa
     * @var float
     */
    public $MontoIVAOtraTasa;
    /**
     * The MontoTotal
     * @var float
     */
    public $MontoTotal;
    /**
     * The MontoRetenidoPercibido
     * @var float
     */
    public $MontoRetenidoPercibido;
    /**
     * The CantidadLineasDetalle
     * @var int
     */
    public $CantidadLineasDetalle;
    /**
     * The MontoNoFacturable
     * @var float
     */
    public $MontoNoFacturable;
    /**
     * The MontoAPagar
     * @var float
     */
    public $MontoAPagar;
    /**
     * The MontoCreditosFiscales
     * @var float
     */
    public $MontoCreditosFiscales;
    /**
     * Constructor method for eFactura.WebServices.SDTCFEV4.Totales
     * @uses EFactura_WebServices_SDTCFEV4_Totales::setMoneda()
     * @uses EFactura_WebServices_SDTCFEV4_Totales::setTipoCambio()
     * @uses EFactura_WebServices_SDTCFEV4_Totales::setMontoNoGravado()
     * @uses EFactura_WebServices_SDTCFEV4_Totales::setMontoExportado()
     * @uses EFactura_WebServices_SDTCFEV4_Totales::setMontoImpuestoPercibido()
     * @uses EFactura_WebServices_SDTCFEV4_Totales::setMontoIVAEnSuspenso()
     * @uses EFactura_WebServices_SDTCFEV4_Totales::setMontoNetoConIVATasaMinima()
     * @uses EFactura_WebServices_SDTCFEV4_Totales::setMontoNetoConIVATasaBasica()
     * @uses EFactura_WebServices_SDTCFEV4_Totales::setMontoNetoConIVAOtraTasa()
     * @uses EFactura_WebServices_SDTCFEV4_Totales::setMontoIVAMinimo()
     * @uses EFactura_WebServices_SDTCFEV4_Totales::setTasaIVAMinimo()
     * @uses EFactura_WebServices_SDTCFEV4_Totales::setMontoIVABasico()
     * @uses EFactura_WebServices_SDTCFEV4_Totales::setTasaIVABasico()
     * @uses EFactura_WebServices_SDTCFEV4_Totales::setMontoIVAOtraTasa()
     * @uses EFactura_WebServices_SDTCFEV4_Totales::setMontoTotal()
     * @uses EFactura_WebServices_SDTCFEV4_Totales::setMontoRetenidoPercibido()
     * @uses EFactura_WebServices_SDTCFEV4_Totales::setCantidadLineasDetalle()
     * @uses EFactura_WebServices_SDTCFEV4_Totales::setMontoNoFacturable()
     * @uses EFactura_WebServices_SDTCFEV4_Totales::setMontoAPagar()
     * @uses EFactura_WebServices_SDTCFEV4_Totales::setMontoCreditosFiscales()
     * @param string $moneda
     * @param float $tipoCambio
     * @param float $montoNoGravado
     * @param float $montoExportado
     * @param float $montoImpuestoPercibido
     * @param float $montoIVAEnSuspenso
     * @param float $montoNetoConIVATasaMinima
     * @param float $montoNetoConIVATasaBasica
     * @param float $montoNetoConIVAOtraTasa
     * @param float $montoIVAMinimo
     * @param float $tasaIVAMinimo
     * @param float $montoIVABasico
     * @param float $tasaIVABasico
     * @param float $montoIVAOtraTasa
     * @param float $montoTotal
     * @param float $montoRetenidoPercibido
     * @param int $cantidadLineasDetalle
     * @param float $montoNoFacturable
     * @param float $montoAPagar
     * @param float $montoCreditosFiscales
     */
    public function __construct($moneda = null, $tipoCambio = null, $montoNoGravado = null, $montoExportado = null, $montoImpuestoPercibido = null, $montoIVAEnSuspenso = null, $montoNetoConIVATasaMinima = null, $montoNetoConIVATasaBasica = null, $montoNetoConIVAOtraTasa = null, $montoIVAMinimo = null, $tasaIVAMinimo = null, $montoIVABasico = null, $tasaIVABasico = null, $montoIVAOtraTasa = null, $montoTotal = null, $montoRetenidoPercibido = null, $cantidadLineasDetalle = null, $montoNoFacturable = null, $montoAPagar = null, $montoCreditosFiscales = null)
    {
        $this
            ->setMoneda($moneda)
            ->setTipoCambio($tipoCambio)
            ->setMontoNoGravado($montoNoGravado)
            ->setMontoExportado($montoExportado)
            ->setMontoImpuestoPercibido($montoImpuestoPercibido)
            ->setMontoIVAEnSuspenso($montoIVAEnSuspenso)
            ->setMontoNetoConIVATasaMinima($montoNetoConIVATasaMinima)
            ->setMontoNetoConIVATasaBasica($montoNetoConIVATasaBasica)
            ->setMontoNetoConIVAOtraTasa($montoNetoConIVAOtraTasa)
            ->setMontoIVAMinimo($montoIVAMinimo)
            ->setTasaIVAMinimo($tasaIVAMinimo)
            ->setMontoIVABasico($montoIVABasico)
            ->setTasaIVABasico($tasaIVABasico)
            ->setMontoIVAOtraTasa($montoIVAOtraTasa)
            ->setMontoTotal($montoTotal)
            ->setMontoRetenidoPercibido($montoRetenidoPercibido)
            ->setCantidadLineasDetalle($cantidadLineasDetalle)
            ->setMontoNoFacturable($montoNoFacturable)
            ->setMontoAPagar($montoAPagar)
            ->setMontoCreditosFiscales($montoCreditosFiscales);
    }
    /**
     * Get Moneda value
     * @return string|null
     */
    public function getMoneda()
    {
        return $this->Moneda;
    }
    /**
     * Set Moneda value
     * @param string $moneda
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Totales
     */
    public function setMoneda($moneda = null)
    {
        // validation for constraint: string
        if (!is_null($moneda) && !is_string($moneda)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($moneda, true), gettype($moneda)), __LINE__);
        }
        $this->Moneda = $moneda;
        return $this;
    }
    /**
     * Get TipoCambio value
     * @return float|null
     */
    public function getTipoCambio()
    {
        return $this->TipoCambio;
    }
    /**
     * Set TipoCambio value
     * @param float $tipoCambio
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Totales
     */
    public function setTipoCambio($tipoCambio = null)
    {
        // validation for constraint: float
        if (!is_null($tipoCambio) && !(is_float($tipoCambio) || is_numeric($tipoCambio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tipoCambio, true), gettype($tipoCambio)), __LINE__);
        }
        $this->TipoCambio = $tipoCambio;
        return $this;
    }
    /**
     * Get MontoNoGravado value
     * @return float|null
     */
    public function getMontoNoGravado()
    {
        return $this->MontoNoGravado;
    }
    /**
     * Set MontoNoGravado value
     * @param float $montoNoGravado
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Totales
     */
    public function setMontoNoGravado($montoNoGravado = null)
    {
        // validation for constraint: float
        if (!is_null($montoNoGravado) && !(is_float($montoNoGravado) || is_numeric($montoNoGravado))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($montoNoGravado, true), gettype($montoNoGravado)), __LINE__);
        }
        $this->MontoNoGravado = $montoNoGravado;
        return $this;
    }
    /**
     * Get MontoExportado value
     * @return float|null
     */
    public function getMontoExportado()
    {
        return $this->MontoExportado;
    }
    /**
     * Set MontoExportado value
     * @param float $montoExportado
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Totales
     */
    public function setMontoExportado($montoExportado = null)
    {
        // validation for constraint: float
        if (!is_null($montoExportado) && !(is_float($montoExportado) || is_numeric($montoExportado))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($montoExportado, true), gettype($montoExportado)), __LINE__);
        }
        $this->MontoExportado = $montoExportado;
        return $this;
    }
    /**
     * Get MontoImpuestoPercibido value
     * @return float|null
     */
    public function getMontoImpuestoPercibido()
    {
        return $this->MontoImpuestoPercibido;
    }
    /**
     * Set MontoImpuestoPercibido value
     * @param float $montoImpuestoPercibido
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Totales
     */
    public function setMontoImpuestoPercibido($montoImpuestoPercibido = null)
    {
        // validation for constraint: float
        if (!is_null($montoImpuestoPercibido) && !(is_float($montoImpuestoPercibido) || is_numeric($montoImpuestoPercibido))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($montoImpuestoPercibido, true), gettype($montoImpuestoPercibido)), __LINE__);
        }
        $this->MontoImpuestoPercibido = $montoImpuestoPercibido;
        return $this;
    }
    /**
     * Get MontoIVAEnSuspenso value
     * @return float|null
     */
    public function getMontoIVAEnSuspenso()
    {
        return $this->MontoIVAEnSuspenso;
    }
    /**
     * Set MontoIVAEnSuspenso value
     * @param float $montoIVAEnSuspenso
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Totales
     */
    public function setMontoIVAEnSuspenso($montoIVAEnSuspenso = null)
    {
        // validation for constraint: float
        if (!is_null($montoIVAEnSuspenso) && !(is_float($montoIVAEnSuspenso) || is_numeric($montoIVAEnSuspenso))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($montoIVAEnSuspenso, true), gettype($montoIVAEnSuspenso)), __LINE__);
        }
        $this->MontoIVAEnSuspenso = $montoIVAEnSuspenso;
        return $this;
    }
    /**
     * Get MontoNetoConIVATasaMinima value
     * @return float|null
     */
    public function getMontoNetoConIVATasaMinima()
    {
        return $this->MontoNetoConIVATasaMinima;
    }
    /**
     * Set MontoNetoConIVATasaMinima value
     * @param float $montoNetoConIVATasaMinima
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Totales
     */
    public function setMontoNetoConIVATasaMinima($montoNetoConIVATasaMinima = null)
    {
        // validation for constraint: float
        if (!is_null($montoNetoConIVATasaMinima) && !(is_float($montoNetoConIVATasaMinima) || is_numeric($montoNetoConIVATasaMinima))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($montoNetoConIVATasaMinima, true), gettype($montoNetoConIVATasaMinima)), __LINE__);
        }
        $this->MontoNetoConIVATasaMinima = $montoNetoConIVATasaMinima;
        return $this;
    }
    /**
     * Get MontoNetoConIVATasaBasica value
     * @return float|null
     */
    public function getMontoNetoConIVATasaBasica()
    {
        return $this->MontoNetoConIVATasaBasica;
    }
    /**
     * Set MontoNetoConIVATasaBasica value
     * @param float $montoNetoConIVATasaBasica
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Totales
     */
    public function setMontoNetoConIVATasaBasica($montoNetoConIVATasaBasica = null)
    {
        // validation for constraint: float
        if (!is_null($montoNetoConIVATasaBasica) && !(is_float($montoNetoConIVATasaBasica) || is_numeric($montoNetoConIVATasaBasica))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($montoNetoConIVATasaBasica, true), gettype($montoNetoConIVATasaBasica)), __LINE__);
        }
        $this->MontoNetoConIVATasaBasica = $montoNetoConIVATasaBasica;
        return $this;
    }
    /**
     * Get MontoNetoConIVAOtraTasa value
     * @return float|null
     */
    public function getMontoNetoConIVAOtraTasa()
    {
        return $this->MontoNetoConIVAOtraTasa;
    }
    /**
     * Set MontoNetoConIVAOtraTasa value
     * @param float $montoNetoConIVAOtraTasa
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Totales
     */
    public function setMontoNetoConIVAOtraTasa($montoNetoConIVAOtraTasa = null)
    {
        // validation for constraint: float
        if (!is_null($montoNetoConIVAOtraTasa) && !(is_float($montoNetoConIVAOtraTasa) || is_numeric($montoNetoConIVAOtraTasa))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($montoNetoConIVAOtraTasa, true), gettype($montoNetoConIVAOtraTasa)), __LINE__);
        }
        $this->MontoNetoConIVAOtraTasa = $montoNetoConIVAOtraTasa;
        return $this;
    }
    /**
     * Get MontoIVAMinimo value
     * @return float|null
     */
    public function getMontoIVAMinimo()
    {
        return $this->MontoIVAMinimo;
    }
    /**
     * Set MontoIVAMinimo value
     * @param float $montoIVAMinimo
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Totales
     */
    public function setMontoIVAMinimo($montoIVAMinimo = null)
    {
        // validation for constraint: float
        if (!is_null($montoIVAMinimo) && !(is_float($montoIVAMinimo) || is_numeric($montoIVAMinimo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($montoIVAMinimo, true), gettype($montoIVAMinimo)), __LINE__);
        }
        $this->MontoIVAMinimo = $montoIVAMinimo;
        return $this;
    }
    /**
     * Get TasaIVAMinimo value
     * @return float|null
     */
    public function getTasaIVAMinimo()
    {
        return $this->TasaIVAMinimo;
    }
    /**
     * Set TasaIVAMinimo value
     * @param float $tasaIVAMinimo
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Totales
     */
    public function setTasaIVAMinimo($tasaIVAMinimo = null)
    {
        // validation for constraint: float
        if (!is_null($tasaIVAMinimo) && !(is_float($tasaIVAMinimo) || is_numeric($tasaIVAMinimo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tasaIVAMinimo, true), gettype($tasaIVAMinimo)), __LINE__);
        }
        $this->TasaIVAMinimo = $tasaIVAMinimo;
        return $this;
    }
    /**
     * Get MontoIVABasico value
     * @return float|null
     */
    public function getMontoIVABasico()
    {
        return $this->MontoIVABasico;
    }
    /**
     * Set MontoIVABasico value
     * @param float $montoIVABasico
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Totales
     */
    public function setMontoIVABasico($montoIVABasico = null)
    {
        // validation for constraint: float
        if (!is_null($montoIVABasico) && !(is_float($montoIVABasico) || is_numeric($montoIVABasico))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($montoIVABasico, true), gettype($montoIVABasico)), __LINE__);
        }
        $this->MontoIVABasico = $montoIVABasico;
        return $this;
    }
    /**
     * Get TasaIVABasico value
     * @return float|null
     */
    public function getTasaIVABasico()
    {
        return $this->TasaIVABasico;
    }
    /**
     * Set TasaIVABasico value
     * @param float $tasaIVABasico
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Totales
     */
    public function setTasaIVABasico($tasaIVABasico = null)
    {
        // validation for constraint: float
        if (!is_null($tasaIVABasico) && !(is_float($tasaIVABasico) || is_numeric($tasaIVABasico))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tasaIVABasico, true), gettype($tasaIVABasico)), __LINE__);
        }
        $this->TasaIVABasico = $tasaIVABasico;
        return $this;
    }
    /**
     * Get MontoIVAOtraTasa value
     * @return float|null
     */
    public function getMontoIVAOtraTasa()
    {
        return $this->MontoIVAOtraTasa;
    }
    /**
     * Set MontoIVAOtraTasa value
     * @param float $montoIVAOtraTasa
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Totales
     */
    public function setMontoIVAOtraTasa($montoIVAOtraTasa = null)
    {
        // validation for constraint: float
        if (!is_null($montoIVAOtraTasa) && !(is_float($montoIVAOtraTasa) || is_numeric($montoIVAOtraTasa))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($montoIVAOtraTasa, true), gettype($montoIVAOtraTasa)), __LINE__);
        }
        $this->MontoIVAOtraTasa = $montoIVAOtraTasa;
        return $this;
    }
    /**
     * Get MontoTotal value
     * @return float|null
     */
    public function getMontoTotal()
    {
        return $this->MontoTotal;
    }
    /**
     * Set MontoTotal value
     * @param float $montoTotal
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Totales
     */
    public function setMontoTotal($montoTotal = null)
    {
        // validation for constraint: float
        if (!is_null($montoTotal) && !(is_float($montoTotal) || is_numeric($montoTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($montoTotal, true), gettype($montoTotal)), __LINE__);
        }
        $this->MontoTotal = $montoTotal;
        return $this;
    }
    /**
     * Get MontoRetenidoPercibido value
     * @return float|null
     */
    public function getMontoRetenidoPercibido()
    {
        return $this->MontoRetenidoPercibido;
    }
    /**
     * Set MontoRetenidoPercibido value
     * @param float $montoRetenidoPercibido
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Totales
     */
    public function setMontoRetenidoPercibido($montoRetenidoPercibido = null)
    {
        // validation for constraint: float
        if (!is_null($montoRetenidoPercibido) && !(is_float($montoRetenidoPercibido) || is_numeric($montoRetenidoPercibido))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($montoRetenidoPercibido, true), gettype($montoRetenidoPercibido)), __LINE__);
        }
        $this->MontoRetenidoPercibido = $montoRetenidoPercibido;
        return $this;
    }
    /**
     * Get CantidadLineasDetalle value
     * @return int|null
     */
    public function getCantidadLineasDetalle()
    {
        return $this->CantidadLineasDetalle;
    }
    /**
     * Set CantidadLineasDetalle value
     * @param int $cantidadLineasDetalle
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Totales
     */
    public function setCantidadLineasDetalle($cantidadLineasDetalle = null)
    {
        // validation for constraint: int
        if (!is_null($cantidadLineasDetalle) && !(is_int($cantidadLineasDetalle) || ctype_digit($cantidadLineasDetalle))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cantidadLineasDetalle, true), gettype($cantidadLineasDetalle)), __LINE__);
        }
        $this->CantidadLineasDetalle = $cantidadLineasDetalle;
        return $this;
    }
    /**
     * Get MontoNoFacturable value
     * @return float|null
     */
    public function getMontoNoFacturable()
    {
        return $this->MontoNoFacturable;
    }
    /**
     * Set MontoNoFacturable value
     * @param float $montoNoFacturable
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Totales
     */
    public function setMontoNoFacturable($montoNoFacturable = null)
    {
        // validation for constraint: float
        if (!is_null($montoNoFacturable) && !(is_float($montoNoFacturable) || is_numeric($montoNoFacturable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($montoNoFacturable, true), gettype($montoNoFacturable)), __LINE__);
        }
        $this->MontoNoFacturable = $montoNoFacturable;
        return $this;
    }
    /**
     * Get MontoAPagar value
     * @return float|null
     */
    public function getMontoAPagar()
    {
        return $this->MontoAPagar;
    }
    /**
     * Set MontoAPagar value
     * @param float $montoAPagar
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Totales
     */
    public function setMontoAPagar($montoAPagar = null)
    {
        // validation for constraint: float
        if (!is_null($montoAPagar) && !(is_float($montoAPagar) || is_numeric($montoAPagar))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($montoAPagar, true), gettype($montoAPagar)), __LINE__);
        }
        $this->MontoAPagar = $montoAPagar;
        return $this;
    }
    /**
     * Get MontoCreditosFiscales value
     * @return float|null
     */
    public function getMontoCreditosFiscales()
    {
        return $this->MontoCreditosFiscales;
    }
    /**
     * Set MontoCreditosFiscales value
     * @param float $montoCreditosFiscales
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV4_Totales
     */
    public function setMontoCreditosFiscales($montoCreditosFiscales = null)
    {
        // validation for constraint: float
        if (!is_null($montoCreditosFiscales) && !(is_float($montoCreditosFiscales) || is_numeric($montoCreditosFiscales))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($montoCreditosFiscales, true), gettype($montoCreditosFiscales)), __LINE__);
        }
        $this->MontoCreditosFiscales = $montoCreditosFiscales;
        return $this;
    }
}
