<?php

namespace App\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for eFactura.WebServices.SDTCFEV2.DescuentosRecargosGlobalItem
 * StructType
 * @subpackage Structs
 */
class EFactura_WebServices_SDTCFEV2_DescuentosRecargosGlobalItem extends AbstractStructBase
{
    /**
     * The NumeroDeLinea
     * @var string
     */
    public $NumeroDeLinea;
    /**
     * The MovimientoTipo
     * @var string
     */
    public $MovimientoTipo;
    /**
     * The Tipo
     * @var int
     */
    public $Tipo;
    /**
     * The Codigo
     * @var int
     */
    public $Codigo;
    /**
     * The Glosa
     * @var string
     */
    public $Glosa;
    /**
     * The Valor
     * @var float
     */
    public $Valor;
    /**
     * The IndicadorFacturacion
     * @var string
     */
    public $IndicadorFacturacion;
    /**
     * Constructor method for
     * eFactura.WebServices.SDTCFEV2.DescuentosRecargosGlobalItem
     * @uses EFactura_WebServices_SDTCFEV2_DescuentosRecargosGlobalItem::setNumeroDeLinea()
     * @uses EFactura_WebServices_SDTCFEV2_DescuentosRecargosGlobalItem::setMovimientoTipo()
     * @uses EFactura_WebServices_SDTCFEV2_DescuentosRecargosGlobalItem::setTipo()
     * @uses EFactura_WebServices_SDTCFEV2_DescuentosRecargosGlobalItem::setCodigo()
     * @uses EFactura_WebServices_SDTCFEV2_DescuentosRecargosGlobalItem::setGlosa()
     * @uses EFactura_WebServices_SDTCFEV2_DescuentosRecargosGlobalItem::setValor()
     * @uses EFactura_WebServices_SDTCFEV2_DescuentosRecargosGlobalItem::setIndicadorFacturacion()
     * @param string $numeroDeLinea
     * @param string $movimientoTipo
     * @param int $tipo
     * @param int $codigo
     * @param string $glosa
     * @param float $valor
     * @param string $indicadorFacturacion
     */
    public function __construct($numeroDeLinea = null, $movimientoTipo = null, $tipo = null, $codigo = null, $glosa = null, $valor = null, $indicadorFacturacion = null)
    {
        $this
            ->setNumeroDeLinea($numeroDeLinea)
            ->setMovimientoTipo($movimientoTipo)
            ->setTipo($tipo)
            ->setCodigo($codigo)
            ->setGlosa($glosa)
            ->setValor($valor)
            ->setIndicadorFacturacion($indicadorFacturacion);
    }
    /**
     * Get NumeroDeLinea value
     * @return string|null
     */
    public function getNumeroDeLinea()
    {
        return $this->NumeroDeLinea;
    }
    /**
     * Set NumeroDeLinea value
     * @param string $numeroDeLinea
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV2_DescuentosRecargosGlobalItem
     */
    public function setNumeroDeLinea($numeroDeLinea = null)
    {
        // validation for constraint: string
        if (!is_null($numeroDeLinea) && !is_string($numeroDeLinea)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroDeLinea, true), gettype($numeroDeLinea)), __LINE__);
        }
        $this->NumeroDeLinea = $numeroDeLinea;
        return $this;
    }
    /**
     * Get MovimientoTipo value
     * @return string|null
     */
    public function getMovimientoTipo()
    {
        return $this->MovimientoTipo;
    }
    /**
     * Set MovimientoTipo value
     * @param string $movimientoTipo
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV2_DescuentosRecargosGlobalItem
     */
    public function setMovimientoTipo($movimientoTipo = null)
    {
        // validation for constraint: string
        if (!is_null($movimientoTipo) && !is_string($movimientoTipo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($movimientoTipo, true), gettype($movimientoTipo)), __LINE__);
        }
        $this->MovimientoTipo = $movimientoTipo;
        return $this;
    }
    /**
     * Get Tipo value
     * @return int|null
     */
    public function getTipo()
    {
        return $this->Tipo;
    }
    /**
     * Set Tipo value
     * @param int $tipo
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV2_DescuentosRecargosGlobalItem
     */
    public function setTipo($tipo = null)
    {
        // validation for constraint: int
        if (!is_null($tipo) && !(is_int($tipo) || ctype_digit($tipo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tipo, true), gettype($tipo)), __LINE__);
        }
        $this->Tipo = $tipo;
        return $this;
    }
    /**
     * Get Codigo value
     * @return int|null
     */
    public function getCodigo()
    {
        return $this->Codigo;
    }
    /**
     * Set Codigo value
     * @param int $codigo
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV2_DescuentosRecargosGlobalItem
     */
    public function setCodigo($codigo = null)
    {
        // validation for constraint: int
        if (!is_null($codigo) && !(is_int($codigo) || ctype_digit($codigo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigo, true), gettype($codigo)), __LINE__);
        }
        $this->Codigo = $codigo;
        return $this;
    }
    /**
     * Get Glosa value
     * @return string|null
     */
    public function getGlosa()
    {
        return $this->Glosa;
    }
    /**
     * Set Glosa value
     * @param string $glosa
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV2_DescuentosRecargosGlobalItem
     */
    public function setGlosa($glosa = null)
    {
        // validation for constraint: string
        if (!is_null($glosa) && !is_string($glosa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($glosa, true), gettype($glosa)), __LINE__);
        }
        $this->Glosa = $glosa;
        return $this;
    }
    /**
     * Get Valor value
     * @return float|null
     */
    public function getValor()
    {
        return $this->Valor;
    }
    /**
     * Set Valor value
     * @param float $valor
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV2_DescuentosRecargosGlobalItem
     */
    public function setValor($valor = null)
    {
        // validation for constraint: float
        if (!is_null($valor) && !(is_float($valor) || is_numeric($valor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valor, true), gettype($valor)), __LINE__);
        }
        $this->Valor = $valor;
        return $this;
    }
    /**
     * Get IndicadorFacturacion value
     * @return string|null
     */
    public function getIndicadorFacturacion()
    {
        return $this->IndicadorFacturacion;
    }
    /**
     * Set IndicadorFacturacion value
     * @param string $indicadorFacturacion
     * @return \App\Soap\StructType\EFactura_WebServices_SDTCFEV2_DescuentosRecargosGlobalItem
     */
    public function setIndicadorFacturacion($indicadorFacturacion = null)
    {
        // validation for constraint: string
        if (!is_null($indicadorFacturacion) && !is_string($indicadorFacturacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($indicadorFacturacion, true), gettype($indicadorFacturacion)), __LINE__);
        }
        $this->IndicadorFacturacion = $indicadorFacturacion;
        return $this;
    }
}
