<?php

namespace App\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for eFactura.Definiciones.SDTCFEInterno.DetalleItem StructType
 * @subpackage Structs
 */
class EFactura_Definiciones_SDTCFEInterno_DetalleItem extends AbstractStructBase
{
    /**
     * The NumeroDeLinea
     * @var int
     */
    public $NumeroDeLinea;
    /**
     * The ItemCodigo
     * @var string
     */
    public $ItemCodigo;
    /**
     * The IndicadorDeFacturacion
     * @var string
     */
    public $IndicadorDeFacturacion;
    /**
     * The IndicadorAgenteResponsable
     * @var string
     */
    public $IndicadorAgenteResponsable;
    /**
     * The Nombre
     * @var string
     */
    public $Nombre;
    /**
     * The DescripcionAdicional
     * @var string
     */
    public $DescripcionAdicional;
    /**
     * The Cantidad
     * @var float
     */
    public $Cantidad;
    /**
     * The UnidadMedida
     * @var string
     */
    public $UnidadMedida;
    /**
     * The PrecioUnitario
     * @var float
     */
    public $PrecioUnitario;
    /**
     * The DescuentoPorcentaje
     * @var float
     */
    public $DescuentoPorcentaje;
    /**
     * The DescuentoMonto
     * @var float
     */
    public $DescuentoMonto;
    /**
     * The RecargoPorcentaje
     * @var float
     */
    public $RecargoPorcentaje;
    /**
     * The RecargoMonto
     * @var float
     */
    public $RecargoMonto;
    /**
     * The MontoTotal
     * @var float
     */
    public $MontoTotal;
    /**
     * The DescuentoGlosa
     * @var string
     */
    public $DescuentoGlosa;
    /**
     * The RecargoGlosa
     * @var string
     */
    public $RecargoGlosa;
    /**
     * The Familia
     * @var string
     */
    public $Familia;
    /**
     * The DescuentoRecargo
     * @var \App\Soap\StructType\DescuentoRecargo
     */
    public $DescuentoRecargo;
    /**
     * The RetencionPercepcion
     * @var \App\Soap\StructType\RetencionPercepcion
     */
    public $RetencionPercepcion;
    /**
     * The CodigosProductoServicio
     * @var \App\Soap\StructType\CodigosProductoServicio
     */
    public $CodigosProductoServicio;
    /**
     * The DatosAdicionales
     * @var \App\Soap\StructType\DatosAdicionales
     */
    public $DatosAdicionales;
    /**
     * Constructor method for eFactura.Definiciones.SDTCFEInterno.DetalleItem
     * @uses EFactura_Definiciones_SDTCFEInterno_DetalleItem::setNumeroDeLinea()
     * @uses EFactura_Definiciones_SDTCFEInterno_DetalleItem::setItemCodigo()
     * @uses EFactura_Definiciones_SDTCFEInterno_DetalleItem::setIndicadorDeFacturacion()
     * @uses EFactura_Definiciones_SDTCFEInterno_DetalleItem::setIndicadorAgenteResponsable()
     * @uses EFactura_Definiciones_SDTCFEInterno_DetalleItem::setNombre()
     * @uses EFactura_Definiciones_SDTCFEInterno_DetalleItem::setDescripcionAdicional()
     * @uses EFactura_Definiciones_SDTCFEInterno_DetalleItem::setCantidad()
     * @uses EFactura_Definiciones_SDTCFEInterno_DetalleItem::setUnidadMedida()
     * @uses EFactura_Definiciones_SDTCFEInterno_DetalleItem::setPrecioUnitario()
     * @uses EFactura_Definiciones_SDTCFEInterno_DetalleItem::setDescuentoPorcentaje()
     * @uses EFactura_Definiciones_SDTCFEInterno_DetalleItem::setDescuentoMonto()
     * @uses EFactura_Definiciones_SDTCFEInterno_DetalleItem::setRecargoPorcentaje()
     * @uses EFactura_Definiciones_SDTCFEInterno_DetalleItem::setRecargoMonto()
     * @uses EFactura_Definiciones_SDTCFEInterno_DetalleItem::setMontoTotal()
     * @uses EFactura_Definiciones_SDTCFEInterno_DetalleItem::setDescuentoGlosa()
     * @uses EFactura_Definiciones_SDTCFEInterno_DetalleItem::setRecargoGlosa()
     * @uses EFactura_Definiciones_SDTCFEInterno_DetalleItem::setFamilia()
     * @uses EFactura_Definiciones_SDTCFEInterno_DetalleItem::setDescuentoRecargo()
     * @uses EFactura_Definiciones_SDTCFEInterno_DetalleItem::setRetencionPercepcion()
     * @uses EFactura_Definiciones_SDTCFEInterno_DetalleItem::setCodigosProductoServicio()
     * @uses EFactura_Definiciones_SDTCFEInterno_DetalleItem::setDatosAdicionales()
     * @param int $numeroDeLinea
     * @param string $itemCodigo
     * @param string $indicadorDeFacturacion
     * @param string $indicadorAgenteResponsable
     * @param string $nombre
     * @param string $descripcionAdicional
     * @param float $cantidad
     * @param string $unidadMedida
     * @param float $precioUnitario
     * @param float $descuentoPorcentaje
     * @param float $descuentoMonto
     * @param float $recargoPorcentaje
     * @param float $recargoMonto
     * @param float $montoTotal
     * @param string $descuentoGlosa
     * @param string $recargoGlosa
     * @param string $familia
     * @param \App\Soap\StructType\DescuentoRecargo $descuentoRecargo
     * @param \App\Soap\StructType\RetencionPercepcion $retencionPercepcion
     * @param \App\Soap\StructType\CodigosProductoServicio $codigosProductoServicio
     * @param \App\Soap\StructType\DatosAdicionales $datosAdicionales
     */
    public function __construct($numeroDeLinea = null, $itemCodigo = null, $indicadorDeFacturacion = null, $indicadorAgenteResponsable = null, $nombre = null, $descripcionAdicional = null, $cantidad = null, $unidadMedida = null, $precioUnitario = null, $descuentoPorcentaje = null, $descuentoMonto = null, $recargoPorcentaje = null, $recargoMonto = null, $montoTotal = null, $descuentoGlosa = null, $recargoGlosa = null, $familia = null, \App\Soap\StructType\DescuentoRecargo $descuentoRecargo = null, \App\Soap\StructType\RetencionPercepcion $retencionPercepcion = null, \App\Soap\StructType\CodigosProductoServicio $codigosProductoServicio = null, \App\Soap\StructType\DatosAdicionales $datosAdicionales = null)
    {
        $this
            ->setNumeroDeLinea($numeroDeLinea)
            ->setItemCodigo($itemCodigo)
            ->setIndicadorDeFacturacion($indicadorDeFacturacion)
            ->setIndicadorAgenteResponsable($indicadorAgenteResponsable)
            ->setNombre($nombre)
            ->setDescripcionAdicional($descripcionAdicional)
            ->setCantidad($cantidad)
            ->setUnidadMedida($unidadMedida)
            ->setPrecioUnitario($precioUnitario)
            ->setDescuentoPorcentaje($descuentoPorcentaje)
            ->setDescuentoMonto($descuentoMonto)
            ->setRecargoPorcentaje($recargoPorcentaje)
            ->setRecargoMonto($recargoMonto)
            ->setMontoTotal($montoTotal)
            ->setDescuentoGlosa($descuentoGlosa)
            ->setRecargoGlosa($recargoGlosa)
            ->setFamilia($familia)
            ->setDescuentoRecargo($descuentoRecargo)
            ->setRetencionPercepcion($retencionPercepcion)
            ->setCodigosProductoServicio($codigosProductoServicio)
            ->setDatosAdicionales($datosAdicionales);
    }
    /**
     * Get NumeroDeLinea value
     * @return int|null
     */
    public function getNumeroDeLinea()
    {
        return $this->NumeroDeLinea;
    }
    /**
     * Set NumeroDeLinea value
     * @param int $numeroDeLinea
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_DetalleItem
     */
    public function setNumeroDeLinea($numeroDeLinea = null)
    {
        // validation for constraint: int
        if (!is_null($numeroDeLinea) && !(is_int($numeroDeLinea) || ctype_digit($numeroDeLinea))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numeroDeLinea, true), gettype($numeroDeLinea)), __LINE__);
        }
        $this->NumeroDeLinea = $numeroDeLinea;
        return $this;
    }
    /**
     * Get ItemCodigo value
     * @return string|null
     */
    public function getItemCodigo()
    {
        return $this->ItemCodigo;
    }
    /**
     * Set ItemCodigo value
     * @param string $itemCodigo
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_DetalleItem
     */
    public function setItemCodigo($itemCodigo = null)
    {
        // validation for constraint: string
        if (!is_null($itemCodigo) && !is_string($itemCodigo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemCodigo, true), gettype($itemCodigo)), __LINE__);
        }
        $this->ItemCodigo = $itemCodigo;
        return $this;
    }
    /**
     * Get IndicadorDeFacturacion value
     * @return string|null
     */
    public function getIndicadorDeFacturacion()
    {
        return $this->IndicadorDeFacturacion;
    }
    /**
     * Set IndicadorDeFacturacion value
     * @param string $indicadorDeFacturacion
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_DetalleItem
     */
    public function setIndicadorDeFacturacion($indicadorDeFacturacion = null)
    {
        // validation for constraint: string
        if (!is_null($indicadorDeFacturacion) && !is_string($indicadorDeFacturacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($indicadorDeFacturacion, true), gettype($indicadorDeFacturacion)), __LINE__);
        }
        $this->IndicadorDeFacturacion = $indicadorDeFacturacion;
        return $this;
    }
    /**
     * Get IndicadorAgenteResponsable value
     * @return string|null
     */
    public function getIndicadorAgenteResponsable()
    {
        return $this->IndicadorAgenteResponsable;
    }
    /**
     * Set IndicadorAgenteResponsable value
     * @param string $indicadorAgenteResponsable
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_DetalleItem
     */
    public function setIndicadorAgenteResponsable($indicadorAgenteResponsable = null)
    {
        // validation for constraint: string
        if (!is_null($indicadorAgenteResponsable) && !is_string($indicadorAgenteResponsable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($indicadorAgenteResponsable, true), gettype($indicadorAgenteResponsable)), __LINE__);
        }
        $this->IndicadorAgenteResponsable = $indicadorAgenteResponsable;
        return $this;
    }
    /**
     * Get Nombre value
     * @return string|null
     */
    public function getNombre()
    {
        return $this->Nombre;
    }
    /**
     * Set Nombre value
     * @param string $nombre
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_DetalleItem
     */
    public function setNombre($nombre = null)
    {
        // validation for constraint: string
        if (!is_null($nombre) && !is_string($nombre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nombre, true), gettype($nombre)), __LINE__);
        }
        $this->Nombre = $nombre;
        return $this;
    }
    /**
     * Get DescripcionAdicional value
     * @return string|null
     */
    public function getDescripcionAdicional()
    {
        return $this->DescripcionAdicional;
    }
    /**
     * Set DescripcionAdicional value
     * @param string $descripcionAdicional
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_DetalleItem
     */
    public function setDescripcionAdicional($descripcionAdicional = null)
    {
        // validation for constraint: string
        if (!is_null($descripcionAdicional) && !is_string($descripcionAdicional)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descripcionAdicional, true), gettype($descripcionAdicional)), __LINE__);
        }
        $this->DescripcionAdicional = $descripcionAdicional;
        return $this;
    }
    /**
     * Get Cantidad value
     * @return float|null
     */
    public function getCantidad()
    {
        return $this->Cantidad;
    }
    /**
     * Set Cantidad value
     * @param float $cantidad
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_DetalleItem
     */
    public function setCantidad($cantidad = null)
    {
        // validation for constraint: float
        if (!is_null($cantidad) && !(is_float($cantidad) || is_numeric($cantidad))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cantidad, true), gettype($cantidad)), __LINE__);
        }
        $this->Cantidad = $cantidad;
        return $this;
    }
    /**
     * Get UnidadMedida value
     * @return string|null
     */
    public function getUnidadMedida()
    {
        return $this->UnidadMedida;
    }
    /**
     * Set UnidadMedida value
     * @param string $unidadMedida
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_DetalleItem
     */
    public function setUnidadMedida($unidadMedida = null)
    {
        // validation for constraint: string
        if (!is_null($unidadMedida) && !is_string($unidadMedida)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unidadMedida, true), gettype($unidadMedida)), __LINE__);
        }
        $this->UnidadMedida = $unidadMedida;
        return $this;
    }
    /**
     * Get PrecioUnitario value
     * @return float|null
     */
    public function getPrecioUnitario()
    {
        return $this->PrecioUnitario;
    }
    /**
     * Set PrecioUnitario value
     * @param float $precioUnitario
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_DetalleItem
     */
    public function setPrecioUnitario($precioUnitario = null)
    {
        // validation for constraint: float
        if (!is_null($precioUnitario) && !(is_float($precioUnitario) || is_numeric($precioUnitario))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($precioUnitario, true), gettype($precioUnitario)), __LINE__);
        }
        $this->PrecioUnitario = $precioUnitario;
        return $this;
    }
    /**
     * Get DescuentoPorcentaje value
     * @return float|null
     */
    public function getDescuentoPorcentaje()
    {
        return $this->DescuentoPorcentaje;
    }
    /**
     * Set DescuentoPorcentaje value
     * @param float $descuentoPorcentaje
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_DetalleItem
     */
    public function setDescuentoPorcentaje($descuentoPorcentaje = null)
    {
        // validation for constraint: float
        if (!is_null($descuentoPorcentaje) && !(is_float($descuentoPorcentaje) || is_numeric($descuentoPorcentaje))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($descuentoPorcentaje, true), gettype($descuentoPorcentaje)), __LINE__);
        }
        $this->DescuentoPorcentaje = $descuentoPorcentaje;
        return $this;
    }
    /**
     * Get DescuentoMonto value
     * @return float|null
     */
    public function getDescuentoMonto()
    {
        return $this->DescuentoMonto;
    }
    /**
     * Set DescuentoMonto value
     * @param float $descuentoMonto
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_DetalleItem
     */
    public function setDescuentoMonto($descuentoMonto = null)
    {
        // validation for constraint: float
        if (!is_null($descuentoMonto) && !(is_float($descuentoMonto) || is_numeric($descuentoMonto))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($descuentoMonto, true), gettype($descuentoMonto)), __LINE__);
        }
        $this->DescuentoMonto = $descuentoMonto;
        return $this;
    }
    /**
     * Get RecargoPorcentaje value
     * @return float|null
     */
    public function getRecargoPorcentaje()
    {
        return $this->RecargoPorcentaje;
    }
    /**
     * Set RecargoPorcentaje value
     * @param float $recargoPorcentaje
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_DetalleItem
     */
    public function setRecargoPorcentaje($recargoPorcentaje = null)
    {
        // validation for constraint: float
        if (!is_null($recargoPorcentaje) && !(is_float($recargoPorcentaje) || is_numeric($recargoPorcentaje))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($recargoPorcentaje, true), gettype($recargoPorcentaje)), __LINE__);
        }
        $this->RecargoPorcentaje = $recargoPorcentaje;
        return $this;
    }
    /**
     * Get RecargoMonto value
     * @return float|null
     */
    public function getRecargoMonto()
    {
        return $this->RecargoMonto;
    }
    /**
     * Set RecargoMonto value
     * @param float $recargoMonto
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_DetalleItem
     */
    public function setRecargoMonto($recargoMonto = null)
    {
        // validation for constraint: float
        if (!is_null($recargoMonto) && !(is_float($recargoMonto) || is_numeric($recargoMonto))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($recargoMonto, true), gettype($recargoMonto)), __LINE__);
        }
        $this->RecargoMonto = $recargoMonto;
        return $this;
    }
    /**
     * Get MontoTotal value
     * @return float|null
     */
    public function getMontoTotal()
    {
        return $this->MontoTotal;
    }
    /**
     * Set MontoTotal value
     * @param float $montoTotal
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_DetalleItem
     */
    public function setMontoTotal($montoTotal = null)
    {
        // validation for constraint: float
        if (!is_null($montoTotal) && !(is_float($montoTotal) || is_numeric($montoTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($montoTotal, true), gettype($montoTotal)), __LINE__);
        }
        $this->MontoTotal = $montoTotal;
        return $this;
    }
    /**
     * Get DescuentoGlosa value
     * @return string|null
     */
    public function getDescuentoGlosa()
    {
        return $this->DescuentoGlosa;
    }
    /**
     * Set DescuentoGlosa value
     * @param string $descuentoGlosa
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_DetalleItem
     */
    public function setDescuentoGlosa($descuentoGlosa = null)
    {
        // validation for constraint: string
        if (!is_null($descuentoGlosa) && !is_string($descuentoGlosa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descuentoGlosa, true), gettype($descuentoGlosa)), __LINE__);
        }
        $this->DescuentoGlosa = $descuentoGlosa;
        return $this;
    }
    /**
     * Get RecargoGlosa value
     * @return string|null
     */
    public function getRecargoGlosa()
    {
        return $this->RecargoGlosa;
    }
    /**
     * Set RecargoGlosa value
     * @param string $recargoGlosa
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_DetalleItem
     */
    public function setRecargoGlosa($recargoGlosa = null)
    {
        // validation for constraint: string
        if (!is_null($recargoGlosa) && !is_string($recargoGlosa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recargoGlosa, true), gettype($recargoGlosa)), __LINE__);
        }
        $this->RecargoGlosa = $recargoGlosa;
        return $this;
    }
    /**
     * Get Familia value
     * @return string|null
     */
    public function getFamilia()
    {
        return $this->Familia;
    }
    /**
     * Set Familia value
     * @param string $familia
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_DetalleItem
     */
    public function setFamilia($familia = null)
    {
        // validation for constraint: string
        if (!is_null($familia) && !is_string($familia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($familia, true), gettype($familia)), __LINE__);
        }
        $this->Familia = $familia;
        return $this;
    }
    /**
     * Get DescuentoRecargo value
     * @return \App\Soap\StructType\DescuentoRecargo|null
     */
    public function getDescuentoRecargo()
    {
        return $this->DescuentoRecargo;
    }
    /**
     * Set DescuentoRecargo value
     * @param \App\Soap\StructType\DescuentoRecargo $descuentoRecargo
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_DetalleItem
     */
    public function setDescuentoRecargo(\App\Soap\StructType\DescuentoRecargo $descuentoRecargo = null)
    {
        $this->DescuentoRecargo = $descuentoRecargo;
        return $this;
    }
    /**
     * Get RetencionPercepcion value
     * @return \App\Soap\StructType\RetencionPercepcion|null
     */
    public function getRetencionPercepcion()
    {
        return $this->RetencionPercepcion;
    }
    /**
     * Set RetencionPercepcion value
     * @param \App\Soap\StructType\RetencionPercepcion $retencionPercepcion
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_DetalleItem
     */
    public function setRetencionPercepcion(\App\Soap\StructType\RetencionPercepcion $retencionPercepcion = null)
    {
        $this->RetencionPercepcion = $retencionPercepcion;
        return $this;
    }
    /**
     * Get CodigosProductoServicio value
     * @return \App\Soap\StructType\CodigosProductoServicio|null
     */
    public function getCodigosProductoServicio()
    {
        return $this->CodigosProductoServicio;
    }
    /**
     * Set CodigosProductoServicio value
     * @param \App\Soap\StructType\CodigosProductoServicio $codigosProductoServicio
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_DetalleItem
     */
    public function setCodigosProductoServicio(\App\Soap\StructType\CodigosProductoServicio $codigosProductoServicio = null)
    {
        $this->CodigosProductoServicio = $codigosProductoServicio;
        return $this;
    }
    /**
     * Get DatosAdicionales value
     * @return \App\Soap\StructType\DatosAdicionales|null
     */
    public function getDatosAdicionales()
    {
        return $this->DatosAdicionales;
    }
    /**
     * Set DatosAdicionales value
     * @param \App\Soap\StructType\DatosAdicionales $datosAdicionales
     * @return \App\Soap\StructType\EFactura_Definiciones_SDTCFEInterno_DetalleItem
     */
    public function setDatosAdicionales(\App\Soap\StructType\DatosAdicionales $datosAdicionales = null)
    {
        $this->DatosAdicionales = $datosAdicionales;
        return $this;
    }
}
