<?php

namespace App\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SDTWSCFEV1CAEData StructType
 * @subpackage Structs
 */
class SDTWSCFEV1CAEData extends AbstractStructBase
{
    /**
     * The Autorizacion
     * @var int
     */
    public $Autorizacion;
    /**
     * The Serie
     * @var string
     */
    public $Serie;
    /**
     * The Desde
     * @var int
     */
    public $Desde;
    /**
     * The Hasta
     * @var int
     */
    public $Hasta;
    /**
     * The Vencimiento
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Vencimiento;
    /**
     * Constructor method for SDTWSCFEV1CAEData
     * @uses SDTWSCFEV1CAEData::setAutorizacion()
     * @uses SDTWSCFEV1CAEData::setSerie()
     * @uses SDTWSCFEV1CAEData::setDesde()
     * @uses SDTWSCFEV1CAEData::setHasta()
     * @uses SDTWSCFEV1CAEData::setVencimiento()
     * @param int $autorizacion
     * @param string $serie
     * @param int $desde
     * @param int $hasta
     * @param string $vencimiento
     */
    public function __construct($autorizacion = null, $serie = null, $desde = null, $hasta = null, $vencimiento = null)
    {
        $this
            ->setAutorizacion($autorizacion)
            ->setSerie($serie)
            ->setDesde($desde)
            ->setHasta($hasta)
            ->setVencimiento($vencimiento);
    }
    /**
     * Get Autorizacion value
     * @return int|null
     */
    public function getAutorizacion()
    {
        return $this->Autorizacion;
    }
    /**
     * Set Autorizacion value
     * @param int $autorizacion
     * @return \App\Soap\StructType\SDTWSCFEV1CAEData
     */
    public function setAutorizacion($autorizacion = null)
    {
        // validation for constraint: int
        if (!is_null($autorizacion) && !(is_int($autorizacion) || ctype_digit($autorizacion))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($autorizacion, true), gettype($autorizacion)), __LINE__);
        }
        $this->Autorizacion = $autorizacion;
        return $this;
    }
    /**
     * Get Serie value
     * @return string|null
     */
    public function getSerie()
    {
        return $this->Serie;
    }
    /**
     * Set Serie value
     * @param string $serie
     * @return \App\Soap\StructType\SDTWSCFEV1CAEData
     */
    public function setSerie($serie = null)
    {
        // validation for constraint: string
        if (!is_null($serie) && !is_string($serie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serie, true), gettype($serie)), __LINE__);
        }
        $this->Serie = $serie;
        return $this;
    }
    /**
     * Get Desde value
     * @return int|null
     */
    public function getDesde()
    {
        return $this->Desde;
    }
    /**
     * Set Desde value
     * @param int $desde
     * @return \App\Soap\StructType\SDTWSCFEV1CAEData
     */
    public function setDesde($desde = null)
    {
        // validation for constraint: int
        if (!is_null($desde) && !(is_int($desde) || ctype_digit($desde))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($desde, true), gettype($desde)), __LINE__);
        }
        $this->Desde = $desde;
        return $this;
    }
    /**
     * Get Hasta value
     * @return int|null
     */
    public function getHasta()
    {
        return $this->Hasta;
    }
    /**
     * Set Hasta value
     * @param int $hasta
     * @return \App\Soap\StructType\SDTWSCFEV1CAEData
     */
    public function setHasta($hasta = null)
    {
        // validation for constraint: int
        if (!is_null($hasta) && !(is_int($hasta) || ctype_digit($hasta))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hasta, true), gettype($hasta)), __LINE__);
        }
        $this->Hasta = $hasta;
        return $this;
    }
    /**
     * Get Vencimiento value
     * @return string|null
     */
    public function getVencimiento()
    {
        return $this->Vencimiento;
    }
    /**
     * Set Vencimiento value
     * @param string $vencimiento
     * @return \App\Soap\StructType\SDTWSCFEV1CAEData
     */
    public function setVencimiento($vencimiento = null)
    {
        // validation for constraint: string
        if (!is_null($vencimiento) && !is_string($vencimiento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vencimiento, true), gettype($vencimiento)), __LINE__);
        }
        $this->Vencimiento = $vencimiento;
        return $this;
    }
}
