<?php

namespace App\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SDTWSCFEConsultarCFERecibidoDetalleInV1 StructType
 * @subpackage Structs
 */
class SDTWSCFEConsultarCFERecibidoDetalleInV1 extends AbstractStructBase
{
    /**
     * The Conexion
     * @var \App\Soap\StructType\SDTWSCFEConexionV1
     */
    public $Conexion;
    /**
     * The EmisorRUT
     * @var string
     */
    public $EmisorRUT;
    /**
     * The EmisorCFETipo
     * @var string
     */
    public $EmisorCFETipo;
    /**
     * The CFESerie
     * @var string
     */
    public $CFESerie;
    /**
     * The CFENumero
     * @var int
     */
    public $CFENumero;
    /**
     * Constructor method for SDTWSCFEConsultarCFERecibidoDetalleInV1
     * @uses SDTWSCFEConsultarCFERecibidoDetalleInV1::setConexion()
     * @uses SDTWSCFEConsultarCFERecibidoDetalleInV1::setEmisorRUT()
     * @uses SDTWSCFEConsultarCFERecibidoDetalleInV1::setEmisorCFETipo()
     * @uses SDTWSCFEConsultarCFERecibidoDetalleInV1::setCFESerie()
     * @uses SDTWSCFEConsultarCFERecibidoDetalleInV1::setCFENumero()
     * @param \App\Soap\StructType\SDTWSCFEConexionV1 $conexion
     * @param string $emisorRUT
     * @param string $emisorCFETipo
     * @param string $cFESerie
     * @param int $cFENumero
     */
    public function __construct(\App\Soap\StructType\SDTWSCFEConexionV1 $conexion = null, $emisorRUT = null, $emisorCFETipo = null, $cFESerie = null, $cFENumero = null)
    {
        $this
            ->setConexion($conexion)
            ->setEmisorRUT($emisorRUT)
            ->setEmisorCFETipo($emisorCFETipo)
            ->setCFESerie($cFESerie)
            ->setCFENumero($cFENumero);
    }
    /**
     * Get Conexion value
     * @return \App\Soap\StructType\SDTWSCFEConexionV1|null
     */
    public function getConexion()
    {
        return $this->Conexion;
    }
    /**
     * Set Conexion value
     * @param \App\Soap\StructType\SDTWSCFEConexionV1 $conexion
     * @return \App\Soap\StructType\SDTWSCFEConsultarCFERecibidoDetalleInV1
     */
    public function setConexion(\App\Soap\StructType\SDTWSCFEConexionV1 $conexion = null)
    {
        $this->Conexion = $conexion;
        return $this;
    }
    /**
     * Get EmisorRUT value
     * @return string|null
     */
    public function getEmisorRUT()
    {
        return $this->EmisorRUT;
    }
    /**
     * Set EmisorRUT value
     * @param string $emisorRUT
     * @return \App\Soap\StructType\SDTWSCFEConsultarCFERecibidoDetalleInV1
     */
    public function setEmisorRUT($emisorRUT = null)
    {
        // validation for constraint: string
        if (!is_null($emisorRUT) && !is_string($emisorRUT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emisorRUT, true), gettype($emisorRUT)), __LINE__);
        }
        $this->EmisorRUT = $emisorRUT;
        return $this;
    }
    /**
     * Get EmisorCFETipo value
     * @return string|null
     */
    public function getEmisorCFETipo()
    {
        return $this->EmisorCFETipo;
    }
    /**
     * Set EmisorCFETipo value
     * @param string $emisorCFETipo
     * @return \App\Soap\StructType\SDTWSCFEConsultarCFERecibidoDetalleInV1
     */
    public function setEmisorCFETipo($emisorCFETipo = null)
    {
        // validation for constraint: string
        if (!is_null($emisorCFETipo) && !is_string($emisorCFETipo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emisorCFETipo, true), gettype($emisorCFETipo)), __LINE__);
        }
        $this->EmisorCFETipo = $emisorCFETipo;
        return $this;
    }
    /**
     * Get CFESerie value
     * @return string|null
     */
    public function getCFESerie()
    {
        return $this->CFESerie;
    }
    /**
     * Set CFESerie value
     * @param string $cFESerie
     * @return \App\Soap\StructType\SDTWSCFEConsultarCFERecibidoDetalleInV1
     */
    public function setCFESerie($cFESerie = null)
    {
        // validation for constraint: string
        if (!is_null($cFESerie) && !is_string($cFESerie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cFESerie, true), gettype($cFESerie)), __LINE__);
        }
        $this->CFESerie = $cFESerie;
        return $this;
    }
    /**
     * Get CFENumero value
     * @return int|null
     */
    public function getCFENumero()
    {
        return $this->CFENumero;
    }
    /**
     * Set CFENumero value
     * @param int $cFENumero
     * @return \App\Soap\StructType\SDTWSCFEConsultarCFERecibidoDetalleInV1
     */
    public function setCFENumero($cFENumero = null)
    {
        // validation for constraint: int
        if (!is_null($cFENumero) && !(is_int($cFENumero) || ctype_digit($cFENumero))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cFENumero, true), gettype($cFENumero)), __LINE__);
        }
        $this->CFENumero = $cFENumero;
        return $this;
    }
}
